package com.ensoft.sancorform.ui.activity;

import android.app.DatePickerDialog;
import android.app.Dialog;
import android.graphics.Color;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.text.InputType;
import android.util.Patterns;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.CheckBox;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import com.afollestad.materialdialogs.MaterialDialog;
import com.ensoft.restafari.ui.view.RequestResponseAppCompatActivity;
import com.ensoft.sancorform.App;
import com.ensoft.sancorform.R;
import com.ensoft.sancorform.domain.model.ClientModel;
import com.ensoft.sancorform.domain.model.LocationModel;
import com.ensoft.sancorform.domain.model.StateModel;
import com.ensoft.sancorform.domain.table.ClientTable;
import com.ensoft.sancorform.domain.table.LocationTable;
import com.ensoft.sancorform.domain.table.StateTable;
import com.ensoft.sancorform.infrastructure.helper.DateHelper;
import com.ensoft.sancorform.infrastructure.service.network.request.ClientsPostRequest;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;
import ir.mirrajabi.searchdialog.SimpleSearchDialogCompat;
import julianfalcionelli.magicform.MagicForm;
import julianfalcionelli.magicform.base.FormError;
import julianfalcionelli.magicform.base.FormField;
import julianfalcionelli.magicform.base.ValidationMode;
import julianfalcionelli.magicform.base.ValidatorCallbacks;
import julianfalcionelli.magicform.validation.ValidationNotEmpty;
import julianfalcionelli.magicform.validation.ValidationRegex;

public class MainActivity extends RequestResponseAppCompatActivity implements DatePickerDialog.OnDateSetListener, ValidatorCallbacks
{
	@BindView( R.id.state_edit ) TextView stateView;
	@BindView( R.id.location_edit ) TextView locationView;
	@BindView( R.id.day_edit ) TextView dayView;
	@BindView( R.id.month_edit ) TextView monthView;
	@BindView( R.id.year_edit ) TextView yearView;
	@BindView( R.id.name_edit ) EditText nameEdit;
	@BindView( R.id.surname_edit ) EditText surnameEdit;
	@BindView( R.id.phone_pre_edit ) EditText phonePreEdit;
	@BindView( R.id.phone_edit ) EditText phoneEdit;
	@BindView( R.id.email_edit ) EditText emailEdit;
	@BindView( R.id.loading_container ) View loadingContainer;
	@BindView( R.id.loading_title ) TextView loadingTitle;
	@BindView( R.id.is_member_checkbox ) CheckBox isMemberCheckBox;
	
	protected ArrayList<StateModel> stateModels;
	protected ArrayList<LocationModel> locationModels;
	protected StateModel stateSelected;
	protected LocationModel locationSelected;
	protected String dateSelected;
	protected MagicForm formValidator;
	protected long hiddenButtonLeftClickTime;
	protected long clientPostRequestId;
	
	@Override
	protected void onCreate( Bundle savedInstanceState )
	{
		super.onCreate( savedInstanceState );
		
		setContentView( R.layout.activity_main );
		
		ButterKnife.bind( this );
		
		stateModels = new ArrayList<>( new StateTable().getAllToModelList( null, null, "provincia ASC", null ) );
		
		formValidator = new MagicForm()
			.addField( new FormField(emailEdit).addValidation( new ValidationRegex( Patterns.EMAIL_ADDRESS ).setMessage("Mail inválido") ) )
			.addField( new FormField(nameEdit).addValidation( new ValidationNotEmpty().setMessage("Campo requerido") ) )
			.addField( new FormField(surnameEdit).addValidation( new ValidationNotEmpty().setMessage("Campo requerido") ) )
			.addField( new FormField(phoneEdit).addValidation( new ValidationRegex( Patterns.PHONE ).setMessage("Teléfono inválido") ) )
			.addField( new FormField(phonePreEdit).addValidation( new ValidationRegex( Patterns.PHONE ).setMessage("Código de área inválido") ) )
			.addField( new FormField(stateView).addValidation( new ValidationNotEmpty().setMessage("Campo requerido") ) )
			.addField( new FormField(locationView).addValidation( new ValidationNotEmpty().setMessage("Campo requerido") ) )
			.addField( new FormField(dayView).addValidation( new ValidationNotEmpty().setMessage("Campo requerido") ) )
			.addField( new FormField(monthView).addValidation( new ValidationNotEmpty().setMessage("Campo requerido") ) )
			.addField( new FormField(yearView).addValidation( new ValidationNotEmpty().setMessage("Campo requerido") ) )
			.setListener(this)
			.setMode( ValidationMode.ON_VALIDATE );
		
		formValidator.setDeepValidation( true );
	}
	
	@OnClick( { R.id.day_edit, R.id.month_edit, R.id.year_edit } )
	protected void onBirthDayClick()
	{
		Calendar now = Calendar.getInstance();
		
		new DatePickerDialog( this, this, now.get(Calendar.YEAR), now.get(Calendar.MONTH), now.get(Calendar.DAY_OF_MONTH) ).show();
	}
	
	protected void setupDialog( final SimpleSearchDialogCompat searchDialogCompat )
	{
		searchDialogCompat.getSearchBox().setTextSize( getResources().getDimension( R.dimen.search_box_text_size ) );
		int w = (int)( getWindow().getDecorView().getWidth() * 0.7 );
		int h = (int)( getWindow().getDecorView().getHeight() * 0.6 );
		if ( null != searchDialogCompat.getWindow() )
			searchDialogCompat.getWindow().setLayout( w, h );
		new Handler().postDelayed( () -> showSoftKeyboard( searchDialogCompat.getSearchBox() ), 500 );
	}
	
	@OnClick( R.id.state_edit )
	protected void onStateClick()
	{
		SimpleSearchDialogCompat searchDialogCompat = new SimpleSearchDialogCompat<>(this, "Provincia", "Buscar provincia...", null, stateModels,
		(dialog, item, position) ->
		{
			if ( !item.toString().equals( stateView.getText().toString() ) )
			{
				stateSelected = item;
				locationSelected = null;
				stateView.setText( item.toString() );
				locationView.setText( "" );
				loadingContainer.setVisibility( View.VISIBLE );
				loadingTitle.setText( "CARGANDO LOCALIDADES" );
				
				new Thread( () -> {
					locationModels = new ArrayList<>( new LocationTable().getAllToModelList( "provincia_id = ?", new String[]{ String.valueOf( item.getId() ) }, "localidad ASC", null ) );
					
					runOnUiThread( () -> loadingContainer.setVisibility( View.GONE ) );
				} ).start();
				
			}
			
			dialog.dismiss();
		});
		
		searchDialogCompat.show();
		setupDialog( searchDialogCompat );
	}
	
	@OnClick( R.id.location_edit )
	protected void onLocationClick()
	{
		if ( null == locationModels || locationModels.size() == 0 )
			return;
		
		SimpleSearchDialogCompat searchDialogCompat = new SimpleSearchDialogCompat<>(this, "Localidad", "Buscar localidad...", null, locationModels,
		( dialog, item, position) ->
		{
			locationSelected = item;
			locationView.setText( item.toString() );
			
			dialog.dismiss();
			
			hideSoftKeyboard();
		});
		
		searchDialogCompat.show();
		setupDialog( searchDialogCompat );
	}
	
	@Override
	public void onDateSet( DatePicker view, int year, int month, int dayOfMonth )
	{
		dayView.setText( String.valueOf( dayOfMonth ) );
		monthView.setText( DateHelper.formatMonth( month, Locale.getDefault() ) );
		yearView.setText( String.valueOf( year ) );
		dateSelected = String.valueOf( year ) + "-" + String.format( Locale.getDefault(), "%02d", month + 1 ) + "-" + String.format( Locale.getDefault(), "%02d", dayOfMonth );
	}
	
	protected void resetAll()
	{
		nameEdit.setText( "" );
		surnameEdit.setText( "" );
		dayView.setText( "" );
		monthView.setText( "" );
		yearView.setText( "" );
		dateSelected = null;
		phonePreEdit.setText( "" );
		phoneEdit.setText( "" );
		emailEdit.setText( "" );
		stateView.setText( "" );
		stateSelected = null;
		locationView.setText( "" );
		locationSelected = null;
		locationModels = null;
		isMemberCheckBox.setChecked( false );
	}
	
	@OnClick( R.id.save_button )
	protected void onSaveClick()
	{
		formValidator.validate();
	}
	
	@Override
	public void onSuccess()
	{
		if ( stateSelected != null && locationSelected != null )
		{
			ClientModel clientModel = new ClientModel(
				nameEdit.getText().toString(),
				surnameEdit.getText().toString(),
				dateSelected,
				phonePreEdit.getText().toString() + "-" + phoneEdit.getText().toString(),
				emailEdit.getText().toString(),
				stateSelected.getId(),
				locationSelected.getId(),
				isMemberCheckBox.isChecked() );
			
			new ClientTable().insert( clientModel );
			
			resetAll();
			
			Toast.makeText( this, "Formulario guardado", Toast.LENGTH_LONG ).show();
		}
	}
	
	@Override
	public void onFailed( List<FormError> errors )
	{}
	
	@OnClick( R.id.hidden_button_left )
	protected void onHiddenButtonLeftClick()
	{
		hiddenButtonLeftClickTime = System.currentTimeMillis();
	}
	
	@OnClick( R.id.hidden_button_right )
	protected void onHiddenButtonRightClick()
	{
		if ( System.currentTimeMillis() - hiddenButtonLeftClickTime < 1000 )
		{
			new MaterialDialog.Builder(this)
				.title("PROMOCIÓN")
				.content("Ingresa el nombre de la promoción")
				.inputType( InputType.TYPE_CLASS_TEXT )
				.input( "Nombre de promoción",
					App.getInstance().getPreferencesService().getPromoName(),
					(dialog, input) -> App.getInstance().getPreferencesService().setPromoName( input.toString() )
				)
				.positiveText( "ACEPTAR" )
				.negativeText( "CANCELAR" )
				.widgetColor( Color.WHITE ).show().getInputEditText().setTextColor( Color.BLACK );
		}
	}
	
	@OnClick( R.id.logo_image )
	protected void onLogoClick()
	{
		new MaterialDialog.Builder(this)
			.title("ENVIAR DATOS")
			.content("Seleccionar el número de tablet a enviar los datos")
			.inputType( InputType.TYPE_CLASS_NUMBER | InputType.TYPE_NUMBER_FLAG_SIGNED )
			.input( "Número de tablet",
				App.getInstance().getPreferencesService().getTabletNum(),
				(dialog, input) -> {
					App.getInstance().getPreferencesService().setTabletNum( input.toString() );
					
					ClientsPostRequest.send( ( requestId ) -> getRequestReceiverService().addRequest( clientPostRequestId = requestId ) );
					
					loadingTitle.setText( "ENVIANDO DATOS AL SERVIDOR" );
					loadingContainer.setVisibility( View.VISIBLE );
					
					hideSoftKeyboard();
				}
			)
			.positiveText( "ENVIAR" )
			.negativeText( "CANCELAR" )
			.widgetColor( Color.WHITE ).show().getInputEditText().setTextColor( Color.BLACK );
	}
	
	@Override
	public void onRequestSuccess( long requestId )
	{
		if ( clientPostRequestId == requestId )
		{
			Toast.makeText( this, "Datos enviados al servidor exitosamente.", Toast.LENGTH_LONG ).show();
		}
	}
	
	@Override
	public void onRequestError( long requestId, int resultCode, String resultMsg )
	{
		if ( clientPostRequestId == requestId )
		{
			Toast.makeText( this, "Error al comunicarse con el servidor. Vuelva a intentarlo más tarde.", Toast.LENGTH_LONG ).show();
		}
	}
	
	@Override
	public void onRequestFinished( long requestId )
	{
		super.onRequestFinished( requestId );
		
		if ( clientPostRequestId == requestId )
		{
			loadingContainer.setVisibility( View.GONE );
		}
	}
	
	public void showSoftKeyboard(View view)
	{
		InputMethodManager inputMethodManager = (InputMethodManager) getSystemService(INPUT_METHOD_SERVICE);
		view.requestFocus();
		inputMethodManager.showSoftInput(view, 0);
	}
	
	public void hideSoftKeyboard()
	{
		if ( getCurrentFocus() != null )
		{
			InputMethodManager inputMethodManager = (InputMethodManager) getSystemService(INPUT_METHOD_SERVICE);
			inputMethodManager.hideSoftInputFromWindow(getCurrentFocus().getWindowToken(), 0);
		}
	}
	
	@Override
	public boolean dispatchTouchEvent(MotionEvent ev)
	{
		if ( ev.getAction() == MotionEvent.ACTION_DOWN )
		{
			View view = getCurrentFocus();
			if ( view != null && view instanceof EditText )
			{
				Rect r = new Rect();
				view.getGlobalVisibleRect(r);
				int rawX = (int)ev.getRawX();
				int rawY = (int)ev.getRawY();
				
				if (!r.contains(rawX, rawY))
				{
					view.clearFocus();
					
					hideSoftKeyboard();
				}
			}
		}
		
		return super.dispatchTouchEvent(ev);
	}
	
	@Override
	public void onBackPressed()
	{
		moveTaskToBack( true );
	}
}
