package com.ensoft.sancorform.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.widget.Toast;

import com.ensoft.sancorform.R;
import com.ensoft.sancorform.infrastructure.service.DatabaseInitializerService;

import butterknife.ButterKnife;

public class LoadingActivity extends AppCompatActivity implements DatabaseInitializerService.InitializerListener
{
	@Override
	protected void onCreate( Bundle savedInstanceState )
	{
		super.onCreate( savedInstanceState );
		setContentView( R.layout.activity_loading );
		ButterKnife.bind( this );
		
		if ( null == savedInstanceState )
			new Thread( () -> new DatabaseInitializerService( LoadingActivity.this ).init( LoadingActivity.this ) ).start();
	}
	
	@Override
	public void onDatabaseInitialized()
	{
		startActivity( new Intent( this, MainActivity.class ) );
		finish();
	}
	
	@Override
	public void onDatabaseInitializationFailed( String error )
	{
		runOnUiThread( () -> Toast.makeText( this, "Database Initialization failed: " + error, Toast.LENGTH_LONG ).show() );
		finish();
	}
}
