package com.ensoft.sancorform.infrastructure.service.network.response;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;

import com.ensoft.restafari.network.processor.ResponseProcessor;
import com.ensoft.restafari.network.rest.request.RequestConfiguration;
import com.ensoft.sancorform.domain.model.ClientModel;
import com.ensoft.sancorform.domain.table.ClientTable;
import com.ensoft.sancorform.infrastructure.service.network.dto.ClientsPostDTO;

public class ClientsPostResponse extends ResponseProcessor<ClientsPostDTO>
{
	@Override
	public void handleResponse( Context context, RequestConfiguration request, ClientsPostDTO response )
	{
		if ( null != response && null != response.clientModels && response.clientModels.length > 0 )
		{
			for ( ClientModel clientModel : response.clientModels )
			{
				clientModel.setDirty( false );
			}
			
			new ClientTable().insertOrUpdate( response.clientModels );
		}
	}
	
	@Override
	public void handleError( Context context, RequestConfiguration request, int errorCode, String errorMessage )
	{
		if ( !TextUtils.isEmpty( errorMessage ) )
			Log.e( ClientsPostResponse.class.getCanonicalName(), errorMessage );
	}
}
