package com.ensoft.sancorform.infrastructure.service.network.request;

import com.android.volley.Response;
import com.ensoft.restafari.network.helper.RequestParameters;
import com.ensoft.restafari.network.rest.request.AsyncRequestContent;
import com.ensoft.restafari.network.rest.request.AsyncRequestSender;
import com.ensoft.restafari.network.rest.request.AsyncRequestSentListener;
import com.ensoft.restafari.network.rest.request.BaseJsonRequest;
import com.ensoft.restafari.network.rest.request.RequestConfiguration;
import com.ensoft.sancorform.App;
import com.ensoft.sancorform.domain.model.ClientModel;
import com.ensoft.sancorform.domain.table.ClientTable;
import com.ensoft.sancorform.infrastructure.service.network.EndpointsService;
import com.ensoft.sancorform.infrastructure.service.network.dto.ClientsPostDTO;
import com.ensoft.sancorform.infrastructure.service.network.response.ClientsPostResponse;

import org.json.JSONObject;

import java.util.Map;

public class ClientsPostRequest extends BaseJsonRequest
{
	public ClientsPostRequest( JSONObject parameters, Map<String, String> headers, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener )
	{
		super( Method.PUT, EndpointsService.fromPath( "/clients" ), parameters, headers, listener, errorListener );
	}
	
	public static void send( AsyncRequestSentListener asyncRequestSentListener )
	{
		new AsyncRequestSender( new AsyncRequestContent( asyncRequestSentListener )
		{
			@Override
			public JSONObject getRequestParameters()
			{
				ClientModel[] dirty = new ClientTable().getDirty();
				
				if ( null != dirty && dirty.length > 0 )
				{
					RequestParameters parameters = new RequestParameters();
					parameters.putString( "promo_name", App.getInstance().getPreferencesService().getPromoName() + " - TABLET " + App.getInstance().getPreferencesService().getTabletNum() );
					parameters.putString( "tablet_num", App.getInstance().getPreferencesService().getTabletNum() );
					parameters.putObjectArray( "clients", dirty );
					
					return parameters;
				}
				
				return null;
			}
			
			@Override
			public RequestConfiguration getRequestConfiguration()
			{
				return new RequestConfiguration( ClientsPostRequest.class, ClientsPostResponse.class, ClientsPostDTO.class );
			}
		} ).start();
	}
}
