package com.ensoft.sancorform.infrastructure.service.network;

import com.ensoft.restafari.network.helper.RequestParameters;
import com.ensoft.sancorform.BuildConfig;

import org.json.JSONObject;

public class EndpointsService
{
	public static final String BASE_URL = /*BuildConfig.DEBUG ? "http://ensoft.no-ip.org/api" : */"http://lafamiliaestodo.com.ar/sancorapi/api";
	
	public static String fromPath( String path )
	{
		return BASE_URL + path;
	}
	
	public static String fromPath( String path, JSONObject parameters )
	{
		return fromPath( path + RequestParameters.getUrlQuery( parameters ) );
	}
	
	public static String fromPath( String path, JSONObject parameters, String idFieldName )
	{
		try
		{
			long id = parameters.getLong( idFieldName );
			
			if ( !path.endsWith( "/" ) )
			{
				path += "/";
			}
			
			path += String.valueOf( id );
		}
		catch ( Exception e )
		{
		}
		
		return fromPath( path + RequestParameters.getUrlQuery( parameters ) );
	}
}