package com.ensoft.sancorform.infrastructure.service;

import android.content.Context;
import android.text.TextUtils;

import com.ensoft.sancorform.domain.model.LocationsModel;
import com.ensoft.sancorform.domain.table.LocationTable;
import com.ensoft.sancorform.domain.table.StateTable;
import com.google.gson.Gson;

public class DatabaseInitializerService
{
	public interface InitializerListener
	{
		void onDatabaseInitialized();
		
		void onDatabaseInitializationFailed( String error );
	}
	
	protected Context context;
	
	public DatabaseInitializerService( Context context )
	{
		this.context = context;
	}
	
	public void init( InitializerListener initializerListener )
	{
		try
		{
			StateTable stateTable = new StateTable();
			
			if ( stateTable.isEmpty() )
			{
				String locationsString = new AssetService( context ).getTextFile( "locations.json" );
				
				if ( !TextUtils.isEmpty( locationsString ) )
				{
					LocationsModel locationsModel = new Gson().fromJson( locationsString, LocationsModel.class );
					
					stateTable.insertOrUpdate( locationsModel.states );
					
					new LocationTable().insertOrUpdate( locationsModel.locations );
				}
			}
			
			if ( null != initializerListener )
				initializerListener.onDatabaseInitialized();
		}
		catch ( Exception e )
		{
			if ( null != initializerListener )
				initializerListener.onDatabaseInitializationFailed( e.toString() );
		}
	}
}
