package com.ensoft.sancorform.infrastructure.service;

import android.content.Context;

import java.io.IOException;
import java.io.InputStream;

public class AssetService
{
	protected Context context;
	
	public AssetService( Context context )
	{
		this.context = context;
	}
	
	public String getTextFile( String path )
	{
		String content;
		
		try {
			InputStream is = context.getAssets().open( path );
			
			int size = is.available();
			
			byte[] buffer = new byte[size];
			
			is.read(buffer);
			
			is.close();
			
			content = new String(buffer, "UTF-8");
		}
		catch ( IOException ex )
		{
			return null;
		}
		
		return content;
	}
}
