package com.ensoft.sancorform.infrastructure.preference;

import android.content.Context;

import com.ensoft.restafari.network.service.NetworkPreferencesService;

public class PreferencesService extends NetworkPreferencesService
{
	public static final String PROMO_NAME = "promoName";
	public static final String TABLET_NUM = "tabletNum";
	
	public PreferencesService( Context context )
	{
		super( context );
	}
	
	public void setPromoName( String name )
	{
		getDefaultSharedPreferences().edit().putString( PROMO_NAME, name ).apply();
	}
	
	public String getPromoName()
	{
		return getDefaultSharedPreferences().getString( PROMO_NAME, "APP RETIRO-18" );
	}
	
	public void setTabletNum( String name )
	{
		getDefaultSharedPreferences().edit().putString( TABLET_NUM, name ).apply();
	}
	
	public String getTabletNum()
	{
		return getDefaultSharedPreferences().getString( TABLET_NUM, "0" );
	}
}
