package com.ensoft.sancorform.infrastructure.helper;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;

public class DateHelper
{
	public static String formatMonth( int month, Locale locale )
	{
		DateFormat formatter = new SimpleDateFormat("MMM", locale);
		GregorianCalendar calendar = new GregorianCalendar();
		calendar.set( Calendar.DAY_OF_MONTH, 1);
		calendar.set(Calendar.MONTH, month);
		String ret = formatter.format(calendar.getTime());
		return ret.substring( 0, 1 ).toUpperCase() + ret.substring( 1 ).replace( ".", "" );
	}
	
	public static long getCurrentTimestamp()
	{
		return Calendar.getInstance().getTime().getTime() / 1000L;
	}
}
