package com.ensoft.sancorform.domain.table;

import android.database.sqlite.SQLiteDatabase;

import com.ensoft.restafari.database.DatabaseDataType;
import com.ensoft.restafari.database.DatabaseTableModel;
import com.ensoft.restafari.database.TableColumn;
import com.ensoft.sancorform.domain.model.ClientModel;

public class ClientTable extends DatabaseTableModel<ClientModel>
{
	public ClientTable()
	{
		super( ClientModel.class );
	}
	
	public ClientModel[] getDirty()
	{
		return getAllToModelArray( "dirty = 1", null, null, null );
	}
	
	@Override
	public void upgrade( SQLiteDatabase db, int oldVersion, int newVersion )
	{
		if ( oldVersion == 1 && newVersion == 2 )
		{
			addColumn( db, new TableColumn( "is_member", DatabaseDataType.BOOLEAN ) );
		}
	}
}
