package com.ensoft.sancorform.domain.model;

import com.ensoft.restafari.database.DatabaseModel;
import com.ensoft.restafari.database.annotations.DbCompositeIndex;
import com.ensoft.restafari.database.annotations.DbField;
import com.ensoft.restafari.database.annotations.DbForeignKey;
import com.ensoft.restafari.database.annotations.DbIndex;
import com.ensoft.restafari.database.annotations.DbPrimaryKey;
import com.google.gson.annotations.SerializedName;

import java.io.Serializable;

import ir.mirrajabi.searchdialog.core.Searchable;

@DbCompositeIndex( value = { "provincia_id", "localidad" } )
public class LocationModel extends DatabaseModel implements Searchable, Serializable
{
	@DbField
	@DbPrimaryKey
	@SerializedName( "localidad_id" )
	protected int id;
	
	@DbField
	@DbForeignKey( value = "StateModel.provincia_id", onDelete = DbForeignKey.CASCADE )
	@DbIndex
	@SerializedName( "provincia_id" )
	protected int stateId;
	
	@DbField
	@SerializedName( "localidad" )
	protected String location;
	
	@DbField
	@SerializedName( "cp" )
	protected String postalCode;
	
	@DbField
	@SerializedName( "cp_completo" )
	protected String postalCodeComplete;
	
	@Override
	public String toString()
	{
		return location;
	}
	
	@Override
	public String getTitle()
	{
		return location;
	}
	
	public int getId()
	{
		return id;
	}
	
	public int getStateId()
	{
		return stateId;
	}
	
	public String getLocation()
	{
		return location;
	}
	
	public String getPostalCode()
	{
		return postalCode;
	}
	
	public String getPostalCodeComplete()
	{
		return postalCodeComplete;
	}
}
