package com.ensoft.sancorform.domain.model;

import com.ensoft.restafari.database.DatabaseModel;
import com.ensoft.restafari.database.annotations.DbField;
import com.ensoft.restafari.database.annotations.DbForeignKey;
import com.ensoft.restafari.database.annotations.DbIndex;
import com.ensoft.sancorform.infrastructure.helper.DateHelper;
import com.google.gson.annotations.SerializedName;

import java.io.Serializable;

public class ClientModel extends DatabaseModel implements Serializable
{
	@DbField
	protected String name;
	
	@DbField
	protected String surname;
	
	@DbField
	protected String birthday;
	
	@DbField
	protected String phone;
	
	@DbField
	protected String email;
	
	@DbField
	@SerializedName( "state_id" )
	protected int stateId;
	
	@DbField
	@SerializedName( "location_id" )
	@DbForeignKey( value = "LocationModel.localidad_id", onDelete = DbForeignKey.CASCADE )
	protected int locationId;
	
	@DbField
	@SerializedName( "is_member" )
	protected boolean isMember;
	
	@DbField
	@SerializedName( "creation_time" )
	protected long creationTime;
	
	@DbField
	@DbIndex
	protected boolean dirty;
	
	public ClientModel()
	{}
	
	public ClientModel( String name, String surname, String birthday, String phone, String email, int stateId, int locationId, boolean isMember )
	{
		this.name = name;
		this.surname = surname;
		this.birthday = birthday;
		this.phone = phone;
		this.email = email;
		this.stateId = stateId;
		this.locationId = locationId;
		this.creationTime = DateHelper.getCurrentTimestamp();
		this.isMember = isMember;
		this.dirty = true;
	}
	
	public String getName()
	{
		return name;
	}
	
	public void setName( String name )
	{
		this.name = name;
	}
	
	public String getSurname()
	{
		return surname;
	}
	
	public void setSurname( String surname )
	{
		this.surname = surname;
	}
	
	public String getBirthday()
	{
		return birthday;
	}
	
	public void setBirthday( String birthday )
	{
		this.birthday = birthday;
	}
	
	public String getPhone()
	{
		return phone;
	}
	
	public void setPhone( String phone )
	{
		this.phone = phone;
	}
	
	public String getEmail()
	{
		return email;
	}
	
	public void setEmail( String email )
	{
		this.email = email;
	}
	
	public int getStateId()
	{
		return stateId;
	}
	
	public void setStateId( int stateId )
	{
		this.stateId = stateId;
	}
	
	public int getLocationId()
	{
		return locationId;
	}
	
	public void setLocationId( int locationId )
	{
		this.locationId = locationId;
	}
	
	public boolean isMember()
	{
		return isMember;
	}
	
	public void setIsMember( boolean member )
	{
		isMember = member;
	}
	
	public boolean isDirty()
	{
		return dirty;
	}
	
	public void setDirty( boolean dirty )
	{
		this.dirty = dirty;
	}
}
