package com.ensoft.sancorform;

import android.app.Application;
import android.content.Context;
import android.content.res.Configuration;

import com.android.volley.DefaultRetryPolicy;
import com.ensoft.restafari.database.DatabaseService;
import com.ensoft.restafari.database.TableCollection;
import com.ensoft.restafari.network.helper.NetworkLogHelper;
import com.ensoft.restafari.network.service.RequestService;
import com.ensoft.restafari.network.service.RequestServiceOptions;
import com.ensoft.sancorform.domain.table.ClientTable;
import com.ensoft.sancorform.domain.table.LocationTable;
import com.ensoft.sancorform.domain.table.StateTable;
import com.ensoft.sancorform.infrastructure.preference.PreferencesService;

import java.util.Locale;

import static com.android.volley.DefaultRetryPolicy.DEFAULT_BACKOFF_MULT;
import static com.android.volley.DefaultRetryPolicy.DEFAULT_MAX_RETRIES;

public class App extends Application
{
	protected static App instance;
	protected PreferencesService preferencesService;
	protected RequestService requestService;
	
	@Override
	@SuppressWarnings("deprecation")
	public void onCreate()
	{
		super.onCreate();
		
		Locale locale = new Locale("ES");
		Locale.setDefault(locale);
		Configuration config = new Configuration();
		config.locale = locale;
		getResources().updateConfiguration(config, getResources().getDisplayMetrics());
		
		requestService = RequestService.init( this, new RequestServiceOptions.Builder().setDefaultRetryPolicy( new DefaultRetryPolicy( 60000, DEFAULT_MAX_RETRIES, DEFAULT_BACKOFF_MULT ) ).build() );
		
		preferencesService = new PreferencesService( this );
		
		instance = this;
		
		NetworkLogHelper.LOG_DEBUG_INFO = BuildConfig.DEBUG;
	}
	
	@Override
	protected void attachBaseContext(Context base)
	{
		super.attachBaseContext( base );
		
		TableCollection tableCollection = new TableCollection( "sancorform", 2 );
		
		tableCollection.add( new StateTable() );
		tableCollection.add( new LocationTable() );
		tableCollection.add( new ClientTable() );
		
		DatabaseService.init( this, tableCollection );
	}
	
	public PreferencesService getPreferencesService()
	{
		return preferencesService;
	}
	
	public RequestService getRequestService()
	{
		return requestService;
	}
	
	public static App getInstance()
	{
		return instance;
	}
}
