<?php

namespace ThalamusSDK;

use \ThalamusSDK\Model\Person;

/**
 * ThalamusSession
 *
 * @author Ezequiel
 */
class ThalamusSession {
	/**
	 * El index donde se guarda la sesion en $_SESSION
	 * @const string
	 */
	const SESSION_NAME = "thalamus_session";
	
	/**
	 * Basic Auth User
	 *
	 * @var string
	 */
	private $user = '';
	
	/**
	 * 
	 * @var unknown
	 */
	private $sudo_id = '';
	
	/**
	 * 
	 * @var unknown
	 */
	private $sudo = false;
	
	/**
	 * Basic Auth Password
	 *
	 * @var string
	 */
	private $accessToken = '';
	
	/**
	 *
	 * @var string
	 */
	private $tags = null;
	
	/**
	 *
	 * @var integer
	 */
	private $source = null;
	
	/**
	 * Person
	 *
	 * @var Person
	 */
	private $person = false;
	
	/**
	 */
	private function __construct() {
		$_SESSION [self::SESSION_NAME] = array (
				'obj' => $this 
		);
	}
	
	/**
	 *
	 * @return \ThalamusSDK\ThalamusSession
	 */
	private static function _reConstruct() {
		
		if (isset ( $_SESSION [self::SESSION_NAME] ['serialized_obj'] ) and (unserialize ( $_SESSION [self::SESSION_NAME] ['serialized_obj'] ) != null)) {
			
			return unserialize ( $_SESSION [self::SESSION_NAME] ['serialized_obj'] );
		}
		
		return new ThalamusSession ();
	}
	
	/**
	 */
	private static function _sessionStart() {
// 		if (! isset ( $_SESSION )) {
// 			session_start ();
// 		}
		/**
 		* Fix PHP >= 5.4.0 
 		*/
		if (function_exists('session_status') && (defined('PHP_SESSION_NONE') && session_status() == PHP_SESSION_NONE) || !session_id()) {
			session_start();
		}
		
	}
	
	/**
	 */
	public function __destruct() {
		self::_sessionStart ();
		if ($this->getUser () != "")
			$_SESSION [self::SESSION_NAME] ['serialized_obj'] = serialize ( $this );
	}
	
	/**
	 */
	public function destroy() {
		self::_sessionStart ();
		$this->reset ();
		
		$this->setTags ( null );
		$this->setSource ( null );
		
		session_destroy ();
	}
	
	/**
	 */
	public function reset() {
		$this->setUser ( "" );
		$this->setAccessToken ( "" );
		$this->person = false;
	}
	
	/**
	 */
	public static function getSession() {
		self::_sessionStart ();
		
		$session = ! empty ( $_SESSION [self::SESSION_NAME] ['obj'] ) ? $_SESSION [self::SESSION_NAME] ['obj'] : self::_reConstruct ();
		
		if (isset($_SESSION["LAST_ACTIVITY"])) {
				
			if (time() - $_SESSION["LAST_ACTIVITY"] > 900) {
				
				$session->destroy();

				return ! empty ( $_SESSION [self::SESSION_NAME] ['obj'] ) ? $_SESSION [self::SESSION_NAME] ['obj'] : self::_reConstruct ();
				
			} else if (time() - $_SESSION["LAST_ACTIVITY"] > 1) {
					
				$_SESSION["LAST_ACTIVITY"] = time(); // update last activity time stamp
				
			}
			
		} else {
			$_SESSION["LAST_ACTIVITY"] = time(); // update last activity time stamp
		}
		
		return $session;
	}
	
	/**
	 *
	 * @param string $user        	
	 * @return \ThalamusSDK\ThalamusSession
	 */
	public function setUser($user) {
		$this->user = $user;
		return $this;
	}
	
	/**
	 * 
	 * @param unknown $party_id
	 * @return \ThalamusSDK\ThalamusSession
	 */
	public function setSudoId($party_id) {
		$this->sudo_id = $party_id;
		return $this;
	}
	
	public function getSudoId() {
		return $this->sudo_id;
	}
	
	/**
	 * 
	 * @param unknown $bool
	 * @return \ThalamusSDK\ThalamusSession
	 */
	public function setSudo($bool) {
		$this->sudo = $bool;
		return $this;
	}
	
	public function getSudo() {
		return $this->sudo;
	}
	
	/**
	 *
	 * @param string $accessToken        	
	 * @return \ThalamusSDK\ThalamusSession
	 */
	public function setAccessToken($accessToken) {
		$this->accessToken = $accessToken;
		return $this;
	}
	
	/**
	 *
	 * @param $person        	
	 */
	public function setPerson($person) {
		return $this->person = $person;
	}
	
	/**
	 *
	 * @param unknown $tags        	
	 * @return \ThalamusSDK\ThalamusSession
	 */
	public function setTags($tags) {
		$this->tags = $tags;
		return $this;
	}
	
	/**
	 *
	 * @param unknown $source        	
	 * @return \ThalamusSDK\ThalamusSession
	 */
	public function setSource($source) {
		$this->source = $source;
		return $this;
	}
	
	/**
	 */
	public function getTags() {
		return $this->tags;
	}
	
	/**
	 */
	public function getSource() {
		return $this->source;
	}
	
	/**
	 */
	public function getUser() {
		return ($this->sudo and !empty($this->sudo_id)) ? $this->user . ".RunAs." . $this->sudo_id : $this->user;
	}
	
	/**
	 * 
	 */
	public function getRealUser() {
		return $this->user;
	}
	
	/**
	 */
	public function getAccessToken() {
		return $this->accessToken;
	}
	
	/**
	 */
	public function getPerson() {
		return $this->person;
	}
	
	/**
	 */
	public static function sessionExists() {
		return isset ( $_SESSION [self::SESSION_NAME] );
	}
}