<?php

namespace ThalamusSDK;

/**
 */
use \ThalamusSDK\Thalamus;

class ThalamusHelper {
	/**
	 * channels de comunicaciones de Thalamus
	 *
	 * @var array channels
	 */
	public static $channels = array (
			'Email' => 6001,
			'Phone' => 6002,
			'SMS' => 6003,
			'Mail' => 6004,
			'Facebook' => 6005,
			'Twitter' => 6006,
			
			// 'LinkedIn' => 6007,
			// 'Link' => 6008,
			'Inbox' => 6009 
	);
	
// 	public static $importStates = array(
// 			'WAITING' => 1,
// 			'PROCESSING' => 2,
// 			'PROCESSED' => 3,
// 			'ERROR_FILE_FORMAT' => 4,
// 			'CONFIGURATION_PENDDING' => 5, 
// 			'CANCELED' => 6
// 	);
	
	/**
	 *
	 * @param unknown $name
	 * @return Ambigous <boolean, multitype:>
	 */
	public static function getChannelIdByName($name) {
		return isset ( self::$channels [$name] ) ? self::$channels [$name] : false;
	}
	
	/**
	 *
	 * @param unknown $channelId        	
	 * @return unknown|boolean
	 */
	public static function getChannelNameById($channelId) {
		foreach ( self::$channels as $name => $id ) {
			if ($channelId == $id)
				return $name;
		}
		return false;
	}
	
	/**
	 * convierte una fecha a timestamp con milisegundos
	 *
	 * @param string $date
	 *        	'dd-mm-yyyy' or 'dd/mm/yyyy'
	 * @return number
	 */
	public static function dateToTimestamp($date) {
		return strtotime ( implode ( "/", array_reverse ( explode ( "/", str_replace ( "-", "/", $date ) ) ) ) ) * 1000;
	}
	
	/**
	 * convierte timestamp con milisegundos a fecha
	 *
	 * @param number $timestamp        	
	 * @return Date in 'dd/mm/YYYY' format
	 */
	public static function timestampToDate($timestamp) {
		return date ( 'd/m/Y', $timestamp / 1000 );
	}
	
	/**
	 *
	 * @param string $servicePath        	
	 * @return string
	 */
	public static function getFullPath($servicePath = "") {
		$retVal = strpos ( $servicePath, "?" ) ? '&' : '?';
		$retVal .= 'touchpoint=' . Thalamus::THALAMUS_TOUCHPOINT . '&token=' . Thalamus::THALAMUS_TOKEN;
		
		return self::getHost ( Thalamus::THALAMUS_ENVIRONMENT, Thalamus::THALAMUS_CLIENT ) . $servicePath . $retVal;
	}
	
	/**
	 *
	 * @param string $environment        	
	 * @param string $client        	
	 * @param string $apiVersion        	
	 * @return string
	 */
	public static function getHost($environment, $client, $apiVersion = Thalamus::VERSION_API) {
		$apiVersion = $GLOBALS['api'];
		return "https://" . $environment . "-" . $client . "-rest.thalamuslive.com/" . $client . "/api/" . $apiVersion;
	}
	
	/**
	 * Devuelve arreglo optin comun para todos los canales.
	 *
	 * @param boolean $optIn        	
	 * @return optin array
	 */
	public static function generateOptInsCompany($optIn = false) {
		return array (
				array (
						"brandFamilyId" => - 1,
						"channel" => - 1,
						"accepted" => $optIn 
				) 
		);
	}
	
	/**
	 * Devuelve arreglo de optins con canales individuales
	 * Recibe array con los canales como key y el valor como boolean, los canales que no esten en el array
	 * se asigna FALSE.
	 *
	 * $optInByDefault, se asignara este valor a todos los canales que no hayan sido incluidos en el array $optIns.
	 *
	 * @param array|boolean $optIns        	
	 * @param boolean $optInByDefault|FALSE
	 *        	by default
	 * @param integer $brandFamilyId|
	 *        	-1 by default
	 * @return multitype:multitype:number string unknown
	 */
	public static function generateOptInsByChannel(Array $optIns = array(), $optInByDefault = false, $brandFamilyId = -1) {
		$arrOptIn = array ();
		
		foreach ( self::$channels as $name => $channel ) {
			
			$optIn = $optInByDefault;
			
			if (isset ( $optIns [$name] )) {
				$optIn = $optIns [$name];
			} elseif (isset ( $optIns [$channel] )) {
				$optIn = $optIns [$channel];
			}
			
			$arrOptIn [] = array (
					"brandFamilyId" => $brandFamilyId,
					"channel" => $channel,
					"accepted" => $optIn 
			);
		}
		
		return $arrOptIn;
	}
	
	/**
	 *
	 * @param array $brandIds        	
	 */
	public static function generateOptInsByBrandFamily(Array $brandIds = array()) {
		$arrOptIn = array ();
		
		foreach ( self::$channels as $channel ) {
			
			foreach ( $brandIds as $brandId => $optIn ) {
				
				$arrOptIn [] = array (
						"brandFamilyId" => $brandId,
						"channel" => $channel,
						"accepted" => $optIn 
				);
			}
		}
		
		return $arrOptIn;
	}
	
	/**
	 * Convierte un array en url query param.
	 *
	 * @param array $params        	
	 * @return string
	 */
	public static function paramsToUrl(Array $params) {
		$r = http_build_query ( $params );
		return ! empty ( $r ) ? '?' . $r : $r;
	}

	/**
	 * Helper function courtesy of https://github.com/guzzle/guzzle/blob/3a0787217e6c0246b457e637ddd33332efea1d2a/src/Guzzle/Http/Message/PostFile.php#L90
	 * 
	 * @param unknown $filename
	 * @param unknown $contentType
	 * @param unknown $postname
	 * @return string
	 */
	public static function getCurlValue($filename, $contentType = null, $postname = null)
	{
		// PHP 5.5 introduced a CurlFile object that deprecates the old @filename syntax
		// See: https://wiki.php.net/rfc/curl-file-upload
		if (function_exists('curl_file_create')) {
			return curl_file_create($filename, $contentType, $postname);
		}
			
		// Use the old style if using an older version of PHP
		$value = "@{$filename};filename=" . $postname;
		if ($contentType) {
			$value .= ';type=' . $contentType;
		}
			
		return $value;
	}
	
	public static function checkDaysDiff($timestamp, $days) {
	
		$datetime1 = new \DateTime(date('Y-m-d H:i:s', ($timestamp / 1000) ) );
		$datetime2 = new \DateTime(date('Y-m-d H:i:s'));
			
		$oDiff = $datetime1->diff($datetime2);
	
		return ($oDiff->days < $days);
	}
	
	public static function endDate($timestamp, $days) {
		
		$datetime1 = new \DateTime(date('Y-m-d H:i:s', ($timestamp / 1000) ) );
		$datetime1->add(new \DateInterval("P" . $days . "D"));
		
		$datetime2 = new \DateTime(date('Y-m-d H:i:s'));	
		$oDiff = $datetime2->diff($datetime1);
		
		return $datetime2->add($oDiff);
	}
	
}