<?php

namespace ThalamusSDK;

/**
 */
use \ThalamusSDK\Thalamus;

class ThalamusErrors {
	/**
	 * errores posibles de Thalamus
	 * 
	 * @var array errors
	 */
	public static $errors = array (
			
			// ------------CODE--CODE-THALAMUS----------------------------------MESSAGE-THALAMUS-----------------------------------------------------ERROR NAME-----------------------------ERROR DESCRIPTION----------------------
			
			// 0XXX RESERVADO (?)
			
			array (
					900,
					"error.message",
					"UNAUTHORIZED",
					"UNAUTHORIZED",
					"401 Unauthorized"
			),
			array (
					901,
					"error.code",
					"401",
					"UNAUTHORIZED",
					"401 Unauthorized"
			),
						
			// 1XXX PERSON
			
			// 10XX -
			array (
					1001,
					"execution",
					"PartyAlreadyLoggedin",
					"PARTY_ALREADY_LOGGED_ID",
					"" 
			),
			array (
					1002,
					"execution.execution",
					"execution.execution: The party is already logged in.",
					"PARTY_ALREADY_LOGGED_ID",
					"" 
			),
			
			// 11XX - LOGIN
			
			array (
					1100,
					"error.message",
					"NOT_FOUND",
					"USER_NOT_FOUND",
					"Usuario o contraseña incorrectos" 
			),
			array (
					1101,
					"error.code",
					"404",
					"USER_NOT_FOUND",
					"Usuario o contraseña incorrectos" 
			),
			
			// 12XX - REGISTER / UPDATE
			
			array (
					1200,
					"error.message",
					"InvalidJson",
					"INVALID_JSON",
					"Invalid Json" 
			),
			array (
					1201,
					"error.invalid.credentials",
					"The following credential already exists: email",
					"CREDENTIAL_EMAIL_ALREADY_EXISTS",
					"The following credential already exists: email" 
			),
			array (
					1203,
					"error.invalid.credentials",
					"The following credential already exists: cellphone",
					"CREDENTIAL_CELLPHONE_ALREADY_EXISTS",
					"The following credential already exists: cellphone" 
			),
			array (
					1213,
					"error.invalid.credentials",
					"The following credential already exists: document",
					"CREDENTIAL_DOCUMENT_ALREADY_EXISTS",
					"The following credential already exists: document" 
			),
			array (
					1210,
					"credential.principal",
					"CredentialAlreadyExists",
					"CREDENTIAL_ALREADY_EXISTS",
					"" 
			),
			array (
					1210,
					"execution.credential.principal",
					"Principal: This credential already exists.",
					"CREDENTIAL_ALREADY_EXISTS",
					"" 
			),
			array (
					1214,
					"execution.unexpected",
					"INTERNAL_SERVER_ERROR",
					"INTERNAL_SERVER_ERROR",
					"" 
			),
			array (
					1215,
					"credential.password",
					"InvalidPassword",
					"INVALID_PASSWORD",
					"" 
			),
			
			// OPTINS
			array (
					1220,
					"optIns",
					"InvalidOptIns",
					"INVALID_OPTINS",
					"" 
			),
			
			// CONSUMER
			array (
					1224,
					"consumer",
					"MissingField",
					"CONSUMER_MISSING_FIELD",
					"No se admite consumer" 
			),
			array (
					1225,
					"execution.consumer",
					"execution.consumer: error.MissingField",
					"CONSUMER_MISSING_FIELD",
					"No se admite consumer" 
			),
			
			// PROFILE
			array (
					1230,
					"profile.lastname",
					"InvalidName",
					"PROFILE_LASTNAME_INVALID",
					"Invalid Profile Lastname" 
			),
			array (
					1231,
					"profile.lastname",
					"Required",
					"PROFILE_LASTNAME_REQUIRED",
					"Profile last name is required" 
			),
			array (
					1232,
					"person.profile.lastname",
					"Required",
					"PROFILE_LASTNAME_REQUIRED",
					"Profile last name is required" 
			),
			array (
					1233,
					"profile.email",
					"InvalidMail",
					"PROFILE_EMAIL_INVALID",
					"Invalid Profile Email" 
			),
			array (
					1233,
					"execution.email",
					"execution.email: invalidEmail",
					"PROFILE_EMAIL_INVALID",
					"Invalid Profile Email" 
			),
			array (
					1233,
					"email",
					"invalidEmail",
					"PROFILE_EMAIL_INVALID",
					"Invalid Profile Email" 
			),
			array (
					1234,
					"profile.firstname",
					"Required",
					"PROFILE_FIRSTNAME_REQUIRED",
					"Profile first name is required" 
			),
			array (
					1235,
					"profile.firstname",
					"InvalidName",
					"PROFILE_FIRSTNAME_INVALID",
					"Profile first name is invalid" 
			),
			array (
					1236,
					"person.profile.firstname",
					"Required",
					"PROFILE_FIRSTNAME_REQUIRED",
					"" 
			),
			array (
					1237,
					"execution.person.profile.firstname",
					"execution.person.profile.firstname: This field is required.",
					"PROFILE_FIRSTNAME_REQUIRED",
					"" 
			),
			array (
					1238,
					"birthday",
					"minor.registration.birthday.required",
					"PROFILE_BIRTHDAY_MAYORITY_AGE_REQUIRED",
					"" 
			),
			array (
					1239,
					"execution.birthday",
					"Date of Birth: Required to validate registrant's legal age.",
					"PROFILE_BIRTHDAY_MAYORITY_AGE_REQUIRED",
					"" 
			),
			array (
					1240,
					"person.profile.gender",
					"Required",
					"PROFILE_GENDER_REQUIRED",
					"" 
			),
			array (
					1241,
					"execution.person.profile.gender",
					"execution.person.profile.gender: This field is required.",
					"PROFILE_GENDER_REQUIRED",
					"" 
			),
			array (
					1242,
					"person.profile.birthday",
					"Required",
					"PROFILE_BIRTHDAY_REQUIRED",
					"" 
			),
			array (
					1243,
					"execution.person.profile.birthday",
					"execution.person.profile.birthday: This field is required.",
					"PROFILE_BIRTHDAY_REQUIRED",
					"" 
			),
			array (
					1244,
					"profile.document.number",
					"profile.document.number: InvalidDocumentNumber",
					"PROFILE_DOCUMENT_NUMBER_INVALID",
					"" 
			),
			array (
					1245,
					"profile.document.number",
					"InvalidDocumentNumber",
					"PROFILE_DOCUMENT_NUMBER_INVALID",
					"" 
			),
			
			// CELLPHONE
			array (
					1250,
					"profile.cellphone.intCode",
					"InvalidFormat",
					"CELLPHONE_INTCODE_INVALID_FORMAT",
					"" 
			),
			array (
					1251,
					"execution.profile.cellphone.intCode",
					"execution.profile.cellphone.intCode: error.InvalidFormat",
					"CELLPHONE_INTCODE_INVALID_FORMAT",
					"" 
			),
			array (
					1252,
					"profile.cellphone.areaCode",
					"InvalidFormat",
					"CELLPHONE_AREACODE_INVALID_FORMAT",
					"" 
			),
			array (
					1253,
					"execution.profile.cellphone.areaCode",
					"execution.profile.cellphone.areaCode: error.InvalidFormat",
					"CELLPHONE_AREACODE_INVALID_FORMAT",
					"" 
			),
			array (
					1254,
					"profile.cellphone.number",
					"InvalidFormat",
					"CELLPHONE_NUMBER_INVALID_FORMAT",
					"" 
			),
			array (
					1255,
					"execution.profile.cellphone.number",
					"execution.profile.cellphone.number: error.InvalidFormat",
					"CELLPHONE_NUMBER_INVALID_FORMAT",
					"" 
			),
			
			// PHONE
			array (
					1256,
					"profile.phone.type",
					"InvalidFormat",
					"PHONE_TYPE_INVALID_FORMAT",
					"" 
			),
			array (
					1257,
					"execution.profile.phone.type",
					"execution.profile.phone.type: error.InvalidFormat",
					"PHONE_TYPE_INVALID_FORMAT",
					"" 
			),
			array (
					1258,
					"profile.phone.number",
					"InvalidFormat",
					"PHONE_NUMBER_INVALID_FORMAT",
					"Invalid format profile phone number" 
			),
			array (
					1259,
					"profile.phone.intCode",
					"InvalidFormat",
					"PHONE_INTCODE_INVALID_FORMAT",
					"Invalid format profile phone intCode" 
			),
			array (
					1260,
					"execution.profile.phone.intCode",
					"execution.profile.phone.intCode: error.InvalidFormat",
					"PHONE_INTCODE_INVALID_FORMAT",
					"Invalid format profile phone intCode" 
			),
			array (
					1261,
					"profile.phone.areaCode",
					"InvalidFormat",
					"PHONE_AREACODE_INVALID_FORMAT",
					"" 
			),
			array (
					1262,
					"execution.profile.phone.areaCode",
					"InvalidFormat",
					"PHONE_AREACODE_INVALID_FORMAT",
					"" 
			),
			
			// ADDRESS
			array (
					1263,
					"profile.address.stateOrProvinceId",
					"InvalidFormat",
					"ADDRESS_STATE_ID_INVALID_FORMAT",
					"" 
			),
			array (
					1264,
					"execution.profile.address.stateOrProvinceId",
					"execution.profile.address.stateOrProvinceId: error.InvalidFormat",
					"ADDRESS_STATE_ID_INVALID_FORMAT",
					"" 
			),
			array (
					1265,
					"profile.address.countryId",
					"InvalidFormat",
					"ADDRESS_COUNTRY_ID_INVALID_FORMAT",
					"" 
			),
			array (
					1266,
					"execution.profile.address.countryId",
					"execution.profile.address.countryId: error.InvalidFormat",
					"ADDRESS_COUNTRY_ID_INVALID_FORMAT",
					"" 
			),
			array (
					1267,
					"profile.address.street1",
					"InvalidFormat",
					"ADDRESS_STREET1_INVALID_FORMAT",
					"" 
			),
			array (
					1268,
					"profile.address.street2",
					"InvalidFormat",
					"ADDRESS_STREET2_INVALID_FORMAT",
					"" 
			),
			array (
					1269,
					"profile.address.city",
					"InvalidFormat",
					"ADDRESS_CITY_INVALID_FORMAT",
					"" 
			),
			array (
					1270,
					"execution.profile.address.city",
					"execution.profile.address.city: error.InvalidFormat",
					"ADDRESS_CITY_INVALID_FORMAT",
					"" 
			),
			array (
					1271,
					"profile.address.postalCode",
					"InvalidFormat",
					"ADDRESS_POSTALCODE_INVALID_FORMAT",
					"" 
			),
			array (
					1272,
					"execution.profile.address.postalCode",
					"execution.profile.address.postalCode: error.InvalidFormat",
					"ADDRESS_POSTALCODE_INVALID_FORMAT",
					"" 
			),
			array (
					1273,
					"profile.address.type",
					"InvalidFormat",
					"ADDRESS_TYPE_INVALID_FORMAT",
					"" 
			),
			array (
					1274,
					"execution.profile.address.type",
					"execution.profile.address.type: error.InvalidFormat",
					"ADDRESS_TYPE_INVALID_FORMAT",
					"" 
			),
			
			array (
					1275,
					"profile.address.countryId",
					"Required",
					"ADDRESS_COUNTRY_ID_REQUIRED",
					"" 
			),
			array (
					1276,
					"execution.profile.address.countryId",
					"execution.profile.address.countryId: This field is required.",
					"ADDRESS_COUNTRY_ID_REQUIRED",
					"" 
			),
			
			// 13XX - PASSWORD ( CHANGE / REQUEST RESET / RESET )
			
			// PASSWORD CHANGE
			
			array (
					1301,
					"oldPassword",
					"oldNotMatch",
					"OLD_PASSWORD_NOT_MATCH",
					"Old Password: The password don't match with actual password." 
			),
			array (
					1302,
					"execution.oldPassword",
					"Old Password: The password don't match with actual password.",
					"OLD_PASSWORD_NOT_MATCH",
					"Old Password: The password don't match with actual password."
			),
			array (
					1303,
					"partyCredential.plainPassword",
					"InvalidPassword",
					"PLAIN_PASSWORD_INVALID",
					"" 
			),
			array (
					1304,
					"confirmPassword",
					"NotMatch",
					"CONFIRM_PASSWORD_NOT_MATCH",
					"Confirm Password: Passwords do not match."
			),
			array (
					1305,
					"execution.confirmPassword",
					"Confirm Password: Passwords do not match.",
					"CONFIRM_PASSWORD_NOT_MATCH",
					"Confirm Password: Passwords do not match."
			),
			array (
					1306,
					"newpassword",
					"EqualsOldPassword",
					"NEW_PASSWORD_EQUALS_OLD_PASSWORD",
					"Equals Old Password."
			),
			array (
					1307,
					"execution.newpassword",
					"Confirm Password: Passwords do not match.",
					"NEW_PASSWORD_EQUALS_OLD_PASSWORD",
					"execution.newpassword: New password must be different from previous password."
			),

			// PASSWORD CONFIRMATION
			
			array (
					1310,
					"error.message",
					"Unauthorized",
					"UNAUTHORIZED",
					"" 
			),
			
			// REQUEST RESET PASSWORD
			
			array (
					1320,
					"execution",
					"InvalidPrincipal",
					"REQUEST_PASSWORD_RESET_INVALID_PRINCIPAL",
					"" 
			),
			
			// RESET PASSWORD
			
			array (
					1330,
					"token",
					"InvalidToken",
					"RESET_PASSWORD_INVALID_TOKEN",
					"" 
			),
			array (
					1331,
					"partyCredential.plainPassword",
					"InvalidPassword",
					"RESET_PASSWORD_INVALID_PASSWORD",
					"" 
			),
			array (
					1332,
					"principal",
					"InvalidPrincipal",
					"RESET_PASSWORD_INVALID_PRINCIPAL",
					"" 
			),
			
			// 14XX -
			// 15XX -
			// 16XX - INBOX
			
			// READ
			array (
					1601,
					"id",
					"InvalidId",
					"INBOX_INVALID_ID",
					"" 
			),
			array (
					1602,
					"read",
					"required",
					"INBOX_REQUIRED_READ",
					"" 
			),
			array (
					1603,
					"messageInbox",
					"invalidId",
					"INBOX_INVALID_ID",
					"" 
			),
			array (
					1604,
					"messageInbox",
					"alreadyRead",
					"INBOX_ALREADY_READ",
					"" 
			),
			
			// 17XX - FIRE INTERACTIONS
			
			array (
					1701,
					"interaction",
					"InvalidCode",
					"FIRE_INTERACTION_INVALID_TYPE_CODE",
					"" 
			),
			
			array (
					1702,
					"interactionType",
					"InvalidCode",
					"FIRE_INTERACTION_INVALID_CODE",
					""
			),
			
			array (
					1703,
					"execution.interactionType",
					"execution.interactionType: This field allows letters only. (up to 10 characters)",
					"FIRE_INTERACTION_INVALID_TYPE_CODE",
					"This field allows letters only. (up to 10 characters)"
			),
			
			// 18XX - AVATAR
			
			// ACTIVITY LOGIN
			array (
					1801,
					"activity",
					"InvalidCode",
					"ACTIVITY_INVALID_CODE",
					"" 
			),
			
			// AVATAR CREATE
			
			array (
					1802,
					"file",
					"empty.file",
					"AVATAR_EMPTY_FILE",
					"" 
			),
			array (
					1803,
					"execution.unexpected",
					"INTERNAL_SERVER_ERROR",
					"INTERNAL_SERVER_ERROR",
					"" 
			),
			
			// AVATAR UPDATE
			
			array (
					1804,
					"avatar",
					"IncorrectBody",
					"AVATAR_INCORRECT_BODY",
					"" 
			),
			
			// 19XX -
			
			// 2XXX ACTIVITY
			
			// 20XX -
			array (
					2100,
					"activity",
					"InvalidCode",
					"ACTIVITY_INVALID_CODE",
					"" 
			),
			
			// 21XX - GENERIC
			// 22XX - EVENTS
			
			// PARTY ATTENDANCE
			
			array (
					2201,
					"activity",
					"AssistanceDateExpired",
					"EVENT_ATTENDANCE_DATE_EXPIRED",
					"" 
			),
			array (
					2202,
					"activity",
					"NotOcurred",
					"EVENT_ATTENDANCE_NOT_OCCURED",
					"" 
			),
			array (
					2203,
					"invitation",
					"NotAccepted",
					"EVENT_ATTENDANCE_INVITATION_NOT_ACCEPTED",
					"" 
			),
			array (
					2204,
					"invitation",
					"AlreadyRegisteredAssistance",
					"EVENT_ATTENDANCE_ALREADY_REGISTERED",
					"" 
			),
			array (
					2205,
					"execution.invitation",
					"Invitation: error.AlreadyRegisteredAssistance",
					"EVENT_ATTENDANCE_ALREADY_REGISTERED",
					"" 
			),
			
			// ACCEPT/DECLINE INVITATION
			
			array (
					2010,
					"activity",
					"AcceptanceDateExpired",
					"EVENT_ACCEPTANCE_DATA_EXPIRED",
					"" 
			),
			array (
					2011,
					"activity",
					"CodeRequired",
					"EVENT_ACCEPTANCE_CODE_REQUIRED",
					"" 
			),
			array (
					2012,
					"activity",
					"AttendanceLimitReached",
					"EVENT_ACCEPTANCE_LIMIT_REACHED",
					"" 
			),
			array (
					2013,
					"ticketCode",
					"InvalidCode",
					"EVENT_ACCEPTANCE_INVALID_CODE",
					"" 
			),
			array (
					2014,
					"invitation",
					"AlreadyRegisteredAcceptance",
					"EVENT_ACCEPTANCE_ALREADY_REGISTERED",
					"" 
			),
			
			// ACCEPT INVITATION WITHOUT LOGIN
			
			array (
					2020,
					"activity",
					"Inactive",
					"EVENT_ACCEPTANCE_INACTIVE",
					"" 
			),
			array (
					2023,
					"invitation",
					"InvalidToken",
					"EVENT_ACCEPTANCE_INVALID_TOKEN",
					"" 
			),
			array (
					2024,
					"invitation",
					"InvalidCode",
					"EVENT_ACCEPTANCE_INVALID_CODE",
					"" 
			),
			
			// 23XX - SURVEY
			array (
					2300,
					"survey",
					"completed",
					"SURVEY_COMPLETED",
					"Survey Completed"
			),
			
			array (
					2301,
					"execution.survey",
					"execution.survey: error.completed",
					"SURVEY_COMPLETED",
					"Survey Completed"
			),
			
			// 24XX - MILEAGE
			
			array (
					2401,
					"item",
					"InvalidID",
					"ITEM_INVALID_ID",
					"" 
			),
			
			// GET CATALOG ITEMS / GET CATALOG ITEM / GET CART / GET CART ITEMS / GET CART TOTAL
			
			array (
					2402,
					"filter",
					"InvalidPageAndSize",
					"MILEAGE_CATALOG_INVALID_PAGE_SIZE",
					"" 
			),
			array (
					2403,
					"tags",
					"InvalidFormat",
					"MILEAGE_CATALOG_INVALID_TAGS",
					"" 
			),
			array (
					2404,
					"orderby",
					"InvalidFormat",
					"MILEAGE_CATALOG_INVALID_ORDERBY",
					"" 
			),
			array (
					2405,
					"item",
					"InvalidCode",
					"MILEAGE_CATALOG_INVALID_CODE",
					"" 
			),
			
			// ADD ITEM/S TO CART / UPDATE ITEM QUANTITY / REMOVE ITEM FROM CART / REMOVE ITEMS FROM CART
			
			array (
					2430,
					"account",
					"NotEnoughPoints",
					"MILEAGE_CART_ACCOUNT_NOT_ENOUGH_POINTS",
					"" 
			),
			array (
					2431,
					"item",
					"AnyItemToDelete",
					"MILEAGE_CART_ANY_ITEM_TO_DELETE",
					"" 
			),
			array (
					2432,
					"execution.item",
					"Item/s: error.AnyItemToDelete",
					"MILEAGE_CART_ANY_ITEM_TO_DELETE",
					"" 
			),
			
			// LOAD CODES
			
			array (
					2440,
					"activity",
					"CouponInputDateExpired",
					"LOAD_CODES_COUPON_DATE_EXPIRED",
					"" 
			),
			array (
					2441,
					"activity",
					"UserBanned",
					"LOAD_CODES_USER_BANNED",
					"" 
			),
			array (
					2442,
					"activity",
					"AllowedPublicCodesLimitReached",
					"LOAD_CODES_PUBLIC_CODES_LIMIT_REACHED",
					"" 
			),
			array (
					2443,
					"activity",
					"AllowedPublicPointsLimitReached",
					"LOAD_CODES_PUBLIC_POINTS_LIMIT_REACHED",
					"" 
			),
			array (
					2444,
					"activity",
					"CodesToRedeemLimitReached",
					"LOAD_CODES_TO_REDEEM_LIMIT_REACHED",
					"" 
			),
			array (
					2445,
					"codes",
					"IsEmpty",
					"LOAD_CODES_IS_EMPTY",
					"" 
			),
			array (
					2446,
					"InvalidCodes",
					"[all_invalid_codes]",
					"LOAD_CODES_ALL_INVALID_CODES",
					"" 
			),
			array (
					2447,
					"code",
					"codeAlreadyUsed",
					"LOAD_CODES_ALREADY_USED",
					""
			),
			array (
					2448,
					"execution.code",
					"Code: error.codeAlreadyUsed",
					"LOAD_CODES_ALREADY_USED",
					""
			),

			// GET ACCOUNT MOVEMENTS / MAKE CHECKOUT
			
			array (
					2460,
					"activity",
					"CheckoutLimitReached",
					"MILEAGE_CHECKOUT_LIMIT_REACHED",
					""
			),
			array (
					2461,
					"cart",
					"IsEmpty",
					"MILEAGE_CART_IS_EMPTY",
					"" 
			),
			array (
					2462,
					"execution.cart",
					"Cart: Empty.",
					"MILEAGE_CART_IS_EMPTY",
					"" 
			),
			array (
					2463,
					"item",
					"NotInStock",
					"MILEAGE_ITEM_NOT_IN_STOCK",
					"" 
			),
			array (
					2464,
					"item",
					"NotAvailable",
					"MILEAGE_ITEM_NOT_AVAILABLE",
					"" 
			),
			array (
					2465,
					"item",
					"CheckoutLimitReached",
					"MILEAGE_ITEM_CHEKOUT_LIMIT_REACHED",
					"" 
			),
			array (
					2466,
					"address",
					"InvalidCode",
					"MILEAGE_ADDRESS_INVALID_CODE",
					"" 
			),
			array (
					2467,
					"profile",
					"IncompleteAddress",
					"MILEAGE_PROFILE_INCOMPLETE_ADDRESS",
					"" 
			),
			array (
					1268,
					"execution.profile",
					"Profile: The address is incomplete.",
					"MILEAGE_PROFILE_INCOMPLETE_ADDRESS",
					"" 
			),
			array (
					2469,
					"checkout",
					"NotUniqueDeliveryMethod",
					"MILEAGE_NOT_UNIQUE_DELIVERY_METHOD",
					"" 
			),
			array (
					2470,
					"checkout",
					"NotSpecifiedDeliveryMethod",
					"MILEAGE_NOT_SPECIFIED_DELIVERY_METHOD",
					"" 
			),
			array (
					2471,
					"exchangeCenter",
					"InvalidID",
					"MILEAGE_EXCHANGE_CENTER_INVALID_ID",
					"" 
			),
			
			// GET ORDERS / GET ORDER
			
			array (
					2480,
					"order",
					"InvalidNumber",
					"MILEAGE_ORDER_INVALID_NUMBER",
					"" 
			),
			
			// GET EXCHANGE CENTERS / GET EXCHANGE CENTER
			
			array (
					2481,
					"exchangeCenter",
					"InvalidID",
					"MILEAGE_EXCHANGECENTER_INVALID_ID",
					"" 
			),
			
			// GET RANKING / GET RANKINGS / MARK ORDER AS DELIVERED OR CONTECT US
			
			// 25XX -
			// 26XX - GAMIFICATION
			
			// GET RANKING
			
			// GET RANKINGS
			
			// 27XX -
			// 28XX -
			// 29XX -
			
			// 3XXX
			// 30XX -
			// 31XX - CASES
			
			array (
					3100,
					"case",
					"InvalidID",
					"CASES_INVALID_ID",
					"" 
			),
			
			// CREATE
			
			array (
					3101,
					"category",
					"CodeRequired",
					"CASES_CATEGORY_CODE_REQUIRED",
					"" 
			),
			array (
					3102,
					"categoryOrType",
					"InvalidCode",
					"CASES_CATEGORY_OR_TYPE_INVALID",
					"" 
			),
			array (
					3103,
					"caseStatus",
					"InitialStatusNotSelected",
					"CASES_INITIAL_STATUS_NOT_SELECTED",
					"" 
			),
			array (
					3104,
					"caseResolutionType",
					"InitialResolutionTypeNotSelected",
					"CASES_INITIAL_RESOLUTION_TYPE_NOT_SELECTED",
					"" 
			),
			
			array (
					3105,
					"execution.categoryOrType",
					"execution.categoryOrType: This field allows letters only. (up to 10 characters)",
					"CASES_CATEGORY_OR_TYPE_ALLOW_LETTERS_ONLY",
					"This field allows letters only. (up to 10 characters)" 
			),
			
			// GET CASES
			
			// ADD NOTE
			
			// 32XX - PAY IT FORWARD ACTIVITY
			
			array (
					3202,
					"account",
					"NotEnoughPoints",
					"PAY_IT_FORWARD_NOT_ENOUGH_POINTS",
					"" 
			),
			
			// GET GIFTS CHAIN (PUBLIC)
			
			// GIFT CLAIMS
			
			array (
					3210,
					"claimCode",
					"ALREADY_CLAIMED",
					"PAY_IT_FORWARD_CODE_ALREADY_CLAIMED",
					"" 
			),
			
			// GIVE ONE GIFT
			
			// GIVE ONE GIFT (PAYMENT APPROVED)
			
			// 33XX - PAYMENTS USING PAYU
			
			// CREATE PAYMENT
			
			array (
					3301,
					"activity",
					"NotLoggedIn",
					"PAYU_ACTIVITY_NOT_LOGGED_IN",
					"" 
			),
			array (
					3302,
					"orderRefCode",
					"InvalidCode",
					"PAYU_ORDER_REF_CODE_INVALID",
					"" 
			),
			array (
					3303,
					"payment",
					"InvalidTransitionState",
					"PAYU_PAYMENT_TRANSACTION_STATE_INVALID",
					"" 
			),
			
			// UPDATE PAYMENT
			
			// GET PAYMENTS
			
			// 34XX -
			
			// 35XX - REFERENCE DATA
			
			// CUSTOM ITEM LIST
			
			array (
					3500,
					"itemList",
					"InvalidID",
					"REFERENCE_DATA_ITEM_LIST_INVALID_ID",
					"" 
			),

			// SKU
			array (
					4000,
					"partnerSku",
					"partnerSku.codeAlreadyExists",
					"PARTNER_SKU_ALREADY_EXISTS",
					"Partner Sku Already Exists"
			),
			array (
					4001,
					"execution.partnerSku",
					"execution.partnerSku: The partner SKU code is already used",
					"PARTNER_SKU_ALREADY_EXISTS",
					"Partner Sku Already Exists"
			),
			array (
					4002,
					"partnerSku",
					"partnerSku.name.invalidValue",
					"PARTNER_SKU_NAME_INVALID",
					"The partner SKU name is invalid"
			),
			array (
					4003,
					"execution.partnerSku",
					"execution.partnerSku: The partner SKU name is invalid",
					"PARTNER_SKU_NAME_INVALID",
					"The partner SKU name is invalid"
			),
			array (
					4004,
					"partnerSku",
					"partnerSku.equivalence.invalidValue",
					"PARTNER_SKU_EQUIVALENCE_MUST_BE_GRAETER_THAN_ZERO",
					"The equivalence must be a number greater than zero"
			),
			array (
					4005,
					"execution.partnerSku",
					"execution.partnerSku: The equivalence must be a number greater than zero",
					"PARTNER_SKU_EQUIVALENCE_MUST_BE_GRAETER_THAN_ZERO",
					"The equivalence must be a number greater than zero"
			),
			array (
					4006,
					"partnerEmail",
					"EmailAlreadyExists",
					"PARTNER_EMAIL_ALREADY_EXISTS",
					"Email Already Exists"
			),
			array (
					4007,
					"execution.partnerEmail",
					"execution.partnerEmail: error.EmailAlreadyExists",
					"PARTNER_EMAIL_ALREADY_EXISTS",
					"Email Already Exists"
			),
			array (
					4008,
					"partnerDataSource",
					"InvalidTouchpointCode",
					"DATASOURCE_TOUCHPOINT_INVALID",
					"Invalid Touchpoint Code"
			),
			array (
					4009,
					"execution.partnerDataSource",
					"execution.partnerDataSource: error.InvalidTouchpointCode",
					"PARTNER_EMAIL_ALREADY_EXISTS",
					"Invalid Touchpoint Code"
			),
			array (
					4010,
					"ProcessFile",
					"UnknownFormat",
					"INVALID_FILE_FORMAT",
					"Invalid File Format"
			),
			array (
					4011,
					"execution.ProcessFile",
					"execution.ProcessFile: error.UnknownFormat",
					"INVALID_FILE_FORMAT",
					"Invalid File Format"
			),
			array (
					4012,
					"error.import.header.invalid",
					"Header validation: Column % is invalid.",
					"IMPORT_HEADER_INVALID",
					""
			),
	)
	// 36XX -
	// 37XX -
	;
// 	public static function getErrorNameAndDescription($codeThalamus, $messageThalamus) {
// 		$return = array (
// 				0,
// 				"UNKNOWN_CODE_NAME",
// 				"UNKNOWN_CODE_DESCRIPTION" 
// 		);
		
// 		foreach ( self::$errors as $key => $error ) {
// 			if (($error [1] == $codeThalamus) and ($error [2] == $messageThalamus)) {
// 				$return = array (
// 						$error [0],
// 						$error [3],
// 						$error [4] 
// 				);
// 				continue;
// 			}
// 		}
		
// 		return $return;
// 	}
	
	public static function getErrorNameAndDescription($codeThalamus, $messageThalamus) {
		$return = array (
				0,
				$codeThalamus . '_' . $messageThalamus,
				"UNKNOWN_CODE_DESCRIPTION"
		);
	
		foreach ( self::$errors as $key => $error ) {
			if (($error [1] == $codeThalamus)){
				if (($error [2] == $messageThalamus)) {
					$return = array (
							$error [0],
							$error [3],
							$error [4]
					);
					continue;
				}else{
					$errorVariables = explode('%',$error [2]);
					$match = true;
					foreach ($errorVariables as $String){
						if (!empty($String) && strpos($messageThalamus, $String)===false){
							$match = false;
						}
					}
					if ($match){
						$return = array (
								$error [0],
								$error [3],
								$error [4]
						);
						continue;
					}
				}
			}
		}
	
		return $return;
	}
}