<?php

namespace ThalamusSDK\Model\Person;

use \ThalamusSDK\ThalamusModel;
use \ThalamusSDK\ThalamusHelper;
use \ThalamusSDK\Model\Other\Location;

/**
 * Class Profile
 *
 * @package ThalamusSDK
 */
class Profile extends ThalamusModel {
	/**
	 * Returns the name for the user as a string if present.
	 *
	 * @return string|null
	 */
	public function getName() {
		return $this->getProperty ( 'firstname' ) . " " . $this->getProperty ( 'lastname' );
	}
	
	/**
	 */
	public function getEmail() {
		return $this->getProperty ( 'email' );
	}
	
	/**
	 * Returns the first name for the user as a string if present.
	 *
	 * @return string|null
	 */
	public function getFirstName() {
		return $this->getProperty ( 'firstname' );
	}
	
	/**
	 * Returns the last name for the user as a string if present.
	 *
	 * @return string|null
	 */
	public function getLastName() {
		return $this->getProperty ( 'lastname' );
	}
	
	/**
	 * Returns the gender for the user as a string if present.
	 *
	 * @return string | null
	 */
	public function getGender() {
		return $this->getProperty ( 'gender' );
	}
	
	/**
	 * Returns the users birthday, if available.
	 *
	 * @return \DateTime|null
	 */
	public function getBirthday() {
		if ($this->getProperty ( 'birthday' )) {
			return ThalamusHelper::timestampToDate ( $this->getProperty ( 'birthday' ) );
		}
		return null;
	}
	
	/**
	 * Returns the current location of the user as a Location
	 * if available.
	 *
	 * @return Location | null
	 */
	public function getLocation() {
		return $this->getProperty ( 'address', Location::className () );
	}
	
	/**
	 *
	 * @return \ThalamusSDK\Model\Person\Document
	 */
	public function getDocument() {
		return $this->getProperty ( 'document', Document::className () );
	}
	
	/**
	 *
	 * @return \ThalamusSDK\Model\Person\Phone
	 */
	public function getPhone() {
		return $this->getProperty ( 'phone', Phone::classname () );
	}
	
	/**
	 *
	 * @return \ThalamusSDK\Model\Person\Cellphone
	 */
	public function getCellphone() {
		return $this->getProperty ( 'cellphone', Cellphone::classname () );
	}
	
	/**
	 * get Party Type 10 Person | 11 Company | 14 Physical Location
	 */
	public function getPartyType() {
		return $this->getProperty( 'partyType' );
	}

	/**
	 * get Hierarchy stc | stc_supervisor | cac
	 */
	public function getHierarchy() {
		return $this->getProperty( 'jerarquia' );
	}

	/**
	 * get Supervisor Id
	 */
	public function getSupervisorId() {
		return $this->getProperty( 'supervisor_id' );
	}

	/**
	 * get Supervisor
	 */
	public function getSupervisor() {
		return $this->getProperty( 'supervisor' );
	}
	
	/**
	 *
	 * @return string
	 */
	public function __toString() {
		return $this->getName();
	}
}