<?php

namespace ThalamusSDK\Model;

use \ThalamusSDK\ThalamusModel;
use \ThalamusSDK\Model\Other\Note;
use \ThalamusSDK\ThalamusRequest;
use \ThalamusSDK\ThalamusHelper;

/**
 * Class Caso
 *
 * @package ThalamusSDK
 */
class Caso extends ThalamusModel {
	/**
	 */
	public function getId() {
		return $this->getProperty ( 'id' );
	}
	
	/**
	 */
	public function getCategoryCode() {
		return $this->getProperty ( 'categoryCode' );
	}
	
	/**
	 */
	public function getCategoryName() {
		return $this->getProperty ( 'categoryName' );
	}
	
	/**
	 */
	public function getTypeCode() {
		return $this->getProperty ( 'typeCode' );
	}
	
	/**
	 */
	public function getStatus() {
		return $this->getProperty ( 'status' );
	}
	
	/**
	 */
	public function getResolution() {

		if ( $this->getData('case_null') ) {
			return 'Anulado';
		} elseif ($this->getStatus() == 'Finalizado') {
			return $this->getProperty ( 'resolution' );
		}
	}
	
	/**
	 */
	public function getNotes() {
		return $this->getPropertyAsArray ( 'comments', Note::classname () );
	}
	
	/**
	 * @param string $description
	 * 
	 * @return object Caso
	 */
	public function addNote($description = '')
	{
		if ($description) {
			$params = array (
				'description' => $description 
			);
			
			$response = ThalamusRequest::post ( "/cases/{$this->getId()}/note", $params )->execute ();
			
			$this->backingData ['comments'] [] = $description;
		}
		
		return $this;
	}

	/**
	 * @param string $status
	 * 
	 * @return object Caso
	 */
	public function changeStatus($status = null)
	{
		if ($status) {
			$params = array (
    			'statusName' => $status
			);

			$response = ThalamusRequest::put ( "/cases/{$this->getId()}/transitions", $params )->execute ();

			$this->backingData ['status'] = $status;
		}
		
		return $this;
	}

	/**
	 * @param string $typeCode
	 * @param string $status
	 * @param string $resolution
	 * @param array $caseData
	 * 
	 * @return object Caso
	 */
	public function close($typeCode = CHALLENGE_TYPE_CODE, $status = null, $resolution = null, $caseData = null)
	{
		if ($status && $resolution) {
			$params = array (
				'categoryCode' => CATEGORY_CODE,
    			'typeCode'     => $typeCode,
    			'status'       => $status,
    			'resolution'   => $resolution,
				'caseData'     => $caseData
			);

			$response = ThalamusRequest::put ( "/cases/{$this->getId()}", $params )->execute ();
		}
		
		return $this;
	}

	/**
	 * @param string $operator
	 *
	 * @return object Caso
	 */
	public function assign($operator = '')
	{
		if ($operator) {
			$params = array (
				'email' => $operator 
			);
			
			$response = ThalamusRequest::put ( "/cases/{$this->getId()}/assignment", $params )->execute ();
		}
		
		return $this;
	}

	/**
	 * @param string $typeCode
	 * @param array $caseData
	 * 
	 * @return object Caso
	 */
	public function update($typeCode = CHALLENGE_TYPE_CODE, $caseData = null)
	{
		if ($caseData) {
			$params = array (
				'categoryCode' => CATEGORY_CODE,
    			'typeCode'     => $typeCode,
				'caseData'     => $caseData
			);

			$this->backingData['caseData'] = $caseData;

			$response = ThalamusRequest::put ( "/cases/{$this->getId()}", $params )->execute ();
		}
		
		return $this;
	}

	/**
	 * @param string $property
	 * 
	 * @return mixed array|string
	 */
	public function getData($property = '')
	{	
		$data = $this->getProperty('caseData');

		if ($data) {
			$data = $data->asArray();
			$data = json_decode(json_encode($data), true);

			return (empty($property))? $data : (isset($data[$property]) ? $data[$property] : '');
		}
	}

	/**
	 * @param string $fileName 
	 *
	 * @return object
	 */
	public function addFile($fileName = null)
	{
		if ($fileName) {
			$file = $_FILES[$fileName]['tmp_name'];
			$name = date('Y-m-d').'_'.filter_var($_FILES[$fileName]['name'], FILTER_SANITIZE_URL);
			$type = $_FILES[$fileName]['type'];

			$params = array(
				'file' => ThalamusHelper::getCurlValue( $file, $type, $name ),
			);
			
			$response = ThalamusRequest::post( "/cases/{$this->getId()}/files" , $params ) ->sendFile() ->execute();
		}
		
		return $this;
	}

	/**
	 * @param array $files 
	 *
	 * @return void
	 */
	public function reUploadFile($files = null)
	{
		if ($files) {
			foreach ($files as $remito) {
				$name = substr(strrchr($remito, '/'), 1);

				$file = file_get_contents($remito);
				file_put_contents(APPPATH.'cache/'.CHALLENGE_TMP_FILE_DIR.'/'.$name, $file);

				$file = APPPATH.'cache/'.CHALLENGE_TMP_FILE_DIR.'/'.$name;
				$type = 'application/x-forcedownload';

				$params = array(
					'file' => ThalamusHelper::getCurlValue( $file, $type, $name ),
				);
				
				$response = ThalamusRequest::post( "/cases/{$this->getId()}/files" , $params ) ->sendFile() ->execute();
			}
		}
	}

	/**
	 * 
	 * @return array
	 */
	public function getFiles()
	{
		return json_decode(json_encode($this->getProperty('attachements')->asArray()), true);
	}

	/**
	 * @param int $id 
	 *
	 * @return boolean
	 */
	public function deleteFile($id = null)
	{
		if ($id) {
			return ThalamusRequest::delete( "/cases/{$this->getId()}/files/".$id ) ->execute();
		}
	}

	/**
	*
	* @return boolean
	*/
	public function isNull()
	{	
		$caseData = $this->getData();
		return ( isset($caseData['case_null']) && $caseData['case_null'] ) ? true : false;
	}

	/**
	*
	* @return string 'dd-mm-yyyy'
	*/
	public function getDate()
	{	
		return ( isset($this->date) ) ? $this->date : '';
	}
}