<?php
include_once 'UrlFactory.php';

require_once 'Response.php';

/**
 * Provides methods to connect with the Thalamus interface
 * @author Alejandro, Ezequiel
 * @version 0.8
 */
class ThalamusConnector{
	
	private $url = "";
	private $touchpointCode = "";
	private $tokenCode = "";
	private $requestType= "";
	private $servicePath = "";
	
	/**
	 * Initialize the data needed to connect with thalamus services
	 * @param $url
	 * @param $touchpointCode
	 * @param $tokenCode
	 */
	function __construct($url, $touchpointCode, $tokenCode){
		
// 		if (!in_array('curlsss', get_loaded_extensions()))
// 		{
// 			throw new \Exception('You need to install cURL, see: http://curl.haxx.se/docs/install.html');
// 		}
		
		$this->url = $url;
		$this->touchpointCode = $touchpointCode;
		$this->tokenCode = $tokenCode;
	}
	
	/**
	 * Execute the incoming request
	 * @param $requestType
	 * @param $servicePath
	 * @param $header
	 * @return the json response from thalamus
	 */
	function executeRequest($requestType, $servicePath, $header = ""){
		$this->servicePath = $servicePath;
		$urlFactory = new UrlFactory();
		$completeUrl = $urlFactory->assemble($this->getUrl(), $this->getTouchpoint(), $this->getToken(), $this->getServicePath());
		return $this->doExecute($completeUrl, $header, $requestType);
	}
	
	//Getters
	function getUrl(){return $this->url;}
	function getTouchpoint(){return $this->touchpointCode;}
	function getToken(){return $this->tokenCode;}
	function getServicePath(){return $this->servicePath;}
	
	private function doExecute($url, $header = "", $type = "GET"){
		
		$ch = curl_init();
		
		curl_setopt($ch, CURLOPT_VERBOSE, true);
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		if ($GLOBALS['useProxy']){
			curl_setopt($ch, CURLOPT_PROXY, '192.168.168.71:3128');
		}
		
		
		
		if (!empty($header["principal"]) && isset($header['password'])) {
			$pass = ($header["password"]!= null) ? $header["password"] : DEFAULT_PASSWORD;
			$credentials = $header["principal"] . ":" . $pass;
			curl_setopt($ch, CURLOPT_USERPWD, $credentials);
		}
		
		switch ($type) {
			case "POST":
				curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json','Content-length: '.strlen(json_encode($header["body"]))));
				curl_setopt($ch, CURLOPT_POST, true);
				curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($header["body"]));
				break;
			
			case "PUT":
				curl_setopt($ch, CURLOPT_POST, true);
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
				curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json','Content-length: '.strlen(json_encode($header["body"]))));
				curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($header["body"]));
				break;
		}
		
		//devuelve la respuesta completa con los headers.
		if (DEBUG_CURL){
			curl_setopt($ch, CURLOPT_HEADER, 1);
			return curl_exec($ch);
		}
		
		$output = curl_exec($ch);
		
		$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		
		if (($output == false) && ($httpCode != 302)){
			
			$error = curl_error($ch);
			
			if ($error === "Empty reply from server"){
				$output = curl_exec($ch);
			} else {
				return $error;
			}
			
		} else if ($output == null && ($httpCode != 302)) {
			return curl_error($ch);
		}
		
		curl_close($ch);
		
		return new Response(array("httpCode" => $httpCode, "body" => $output));
		
	}
	
}