<?php
include_once 'config.php';
require_once 'ThalamusConnector.php';
require_once 'Response.php';

/**
 * Provides methods to connect with the ThalamusConnector
 * @author Ezequiel
 * @version 0.9
 */

use \ThalamusConnector;

Class Thalamus {
	
	private $tc;
	
	public function __construct($url = THALAMUS_URL, $touchpoint = TOUCHPOINT, $token = TOKEN)  {		
		$this->tc = new ThalamusConnector($url, $touchpoint, $token);
		session_start();
	}
	
	// login por POST usando de credencial USERNAME Y PASS (opcional segun proyecto)
	// login usando de credencial Documento (Cedula), pasar $documentType el tipo de documento (cedula)
	public function login($credential, $password = "", $documentType = false){
		
		if ($documentType !== false) {
			$credential = $documentType.'$'.$credential;
		}
		if ($password == ""){
			$password = DEFAULT_PASSWORD;
		}

		if($this->checkSession()){
			$this->logout();
			session_start();
		}
		
		$params["body"] = array("principal" => $credential,"password" => $password);
		
		//en caso de exito tengo uqe guardar en session el usuario logueado para luego hacer los GET con basic auth
		$response = $this->tc->executeRequest('POST', 'signin', $params);

		//logueado, guardo credenciales en session
		if (($response instanceof Response) and ($response->getHttpCode() == 302)) {
			$_SESSION["credentials"] = array("principal" => $credential,"password"  => $password);
			$response = $this->getPerson();
		}
		
		return $response;
		
	}
	
	public function getFacebookLink($callbackUrl){
		
		$link = false;
		
		$response = $this->tc->executeRequest("POST", "signin/facebook?callback_url=".$callbackUrl);
		
		if (($response instanceof Response) && ($response->getHttpCode() == 200)) {
			$link = $response->getBody()->link->href;
		}
		
		return $link;
	}
	
	public function loginFacebook($code, $callbackUrl) {
	
		$servicePath = "signin/facebook?code=" . $code . "&callback_url=" . $callbackUrl;
	
		$response = $this->tc->executeRequest("GET", $servicePath);
	
		if (($response instanceof Response) && ($response->getHttpCode() == 200)) {
				
			if($response->getBody()->reason == "SuccessfullySignIn") {
				$principal 		= $response->getBody()->data->principal;
				$tmpPassword 	= $response->getBody()->data->tmp_password;
				$_SESSION['credentials'] = array("principal" => str_replace(':', '$', $principal), "password" => $tmpPassword);
				$response 		= $this->getPerson();
			}
			
		}
	
		return $response;
	}
	
	public function registerFacebook(Array $profile, Array $socialConnections, $optIn, $principal, $password = DEFAULT_PASSWORD) {
		$arr = array();
		$arr["consumers"] 	= array();
		$arr["profile"] 	= $profile;
		$arr["optIns"]		= array(
				array(
						"brandFamilyId" => -1,
						"channel" 		=> -1,
						"accepted" 		=> $optIn
				)
		);
		$arr["socialConnections"][0] = $socialConnections;
// 		$arr["credential"] = array(
// 				"principal" => $principal,
// 				"password" 	=> $password
// 		);
	
		$params["body"] = $arr;
	
		$response = $this->tc->executeRequest("POST", "person", $params);
	
		//logueado, guardo credenciales en session
		if (($response instanceof Response) and ($response->getHttpCode() == 201)) {
			$principal = str_replace(":",'$', $response->getBody()->temporal_credential->principal);
			$tmpPassword = $response->getBody()->temporal_credential->tmp_password;
			$_SESSION["credentials"] = array("principal" => $principal, "password" => $tmpPassword);
		}
	
		return $response;
	}
	
	public function registerOptInChannelFacebook(Array $profile, Array $socialConnections, $optIn, $principal, $password = DEFAULT_PASSWORD) {
		
		$arr = array();
		$arr["consumers"] 	= array();
		$arr["profile"] 	= $profile;
		$arr["optIns"]		= array(
				array(
						"brandFamilyId" => -1,
						"channel" 		=> 6001,
						"accepted" 		=> $optIn
				),
				array(
						"brandFamilyId" => -1,
						"channel" 		=> 6002,
						"accepted" 		=> $optIn
				),
				array(
						"brandFamilyId" => -1,
						"channel" 		=> 6003,
						"accepted" 		=> $optIn
				),
				array(
						"brandFamilyId" => -1,
						"channel" 		=> 6004,
						"accepted" 		=> $optIn
				),
				array(
						"brandFamilyId" => -1,
						"channel" 		=> 6005,
						"accepted" 		=> $optIn
				),
				array(
						"brandFamilyId" => -1,
						"channel" 		=> 6006,
						"accepted" 		=> $optIn
				),
				array(
						"brandFamilyId" => -1,
						"channel" 		=> 6009,
						"accepted" 		=> $optIn
				)
		);
		
		$arr["socialConnections"][0] = $socialConnections;
// 		$arr["credential"] = array(
// 				"principal" => $principal,
// 				"password" 	=> $password
// 		);
	
		$params["body"] = $arr;
	
		$response = $this->tc->executeRequest("POST", "person", $params);
	
		//logueado, guardo credenciales en session
		if (($response instanceof Response) and ($response->getHttpCode() == 201)) {
			$principal = str_replace(":",'$', $response->getBody()->temporal_credential->principal);
			$tmpPassword = $response->getBody()->temporal_credential->tmp_password;
			$_SESSION["credentials"] = array("principal" => $principal, "password" => $tmpPassword);
		}
	
		return $response;
	}
	
	//desloguea al usuario
	public function logout() {
		if(!$this->checkSession()){
			return "Requiere Logueo";
		}
		
		$response = $this->tc->executeRequest("GET", "logout", $_SESSION["credentials"]);
		session_destroy();
		return $response;
		
	}
	
	//obtiene los datos del usuario logueado
	public function getPerson() {
		if(!$this->checkSession()){
			return "Requiere Logueo";
		}
		
		return $this->tc->executeRequest("GET", "person", $_SESSION["credentials"]);
	}
	
	/**
	 * Execute the incoming request
	 * @param $arr 
	 * @return the json response from thalamus
	 */
	public function register(Array $profile, $optIn, $principal, $password = DEFAULT_PASSWORD) {
		$arr = array();
		$arr["consumers"] 	= array();
		$arr["optIns"]		= array(
				array(
						"brandFamilyId" => -1,
						"channel" 		=> -1,
						"accepted" 		=> $optIn
				)
		);
		$arr["profile"] = $profile;
		$arr["credential"] = array(
			"principal" => $principal,
			"password" 	=> $password
		);
		
		
		$params["body"] = $arr;
		
		$response = $this->tc->executeRequest("POST", "person", $params);
		
		//logueado, guardo credenciales en session
		if (($response instanceof Response) and ($response->getHttpCode() == 201)) {
			$_SESSION["credentials"] = array("principal" => str_replace(":",'$', $arr["credential"]["principal"]), "password" => $arr["credential"]["password"]);
		}
		
		return $response;
	}
	
	public function registerOptInChannel(Array $profile, $optIn, $principal, $consumers = array(), $password = DEFAULT_PASSWORD) {
	
		$arr = array();
		$arr["consumers"] 	= $consumers;
		$arr["optIns"]		= array(
				array(
						"brandFamilyId" => -1,
						"channel" 		=> 6001,
						"accepted" 		=> $optIn
				),
				array(
						"brandFamilyId" => -1,
						"channel" 		=> 6002,
						"accepted" 		=> $optIn
				),
				array(
						"brandFamilyId" => -1,
						"channel" 		=> 6003,
						"accepted" 		=> $optIn
				),
				array(
						"brandFamilyId" => -1,
						"channel" 		=> 6004,
						"accepted" 		=> $optIn
				),
				array(
						"brandFamilyId" => -1,
						"channel" 		=> 6005,
						"accepted" 		=> $optIn
				),
				array(
						"brandFamilyId" => -1,
						"channel" 		=> 6006,
						"accepted" 		=> $optIn
				),
				array(
						"brandFamilyId" => -1,
						"channel" 		=> 6009,
						"accepted" 		=> $optIn
				)
		);
		$arr["profile"] = $profile;
		$arr["credential"] = array(
			"principal" => $principal,
			"password" 	=> $password
		);
		
		
		$params["body"] = $arr;
		
		$response = $this->tc->executeRequest("POST", "person", $params);
		
		//logueado, guardo credenciales en session
		if (($response instanceof Response) and ($response->getHttpCode() == 201)) {
			$_SESSION["credentials"] = array("principal" => str_replace(":",'$', $arr["credential"]["principal"]), "password" => $arr["credential"]["password"]);
		}
		
		return $response;
	}
	
	public function updateProfile($profile){
		if(!$this->checkSession()){
			return "Requiere Logueo";
		}
		$arr = array();
		$arr["consumers"] 	= array();
		$arr["profile"]	= $profile;
		
		$header["body"] 		= $arr;
		$header["principal"] 	= $_SESSION['credentials']["principal"];
		$header["password"] 	= $_SESSION['credentials']["password"];
		
		return $this->tc->executeRequest('PUT', 'person', $header);
	}
	
	public function getPersonFields(){
		return $this->tc->executeRequest("GET", "person/fields");
	}
	
	public function requestResetPassword($credential, $documentType = false) {
		if ($documentType !== false) {
			$credential = $documentType.':'.$credential;
		}
		
		$arr = array("body" => array("principal" => $credential));
		
		return $this->tc->executeRequest("POST", "person/password/requestreset", $arr);
	}
	
	public function resetPassword($tokenLink,$newPassword,$principalLink) {
		$arr["body"] = array(
			"token" => $tokenLink,
			"password" => $newPassword,
			"principal" => $principalLink
		);
		
		$response = $this->tc->executeRequest("PUT", "person/password", $arr);
		
		if (($response instanceof Response) and ($response->getHttpCode() == 200)) {
			$_SESSION["credentials"] = array("principal" => str_replace(":",'$', $arr["body"]["principal"]), "password" => $arr["body"]["password"]);
			$response = $this->getPerson();
		}
		return $response;
	}
	
	public function executeQuery($requestType, $servicePath, $body = ""){
		
		$header = "";
		
		if (!empty($body)) {
			$header["body"] = $body;
		}
		
		if(!empty($_SESSION['credentials'])) {
			$header["principal"] = $_SESSION['credentials']["principal"];
			$header["password"] = $_SESSION['credentials']["password"];
		}
		
		return $this->tc->executeRequest($requestType, $servicePath, $header);
	}

	//acepta la invitacion de un evento determinado
	public function eventAcceptance($code, $codigo= false){
		if(!$this->checkSession()){
			return "Requiere Logueo";
		}

		$body = array("accepted" => true);
		
		if ($codigo) {
			$body["ticketCode"] = $codigo;
		}
		
		$arr = array(
			"body" 		=> $body,
			"principal" => $_SESSION['credentials']["principal"],
			"password" 	=> $_SESSION['credentials']["password"]
		);
		
		return $this->tc->executeRequest("PUT", "events/$code/acceptance", $arr);
	}
	
	public function checkAcceptance($code){
		if(!$this->checkSession()){
			return "Requiere Logueo";
		}
		
		$response = $this->getPerson();
		
		$flag = false;
		$activities = $response->getBody()->context->activities;
		if(!empty($activities)) {
			foreach ($response->getBody()->context->activities as $activity) {
				if ($activity->code == $code) {
					if($activity->personStatus->accepted == true) {
						$flag = true;
						continue;
					}
				}
			}
		}
		return $flag;
	}
	
	//confirma la asistencia al evento determinado
	public function eventAttendance($code){
		if(!$this->checkSession()){
			return "Requiere Logueo";
		}

		$arr = array(
				"body" 		=> array("attended" => true),
				"principal" => $_SESSION['credentials']["principal"],
				"password" 	=> $_SESSION['credentials']["password"]
		);
		return $this->tc->executeRequest("PUT", "events/$code/attendance", $arr);
	}
	
	public function checkAttendance($code){
		if(!$this->checkSession()){
			return "Requiere Logueo";
		}
		
		$response = $this->getPerson();
		
		$flag = false;
		$activities = $response->getBody()->context->activities;
		if(!empty($activities)) {
			foreach ($response->getBody()->context->activities as $activity) {
				if ($activity->code == $code) {
					if($activity->personStatus->attended == true) {
						$flag = true;
						continue;
					}
				}
			}
		}
		return $flag;
	}
	
	public function fireInteraction($interactionTypeCode, $additionalInfo = ""){
		if(!$this->checkSession()){
			return "Requiere Logueo";
		}
		
		$arr = array();
		$arr['body'] = array(
			"interactionTypeCode" 	=> $interactionTypeCode, 
    		"additionalInfo" 		=> $additionalInfo
		);
		$arr['principal'] = $_SESSION['credentials']["principal"];
		$arr['password'] = $_SESSION['credentials']["password"];
		
		return $this->tc->executeRequest("POST", 'interaction/fire', $arr);
	}
	
	public function cancelEventAcceptance($code, $codigo= false){
		if(!$this->checkSession()){
			return "Requiere Logueo";
		}
	
		$body = array("accepted" => false);
	
		if ($codigo) {
			$body["ticketCode"] = $codigo;
		}
	
		$arr = array(
				"body" 		=> $body,
				"principal" => $_SESSION['credentials']["principal"],
				"password" 	=> $_SESSION['credentials']["password"]
		);
	
		return $this->tc->executeRequest("PUT", "events/$code/acceptance", $arr);
	}
	
	public function checkSession($credential="") {
	
		if (!empty($_SESSION["credentials"])) {
	
			if ($credential != "") {
				if ($_SESSION["credentials"]["principal"] == $credential){
					return true;
				} else {
					return 0;
				}
			} else {
				return true;
			}
				
		} else {
			return false;
		}
	}
	
	public function getCases($caseId=NULL){
		if(!$this->checkSession()){
			return "Requiere Logueo";
		}
		$header["body"] = $caseId;
		$header["principal"] = $_SESSION['credentials']["principal"];
		$header["password"] = $_SESSION['credentials']["password"];
	
		$caseId = !empty($caseId) ? $caseId : "";
		return $this->tc->executeRequest("GET", "/cases/$caseId", $header);
	}
	
	public function createCase($body){
		if(!$this->checkSession()){
			return "Requiere Logueo";
		}
		$header["body"] = $body;
		$header["principal"] = $_SESSION['credentials']["principal"];
		$header["password"] = $_SESSION['credentials']["password"];
		return $this->tc->executeRequest("POST", "/cases", $header);
	}
	
	public function addNote($caseId,$note){
		if(!$this->checkSession()){
			return "Requiere Logueo";
		}
		$header["body"] = $note;
		$header["principal"] = $_SESSION['credentials']["principal"];
		$header["password"] = $_SESSION['credentials']["password"];
		return $this->tc->executeRequest("POST", "/cases/$caseId/note", $header);
	}
	
	public static function parseDate($date) {
		return strtotime(implode("/", array_reverse(explode("/", str_replace("-", "/", $date))))) * 1000;
	}
	
}