<?php

/**
 * 
 * Class Response
 * 
 * @author Ezequiel
 */


class Response {
	
	private $httpCode 	= "";
	private $rawBody 	= "";
	private $body 		= "";
	private $error 		= "";
	private $errorCode	= "";
	private $errorMsg   = "";

	public function __construct(Array $arr) {
		
		$this->httpCode 	= (!empty($arr["httpCode"])) ? $arr["httpCode"] : "";
		$this->rawBody 		= (!empty($arr["body"])) ? $arr["body"] : "";
		$this->body 		= json_decode($this->rawBody);
		
		$errorCode 	  = 'error.code';
		$errorMessage = 'error.message';
		
		$this->error		= (!empty($this->body->errors)) ? json_encode($this->body->errors) : "";
		$this->errorCode	= (!empty($this->body->errors->$errorCode)) ? $this->body->errors->$errorCode : "";
		$this->errorMsg 	= (!empty($this->body->errors->$errorMessage)) ? $this->body->errors->$errorMessage : "";
		
	}
	
	public function getHttpCode() 	{ return (int)$this->httpCode; }
	public function getRawBody() 	{ return $this->rawBody; }
	public function getBody() 		{ return $this->body; }
	public function getErrorCode() 	{ return $this->errorCode; }
	public function getErrorMsg() 	{ return $this->errorMsg; }
	public function __toString()	{ return $this->body; }
	
	public function getError($idx = false) {
		
		if ($idx) {
			$json = json_decode($this->error);
			
			if (!empty($json->$idx)) {
				return $json->$idx;
			} else {
				return false;
			}
		} else {
			return $this->error;
		}
		
	}
	
}