<?php
$GLOBALS['thalamusProd'] = true;

require_once 'thalamus/config.php';
if(GetParam('enviar')=='Enviar'){
	$profile = array(
			'firstname' 	=> GetParam("nombre"),
			'lastname' 	=> GetParam("apellido"),
			'email'			=> GetParam("email"),
			"address" => array(
					"countryId"	=> COUNTRY,
					"street1"	=> GetParam("direccion")!=='Direcci&oacute;n ' ? GetParam("direccion") : '',
					"street2"	=> GetParam("provincia")!=='Provincia' ? GetParam("provincia") : '',
					"postalCode"=> GetParam("cp")!=='C&oacute;digo Postal' ? GetParam("cp") : '',
					"type"		=> "home",
					"city"		=> GetParam("ciudad")!=='Ciudad' ? GetParam("ciudad") : ''
			)

	);

	if ( GetParam("telefono") !== ""  && strlen(GetParam("telefono"))>=0 && strlen(GetParam("telefono"))<=15 ){
		$profile['telefono'] = GetParam("telefono");
	}

	try{

		$GLOBALS['api'] = "v3";
		$thalamus =  \ThalamusSDK\Thalamus::getInstance();
		//$thalamus->test();die;
		$optIns = \ThalamusSDK\ThalamusHelper::generateOptInsCompany(true);
		$person = $thalamus->register( $profile, $optIns, $profile ['email']);
		$partyId = $person->getId();
		$categoryCode = 'facebook';
		$caseData = array( 
			"zona"			=> GetParam('zona'),
			"motivo"		=> GetParam('motivo'),
			"producto"		=> GetParam('producto'),
			"telefono"		=> GetParam("telefono")
		 );

		$typeCode = getCaseType($caseData['motivo']); //getType('ventas');
		$comentarios = GetParam("comentarios");
		$description = "Comentarios: ".(!empty($comentarios) ? $comentarios : 'S/ Comentario');

		$GLOBALS['api'] = "v4";
		$thalamus =  \ThalamusSDK\Thalamus::getInstance();
		$thalamus->logout();
		$GLOBALS['user'] = '__'.$partyId;
		$thalamus->login($GLOBALS['user']);
		$case = $thalamus->createCase($categoryCode, $typeCode, $caseData, $description);


	} catch ( \ThalamusSDK\ThalamusRequestException $e ) {
		
		$errorsTH = is_array($e->getErrors()) ? $e->getErrors() : array(array("error_name" =>$e->getErrors()));
		foreach ($errorsTH as $errorTH){
			switch ($errorTH["error_name"]) {

				case "PROFILE_LASTNAME_MISMATCH":
				case "FIRSTNAME_LASTNAME_NO_MATCH":
				case "PROFILE_LASTNAME_INVALID":
				case "PROFILE_LASTNAME_REQUIRED":
					setError('apellido', "El apellido no es valido");
					break;
				case "PROFILE_FIRSTNAME_MISMATCH":
				case "PROFILE_FIRSTNAME_REQUIRED":
				case "PROFILE_FIRSTNAME_INVALID":
					setError('nombre', "El nombre no es valido");
					break;
				case "CREDENTIAL_EMAIL_ALREADY_EXISTS":
				case "PROFILE_EMAIL_INVALID":
					setError('email', "El email no es valido");
					break;
				case "CREDENTIAL_CELLPHONE_ALREADY_EXISTS":
				case "CREDENTIAL_ALREADY_EXISTS":
				case "NOT_MATCH_ANY_PRINCIPAL":
					setError('generic', "El email ingresado esta asociado a otro dni") ;
					break;
				case "PHONE_NUMBER_INVALID_FORMAT":
				case "PHONE_TYPE_INVALID_FORMAT":
				case "PHONE_AREACODE_INVALID_FORMAT":
				case "PHONE_NUMBER_INVALID_FORMAT":
				case "CELLPHONE_INTCODE_INVALID_FORMAT":
				case "CELLPHONE_AREACODE_INVALID_FORMAT":
				case "CELLPHONE_NUMBER_INVALID_FORMAT":
					setError('telefono', "El telefono ingresado no es valido") ;
					break;
				case "TOMCAT_SERVER_ERROR":
				case "INTERNAL_SERVER_ERROR":
					setError('generic', "Ocurrió un error al conectarse con el servidor, por favor intente nuevamente mas tarde.") ;
					break;
				default :
					logError($e);
					setError('generic', "Ocurrió un error al crear la consulta") ;
					break;

			}
		}
		$console = json_encode($errorsTH);

	}
	
	if(empty($console)){
		try{

			$thalamus->assignCase($case->getId(), false, getOperatorGroup(GetParam('zona')));

			require_once 'gracias.html';
			exit;

		} catch ( \ThalamusSDK\ThalamusRequestException $e ) {
			logError($e);
			$console = json_encode($e);
		}
	}
}
?>
<!DOCTYPE html>
<html lang="es">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <title>Lo/Jack - Atención al cliente</title>
	<link href="http://coupetest.com/lojackwoman/assets/favicon.ico" type="image/x-icon" rel="shortcut icon"/> 
	<link href="http://coupetest.com/lojackwoman/assets/favicon.ico" type="image/x-icon" rel="icon"/> 
	<link rel="stylesheet" href="css/normalize.css">
	<link rel="stylesheet" href="css/bootstrap.css">
	<link rel="stylesheet" href="css/royalslider.css">
	<link rel="stylesheet" href="fonts/fonts.css">
	<link rel="stylesheet" href="css/main.css">
	<script>
		console.log("<?= isset($console) ? $console : '' ?>");
	</script>
  </head>
  <body>
  
	<div class="container espacio">
	
	<div class="row espacio1">
	<div class="col-sm-12">
	<img src="img/logo.png" class="img-responsive center-block">

	</div>
	</div>		
	
	<div class="row">
			<div class="col-sm-12">
			<p>¿Querés comunicarte con nosotros?<br />Dejanos tus datos.</p>
			</div>
	</div>
	
	<div class="row">
		<div class="col-sm-12">
		<form class="form-horizontal" role="form" method="post" action="">
			<div class="form-group">
				<label for="nombre" class="col-sm-4 control-label">Nombre:</label>
				<div class="col-sm-6">
				<input required type="text" class="form-control" name="nombre" id="nombre" value="<?php echo GetParam('nombre');?>">
				</div>
				<div class="error"><?php echo getError('nombre');?></div>
			</div>
			<div class="form-group">
				<label for="apellido" class="col-sm-4 control-label">Apellido:</label>
				<div class="col-sm-6">
				<input required type="text" class="form-control" name="apellido" id="apellido" value="<?php echo GetParam('apellido');?>">
				</div>
				<div class="error"><?php echo getError('apellido');?></div>
			</div>
			<div class="form-group">
				<label for="email" class="col-sm-4 control-label">Mail:</label>
				<div class="col-sm-6">
				<input required type="email" class="form-control" name="email" id="email" value="<?php echo GetParam('email');?>">
				</div>
				<div class="error"><?php echo getError('email');?></div>
			</div>
			<div class="form-group">
				<label for="telefono" class="col-sm-4 control-label">Teléfono:</label>
				<div class="col-sm-6">
				<input required type="text" class="form-control" name="telefono" id="telefono" value="<?php echo GetParam('telefono');?>">
				</div>
				<div class="error"><?php echo getError('telefono');?></div>
			</div>
			
			<div class="form-group">
				<label for="producto" class="col-sm-4 control-label">Producto</label>
				<div class="col-sm-6">
				<select  name="producto" id="producto" required  class="form-control"  title="" >
					<option value="LoCar">LoCar</option>
					<option value="LoHome">LoHome</option>
					<option value="Transporte y carga">Transporte y carga</option>
					<option value="Seguridad vehicular">Seguridad vehicular</option>
					<option value="LoPet">LoPet</option>
				</select>
				</div>
				<div class="error"><?php echo getError('producto');?></div>
			</div>
			
			<div class="form-group">
				<label for="motivo" class="col-sm-4 control-label">Tipo de Consulta</label>
				<div class="col-sm-6">
				<select  name="motivo" id="motivo" required  class="form-control"  title="Ingrese su tipo de consulta" >
					<option value="Venta">Venta</option>
					<option value="Mudanza">Mudanza</option>		 
					<option value="Quejas y reclamos">Quejas y reclamos</option> 
					<option value="Pedido de factura">Pedido de factura</option>
					<option value="Consultas tecnicas">Consultas t&eacute;cnicas</option> 
					<option value="Cambio de titularidad">Cambio de titularidad</option> 
					<option value="Consultas generales">Consultas generales</option> 
				</select>
				</div>
				<div class="error"><?php echo getError('motivo');?></div>
			</div>
			
			<div class="form-group">
				<label for="zona" class="col-sm-4 control-label">Zona:</label>
				<div class="col-sm-6">
				<select name="zona" id="zona" required  class="form-control"  title="Ingrese su zona" > 
					<option value="GBA NORTE">GBA NORTE</option> 
					<option value="GBA OESTE">GBA OESTE</option> 
					<option value="GBA SUR">GBA SUR</option>
					<option value="CAPITAL">CAPITAL</option> 
					<option value="BUENOS AIRES INTERIOR">BUENOS AIRES INTERIOR</option> 
					<option value="SANTA CRUZ">SANTA CRUZ</option> 
					<option value="CHUBUT">CHUBUT</option> 
					<option value="RIO NEGRO">RIO NEGRO</option> 
					<option value="TIERRA DEL FUEGO">TIERRA DEL FUEGO</option>
					<option value="MENDOZA">MENDOZA</option> 
					<option value="SAN JUAN">SAN JUAN</option> 
					<option value="SAN LUIS">SAN LUIS</option> 
					<option value="MISIONES">MISIONES</option> 
					<option value="CHACO">CHACO</option> 
					<option value="FORMOSA">FORMOSA</option>
					<option value="ENTRE RIOS">ENTRE RIOS</option> 
					<option value="CORRIENTES">CORRIENTES</option> 
					<option value="SANTA FE">SANTA FE</option>   										
					<option value="CORDOBA">CORDOBA</option> 										
					<option value="LA PAMPA">LA PAMPA</option> 
					<option value="SANTIAGO DEL ESTERO">SANTIAGO DEL ESTERO</option> 
					<option value="TUCUMAN">TUCUMAN</option>
					<option value="LA RIOJA">LA RIOJA</option> 
					<option value="CATAMARCA">CATAMARCA</option> 
					<option value="SALTA">SALTA</option> 
					<option value="JUJUY">JUJUY</option> 
                  </select>
				</div>
			</div>
			<div class="form-group">
				<label for="comentarios" class="col-sm-4 control-label">Comentarios:</label>
				<div class="col-sm-6">
				<textarea class="form-control" rows="3" name="comentarios"><?php echo GetParam('comentarios');?></textarea>
				</div>
				<div class="error"><?php echo getError('comentarios');?></div>
			</div>
			
			<div class="form-group">
				<div class="col-sm-4"></div>
				<div class="col-sm-6">
							<button class="btn btn-danger centered" id="enviar" name="enviar" type="submit" value="Enviar">ENVIAR</button>
				<div class="error"><?php echo getError('generic');?></div>
						</div>
				
			</div>
			
			
						
		</form>
	</div>
	</div>
	
	
  </div>
  <script>
 
   (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
   (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
   m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
   })(window,document,'script','//www.google-analytics.com/analytics.js','ga');

   ga('create', 'UA-70505328-1', 'auto');
   ga('send', 'pageview');

</script>
  	  
    <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.2/jquery.min.js"></script>
    <!-- Include all compiled plugins (below), or include individual files as needed -->
    <script src="js/bootstrap.min.js"></script>
  </body>
</html>