//============================================================================
// Title:  Color Matching (Unity-Facebook)
//----------------------------------------------------------------------------
// File:   UserManager.cs
// Author: Nick Breslin (nickbreslin@gmail.com), Waddlefarm.org
//
// Copyright (c) Nick Breslin, 2009. All Rights Reserved.
//----------------------------------------------------------------------------
//
// * This license notice may not be removed or altered.
// * All project files are free for non-commercial or commercial use.
// * I appreciate personal notification if any part of this project is used.
// * All project files are provided "as is". I assume no responsibility for
//   results from using these files, nor should any support be expected.
// * Donations are appreciated, please visit: http://www.waddlefarm.org/donate
//
//============================================================================

using UnityEngine;
using System.Collections;

//============================================================================
//  UserManager
//----------------------------------------------------------------------------
// Managers Facebook Users and Scores.
//============================================================================
public class UserManager : MonoBehaviour
{
	public class User
	{
		public int			id;
		public string		fbid;
		public string		f_name;
		public string		pic_url;
		public int			score = 0;
		public Texture2D	pic   = new Texture2D( 50, 50 );
	}

	public Director		kDirector;
	public User			kUser;

	public void GetUserData()
	{
		Log.Add( "Requesting UserID." ); 
		kDirector.PHP.Request( new WWWForm(), PHPHandler.Action.GetUser, GetUser );
	}

	public void GetUser( string text )
	{
		string[] info = text.Split( ';' );

		if ( info.Length > 1 && info[0][0] != '<' )
		{
			User nUser = new User();
			nUser.id = int.Parse( info[0] );
			nUser.fbid = info[1];
			nUser.f_name = info[2];
			nUser.pic_url = info[3];

			kUser = nUser;

			Log.Add( "Received UserID: " + kUser.id.ToString() + " FbId: " + kUser.fbid );
			Log.Add( "UserID Name: " + kUser.f_name );
		}
		else
		{
			Log.Add( "Couldn't get user data" );
		}
	}

	public void SubmitHighScore( float score )
	{
		if ( null != kUser )
		{
			Log.Add( "Submiting High Score." );
			
			WWWForm Frm = new WWWForm();
			Frm.AddField( "val", score.ToString() );

			kDirector.PHP.Request( Frm, PHPHandler.Action.SubmitHighScore );
		}
	}
}