using UnityEngine;
using System.Collections;

public class Runner : MonoBehaviour
{
	public const int NONE					= 0;
	public const int LEFT					= 1;
	public const int RIGHT					= 2;

	public float	MaxSpeed				= 10;
	public float	DesaccelerationRatio	= 0.25f;

	private bool	m_start					= false;
	private float	m_elapsed				= 0;
	private float	m_time					= 0;
	private float	m_speed					= 0;
	private float	m_accel					= 0;
	private float	m_desaccel				= 0;
	private int		m_cur					= NONE;
	private SlowMotionJump m_jump			= null;

	private bool	m_canStart				= false;
	private float	m_startTime				= 0;
	private bool	m_lose					= false;

	void Start()
	{
		m_jump = gameObject.GetComponent<SlowMotionJump>();
	}

	void Update()
	{
		if ( !m_jump.Jumping() )
		{
			TrackMouse();
			SpeedUpdate();
		}
	}

	public float Speed()
	{
		return m_speed;
	}

	void SpeedUpdate()
	{
		m_speed -= m_desaccel;

		if ( m_speed > MaxSpeed )
		{
			m_speed = MaxSpeed;
		}
		else if ( m_speed < 0 )
		{
			m_speed = 0;
		}

		transform.rigidbody.velocity = new Vector3( m_speed, 0, 0 );
	}

	bool Clicked()
	{
		return Input.GetKeyDown( KeyCode.Space ) || Input.GetMouseButtonUp( 0 );
	}

	bool Left()
	{
		return Input.GetKeyDown( KeyCode.Z ) || Input.GetKeyDown( KeyCode.LeftArrow ) || Input.GetMouseButtonDown( 0 );
	}

	bool Right()
	{
		return Input.GetKeyDown( KeyCode.X ) || Input.GetKeyDown( KeyCode.RightArrow ) || Input.GetMouseButtonDown( 1 );
	}

	bool Expecting()
	{
		if ( m_cur == LEFT )
		{
			return Right();
		}
		else if ( m_cur == RIGHT )
		{
			return Left();
		}
		
		return false;
	}

	void Switch()
	{
		if ( m_cur == LEFT )
		{
			m_cur = RIGHT;
		}
		else if ( m_cur == RIGHT )
		{
			m_cur = LEFT;
		}
		else
		{
			if ( Left() )
			{
				m_cur = LEFT;
			}
			else
			{
				m_cur = RIGHT;
			}
		}
	}

	void TrackMouse()
	{
		if ( m_start )
		{
			m_desaccel = Time.deltaTime / DesaccelerationRatio;

			if ( Expecting() )
			{
				if ( 0 == m_time )
				{
					m_time = Time.time;
				}
				else
				{
					m_elapsed = Time.time - m_time;
					
					if ( m_elapsed > 1 )
					{
						m_elapsed = 1;
					}

					m_accel		= ( 1 / m_elapsed ) / 100 * 10;
					m_speed		+= m_accel;
					m_time		= Time.time;

					//Debug.Log( " m_accel: " + m_accel + "m_speed: " + m_speed  );
				}
			}
			else
			{
				m_accel -= Time.deltaTime / 10;

				if ( m_accel < 0 )
				{
					m_accel		= 0;
				}
			}

			Switch();
		}
		else
		{
			if ( Left() || Right() )
			{
				if ( m_canStart )
				{
					m_start = true;
				}
				else
				{
					m_lose = true;
				}
			}
		}
	}

	void OnGUI()
	{
		if ( !m_lose )
		{
			GUI.color	= new Color( 255, 255, 255 );
			Rect R		= new Rect( 240, 120, 128, 64 );

			m_startTime += Time.deltaTime;

			if ( m_startTime <= 1 )
			{
				GUI.TextArea( R, "Ready" );
			}
			else if ( m_startTime <= 2 )
			{
				GUI.TextArea( R, "SET" );
			}
			else
			{
				m_canStart = true;

				if ( m_startTime <= 2.5f )
				{
					GUI.TextArea( R, "GO!" );
				}
			}
		}

		if ( m_start )
		{
			if ( !m_jump.Jumping() )
			{
				GUI.color = new Color( 0, 255, 0 );
				GUI.HorizontalSlider( new Rect( 32, 64, 568, 32 ), m_speed, 0, MaxSpeed );
			}
		}

		if ( m_lose )
		{
			GUI.color = new Color( 0, 255, 0 );

			if ( GUI.Button( new Rect( 260, 200, 128, 64 ), new GUIContent( "RETRY" ) ) )
			{
				Application.LoadLevel( "WhackATree" );
			}

			if ( GUI.Button( new Rect( 260, 264, 128, 64 ), new GUIContent( "SELECT OTHER\nSPORT" ) ) )
			{
				Application.LoadLevel( "SportsScreen" );
			}
		}
	}

	public bool Lose
	{
		get
		{
			return m_lose;
		}

		set
		{
			m_lose = value;
		}
	}
}
