using UnityEngine;
using System.Collections;

public class Tugboat : MonoBehaviour
{
	public int StarsForBananize				= 1;
	public float MaxFollowDistance			= 25;
	public float MonkeyDistanceX			= 9;
	public float TimeThrowBox				= 1;
	public bool Dummie						= false;

	private bool m_collided					= false;
	private GameObject m_clone				= null;
	private float m_visibleTime				= 0;
	private bool m_startedFollow			= false;
	private bool m_ended					= false;
	private float m_startedX				= 0;
	private float m_timeThrow				= 0;

	private ArrayList m_boxes	= null;

	void Start()
	{
		m_boxes = new ArrayList();
		Hazards.isTugBoat = true;
	}

	void Alert()
	{
		GameObject Obj = GameObject.Find( "MainCamera" );

		if ( Obj.camera.transform.position.x > transform.position.x - 5 - 4 )
		{
			if ( null != m_clone )
			{
				DestroyObject( m_clone );
				m_clone = null;
			}
		}
		else if ( Obj.camera.transform.position.x > transform.position.x - 20 )
		{
			if ( null == m_clone )
			{
				m_clone = Instantiate( gameObject ) as GameObject;
				m_clone.GetComponent<Tugboat>().Dummie = true;
			}

			m_visibleTime += Time.deltaTime;

			if ( m_visibleTime < 0.25f )
			{
				m_clone.transform.position = new Vector3( Obj.camera.transform.position.x + 3, gameObject.transform.position.y, gameObject.transform.position.z );
			}
			else if ( m_visibleTime < 0.5f )
			{
				m_clone.transform.position = new Vector3( Obj.camera.transform.position.x + 3, gameObject.transform.position.y - 500, gameObject.transform.position.z );
			}
			else
			{
				m_visibleTime = 0;
			}
		}
	}

	void Update()
	{
		if ( Dummie )
		{
			return;
		}

		Alert();
		Follower();
		Thrower();
	}

	void Thrower()
	{
		if ( !m_ended && m_startedFollow )
		{
			m_timeThrow += Time.deltaTime;

			if ( m_timeThrow >= TimeThrowBox )
			{
				Throw();
				m_timeThrow = 0;
			}
		}
	}

	void Throw()
	{
		GameObject Monkey = GameObject.Find( "PlayerWater" );

		if ( null != Monkey )
		{
			GameObject Obj = Instantiate( Resources.Load( "obj_tugboat_box" ) ) as GameObject;
			Obj.transform.position = new Vector3( Monkey.transform.position.x + MonkeyDistanceX, transform.position.y, transform.position.z );

			m_boxes.Add( Obj );
		}
	}

	void Follower()
	{
		GameObject Monkey = GameObject.Find( "PlayerWater" );

		if ( null != Monkey )
		{
			if ( !m_ended )
			{
				if ( m_startedFollow )
				{
					transform.position = new Vector3( Monkey.transform.position.x + MonkeyDistanceX, transform.position.y, transform.position.z );

					if ( transform.position.x - m_startedX > MaxFollowDistance )
					{
						m_ended = true;
					}
				}
				else
				{
					if ( Monkey.transform.position.x + MonkeyDistanceX >= transform.position.x )
					{
						m_startedX = Monkey.transform.position.x + MonkeyDistanceX;
						m_startedFollow = true;

						Throw();
					}
				}
			}
			else
			{
				if ( m_startedFollow )
				{
					Hazards.isTugBoat = false; // problem here
					m_startedFollow = false;
				}
			}
		}
	}

	public GameObject GetClosestBox()
	{
		float dist = 999.0f;
		GameObject pivot = null;

		if ( null != m_boxes )
		{
			GameObject MC = GameObject.Find( "MainCamera" );
			Camera Cam = MC.GetComponent<Camera>();

			if ( null != Cam )
			{
				for ( int i = 0; i < m_boxes.Count; i++ )
				{
					GameObject Obj = ( m_boxes[i] as GameObject );

					float tDist = Obj.transform.position.x - Cam.transform.position.x;

					if ( tDist > 0 && tDist < dist )
					{
						pivot = Obj;
						dist = Obj.transform.position.x - Cam.transform.position.x;
					}
				}

				return pivot as GameObject;
			}
		}

		return null;
	}
}
