using UnityEngine;
using System.Collections;

public class Crab : Hazard
{
	private bool m_hazarding		= false;
	public float HazardingTime		= 5.0f;

	protected override void Punished()
	{
		m_hazarding = true;
	}

	protected override void InternalUpdate()
	{
		if ( m_hazarding )
		{
			HazardingTime -= Time.deltaTime;

			if ( HazardingTime >= 0 )
			{
				GameObject Monkey = GameObject.Find( "PlayerWater" );

				if ( null != Monkey )
				{
					Monkey.GetComponent<PlayerWater>().HazardBoost = HazardBoostAtHit;
					transform.position = new Vector3( Monkey.transform.position.x, Monkey.transform.position.y, Monkey.transform.position.z );
				}
			}
			else
			{
				transform.position = new Vector3( transform.position.x, transform.position.y - Time.deltaTime, transform.position.z );
			}
		}
	}
}
