using UnityEngine;
using System.Collections;

public class Hazards : MonoBehaviour
{
	public const int NUM_HAZARDS			= 5;
	public static int Level					= 0;
	public static bool isTugBoat			= false;
	public static bool ModeEasy				= false;
	public Camera m_cam;

	public float DistanceBetweenHazards		= 60;
	public float MinDistanceBetweenHazards	= 20;
	public float HazardReductionRatio		= 0.95f;

	private float m_nextHazardX				= 560;

	private ArrayList m_hazards;

	void Start()
	{
		m_hazards = new ArrayList();
	}
	
	void Update()
	{
		if ( Input.GetKeyDown( KeyCode.C ) )
		{
			ModeEasy = !ModeEasy;
		}

		if ( m_cam.transform.position.x + 60 > m_nextHazardX )
		{
			CreateHazard();
			NextHazard();
			Level++;
		}

		HazardsOffscreen();
	}

	void CreateHazard()
	{
		int rnd = Random.Range( 1, NUM_HAZARDS + 1 );
		//int rnd = 2;
		
		if ( !SpawnHazard( rnd ) 
			&&  !( isTugBoat && rnd == 5 ) // only one tugboat per time
		)
		{
			CreateHazard();
		}
	}

	bool SpawnHazard( int num )
	{
		GameObject Obj = Instantiate( Resources.Load( "obj_hazard_" + num.ToString() ) ) as GameObject;

		MinLevel Lev = Obj.GetComponent<MinLevel>();
		
		if ( null != Lev )
		{
			if ( isTugBoat && !Lev.Flyer ) // When is a tugboat present only create flyers
			{
				DestroyObject( Obj );
			}
			else
			{
				if ( Lev.Level <= Level )
				{
					Obj.transform.position = new Vector3( m_nextHazardX, Obj.transform.position.y, Obj.transform.position.z );
					m_hazards.Add( Obj );

					return true;
				}
			}
		}

		return false;
	}

	void CalcDistance()
	{
		DistanceBetweenHazards *= HazardReductionRatio;

		if ( DistanceBetweenHazards < MinDistanceBetweenHazards )
		{
			DistanceBetweenHazards = MinDistanceBetweenHazards;
		}
	}

	void NextHazard()
	{
		CalcDistance();
		m_nextHazardX += DistanceBetweenHazards;
	}

	void HazardsOffscreen()
	{
		if ( null != m_hazards )
		{
			for ( int i = 0; i < m_hazards.Count; i++ )
			{
				GameObject Obj = m_hazards[i] as GameObject;

				if ( Obj.transform.position.x < m_cam.transform.position.x - 60 )
				{
					m_hazards.RemoveAt( i );
					DestroyObject( Obj );
				}
			}
		}
	}

	public GameObject GetClosestHazard()
	{
		float dist = 999.0f;
		GameObject pivot = null;

		if ( null != m_hazards )
		{
			for ( int i = 0; i < m_hazards.Count; i++ )
			{
				GameObject Obj = m_hazards[i] as GameObject;

				MinLevel Lev = Obj.GetComponent<MinLevel>();

				float tDist = 0;

				if ( Lev.Type == 5 )
				{
					Tugboat Tb = Obj.GetComponent<Tugboat>();

					if ( null != Tb )
					{
						GameObject Box = Tb.GetClosestBox();

						if ( null != Box )
						{
							tDist = Box.transform.position.x - m_cam.transform.position.x;

							if ( tDist > 0 && tDist < dist )
							{
								pivot = Box;
								dist = tDist;
							}
						}
					}
				}
				else
				{
					tDist = ( Obj.transform.position.x - m_cam.transform.position.x );

					if ( tDist > 0 && tDist < dist )
					{
						pivot	= m_hazards[i] as GameObject;
						dist = tDist;
					}
				}
			}

			return pivot as GameObject;
		}

		return null;
	}
}
