using UnityEngine;
using System.Collections;

public class Hazard : MonoBehaviour
{
	public bool AlertsOn					= true;

	public float AlertDistanceFromCamera	= 3;
	public float AlertDistanceAppear		= 20;
	public float AlertDistanceDisappear		= 5;

	public float VelocityToPlayer			= 0.7f;

	public int PowerTakeAtHit				= 15;
	public float HazardBoostAtHit			= 1;

	public int PowerAddOnBananize			= 0;

	public int StarsForBananize				= 3;

	public float MaxForceStopPercentAtHit	= 0.25f;

	protected bool m_bananized				= false;
	protected bool m_collided				= false;

	protected GameObject m_clone			= null;
	protected float m_visibleTime			= 0;
	
	void Update()
	{
		Alert();
		Follow();
		InternalUpdate();
	}

	protected virtual void InternalUpdate()
	{
		// Do your things
	}

	protected virtual void Follow()
	{
		GameObject Player = GameObject.Find( "PlayerWater" );

		transform.rigidbody.velocity = new Vector3( 
			Player.transform.rigidbody.velocity.x * VelocityToPlayer, 
			0, 
			0 
		);
	}

	protected virtual void Alert()
	{
		if ( !AlertsOn )
		{
			return;
		}

		GameObject Obj = GameObject.Find( "MainCamera" );

		if ( Obj.camera.transform.position.x > transform.position.x - AlertDistanceDisappear )
		{
			if ( null != m_clone )
			{
				DestroyObject( m_clone );
				m_clone = null;
			}
		}
		else if ( Obj.camera.transform.position.x > transform.position.x - AlertDistanceAppear )
		{
			if ( null == m_clone )
			{
				m_clone = Instantiate( gameObject ) as GameObject;
			}

			m_visibleTime += Time.deltaTime;

			if ( m_visibleTime < 0.25f )
			{
				m_clone.transform.position = new Vector3( 
					Obj.camera.transform.position.x + AlertDistanceFromCamera, 
					gameObject.transform.position.y, 
					gameObject.transform.position.z 
				);
			}
			else if ( m_visibleTime < 0.5f )
			{
				m_clone.transform.position = new Vector3( 
					Obj.camera.transform.position.x + AlertDistanceFromCamera, 
					gameObject.transform.position.y - 500, 
					gameObject.transform.position.z 
				);
			}
			else
			{
				m_visibleTime = 0;
			}
		}
	}

	protected virtual void Punish()
	{
		GameObject Monkey = GameObject.Find( "PlayerWater" );

		if ( null != Monkey )
		{
			PlayerWater Pla = Monkey.GetComponent<PlayerWater>();

			if ( null != Pla )
			{
				Monkey.rigidbody.AddForce( Vector3.left * ( Pla.MaxFirstHorizontalForce * MaxForceStopPercentAtHit ) );
				
				Pla.PowerTake( PowerTakeAtHit );
				Pla.HazardBoost = HazardBoostAtHit;

				m_collided = true;
				Punished();
			}
		}
	}

	protected virtual void Punished()
	{
	}

	protected virtual void Bananized()
	{
		transform.position = new Vector3( transform.position.x, transform.position.y - 500, transform.position.z );
	}

	protected virtual void Bananize( Collider _collider )
	{
		GameObject Monkey = GameObject.Find( "PlayerWater" );

		if ( null != Monkey )
		{
			PlayerWater Pla = Monkey.GetComponent<PlayerWater>();

			if ( null != Pla )
			{
				Pla.AddStars( StarsForBananize );
				Pla.PowerAdd( PowerAddOnBananize );

				m_bananized = true;
				m_collided = true;
				Bananized();
				DestroyObject( _collider.gameObject );
			}
		}
	}

	protected virtual void OnTriggerEnter( Collider _collider )
	{
		if ( m_collided )
		{
			return;
		}

		if (
			_collider.gameObject.name == "PlayerWater" ||
			_collider.gameObject.name == "palangana" ||
			_collider.gameObject.name == "Sphere"
		)
		{
			Punish();
		}
		else if ( _collider.gameObject.name == "obj_banana(Clone)" )
		{
			Bananize( _collider );
		}

		OnCollide( _collider );
	}

	protected virtual void OnCollide( Collider _collider )
	{
	}
}
