using UnityEngine;
using System.Collections;

public class Bowl : MonoBehaviour
{
	public bool isRealBow = true;
	public float zFixer = 0;
	public bool yFollow = true;
	public bool Scale = false;

	void FixedUpdate()
	{
		Follow();
	}

	void Update()
	{
		Follow();
		CheckShowShadow();
	}

	void CheckShowShadow()
	{
		if ( !isRealBow )
		{
			GameObject Monkey = GameObject.Find( "PlayerWater" );

			if ( null != Monkey )
			{
				PlayerWater Pla = Monkey.GetComponent<PlayerWater>();

				if ( null != Pla )
				{
					if ( Pla.Ended() )
					{
						DestroyObject( gameObject );
					}
				}
			}
		}
	}

	void Follow()
	{
		GameObject Monkey = GameObject.Find( "PlayerWater" );

		if ( null != Monkey )
		{
			if ( yFollow )
			{
				transform.position = new Vector3( Monkey.transform.position.x, Monkey.transform.position.y, Monkey.transform.position.z + zFixer );
			}
			else
			{
				transform.position = new Vector3( Monkey.transform.position.x, transform.position.y, Monkey.transform.position.z + zFixer );
			}


			if ( Scale )
			{
				float tScale = (  Monkey.transform.position.y - transform.position.y ) / 10;
				transform.localScale = new Vector3( 1 + tScale, 1, 1 + tScale );
			}
		}
	}

	void OnTriggerEnter( Collider collisionInfo )
	{
		if ( isRealBow )
		{
			GameObject Monkey = GameObject.Find( "PlayerWater" );

			if ( null != Monkey )
			{
				PlayerWater Pla = Monkey.GetComponent<PlayerWater>();

				if ( null != Pla )
				{
					Pla.BowlTouched = Time.time;
				}
			}
		}
	}
}
