using UnityEngine;
using System.Collections;

public class RandomObj
{
	private GameObject m_obj		= null;
	private float m_speed			= 20;
	private float m_side			= 1;

	public RandomObj( GameObject Obj, float Side, float Speed )
	{
		m_obj = Obj;
		m_speed = Speed;
		m_side = Side;
		SetPos();
	}

	void SetPos()
	{
		float y = m_obj.transform.position.y < TerrainGenerator.FLYING_OBJ_MIN_DIST ? TerrainGenerator.FLYING_OBJ_MIN_DIST + Random.Range( 0.0f, 20.0f ) : m_obj.transform.position.y;

		m_obj.transform.position = new Vector3(
			m_obj.transform.position.x,
			y,
			m_obj.transform.position.z + ( Random.Range( 0.0f, 1.0f ) > 0.5f ? -25 : 0 )
		);
	}

	public GameObject Obj()
	{
		return m_obj;
	}

	public float Speed()
	{
		return m_speed;
	}

	public float Side()
	{
		return m_side;
	}

	public void Update()
	{
		if (null != m_obj)
		{
			m_obj.transform.position = new Vector3(
						m_obj.transform.position.x + ( Time.deltaTime * m_speed * m_side ),
						m_obj.transform.position.y,
						m_obj.transform.position.z
					);

			if ( m_side == 1)
			{
				if ( m_obj.transform.position.x > TerrainGenerator.CAM_RIGHT_OFF )
				{
					kill();
				}
			}
			else
			{
				if ( m_obj.transform.position.x < TerrainGenerator.CAM_LEFT_OFF )
				{
					kill();
				}
			}
		}
	}

	public void kill()
	{
		Player.TerrainGen.RemoveRandomObj( this );
		m_obj = null;
	}
}
