using UnityEngine;
using System.Collections;

public class Poo : MonoBehaviour
{
	private bool m_collided = false;

	void Update ()
	{
		if ( !renderer.isVisible )
		{
			DestroyObject( gameObject );
		}
	}

	void OnTriggerEnter( Collider collisionInfo )
	{
		if ( m_collided )
		{
			return;
		}

		if ( collisionInfo.name.Contains( "obj_branch" ) )
		{
			BranchEvents Be = collisionInfo.gameObject.GetComponent<BranchEvents>();

			if ( null != Be )
			{
				rigidbody.useGravity = false;
				rigidbody.isKinematic = true;

				Be.AddPoo();
				m_collided = true;
			}
		}
	}
}
