using UnityEngine;
using System.Collections;

public class Player : MonoBehaviour
{
	public const float MonkeyPixHWidth			= 32;
	public const float MonkeyMaxOffScreenDist	= 0;

	public static TerrainGenerator TerrainGen	= null;
	public static float m_score					= 0.0f;
	public static int m_stars					= 0;

	public Camera m_cam							= null;
	public float force							= 180.0f;
	public float move							= 10.0f;
	public float camDistance					= 10.0f;
	public float PunchForce						= 300;
	public float PunchBorderTime				= 1;
	public float PunchHitTime					= 0.5f;

	private bool m_ended					= false;
	private bool m_notFirst						= false;
	private bool m_colliding					= true;
	private bool m_jumping						= false;
	private float m_lastY						= -100.0f;
	private bool m_firstJump					= true;

	//private float m_timeTryingMoveLeft			= 0;
	//private float m_timeTryingMoveRight			= 0;
	private float m_onHit						= 0;
	private Vector3 m_player2dPos;
	
	void Start()
	{
	}

	public int Stars()
	{
		return m_stars;
	}

	public float Score()
	{
		return m_score;
	}

	void CheckScore()
	{
		if ( m_score < transform.position.y )
		{
			m_score = transform.position.y;
		}
	}

	void FixedUpdate()
	{
		if ( m_ended )
		{
			return;
		}

		transform.position = new Vector3( transform.position.x, transform.position.y, camDistance );
		
		if ( m_jumping )
		{
			if ( transform.position.y < m_lastY )
			{
				if ( null != TerrainGen )
				{
					TerrainGen.BranchsEnable();
				}

				m_jumping = false;
			}
		}
		else
		{
			if ( m_firstJump && m_colliding )
			{
				if ( Input.GetKey(KeyCode.Space) || Input.GetMouseButtonDown( 0 ) )
				{
					Jump();
					m_colliding = false;
					m_firstJump = false;
					m_notFirst = true;
				}
			}
		}

		if ( m_onHit <= 0 )
		{
			m_player2dPos = m_cam.WorldToScreenPoint( transform.position );

			if ( m_player2dPos.x > MonkeyMaxOffScreenDist )
			{
				if (WantMoveLeft())
				{
					MoveLeft();
				}
			}
			else
			{
				if ( WantMoveLeft() )
				{
					//m_timeTryingMoveLeft += Time.deltaTime;

					//if ( m_timeTryingMoveLeft > PunchBorderTime )
					{
						PunchRight();
					}
				}
			}

			if ( m_player2dPos.x < Screen.width - MonkeyMaxOffScreenDist )
			{
				if ( WantMoveRight() )
				{
					MoveRight();
				}
			}
			else
			{
				if ( WantMoveRight() )
				{
					//m_timeTryingMoveRight += Time.deltaTime;

					//if ( m_timeTryingMoveRight > PunchBorderTime )
					{
						PunchLeft();
					}
				}
			}
		}
		else
		{
			m_onHit -= Time.deltaTime;
		}

		m_lastY = transform.position.y;

		CheckLose();
		CheckScore();
	}

	void CheckLose()
	{
		if ( !m_ended && !renderer.isVisible && m_notFirst )
		{
			m_ended = true;
			//kDirector.kUserManager.SubmitHighScore( Score() );
			Debug.Log( "You Lose", this );
		}
	}

	public void PunchRight()
	{
		PunchRight( PunchForce );
	}

	public void PunchRight( float _force )
	{
		rigidbody.AddForce( Vector3.right * _force );
		//m_timeTryingMoveLeft = 0;
		m_onHit = PunchHitTime;
	}

	public void PunchLeft()
	{
		PunchLeft( PunchForce );
	}

	public void PunchLeft( float _force )
	{
		rigidbody.AddForce( Vector3.left * _force );
		//m_timeTryingMoveRight = 0;
		m_onHit = PunchHitTime;
	}

	bool WantMoveLeft()
	{
		return Input.GetKey( KeyCode.LeftArrow ) || Input.mousePosition.x < ( m_player2dPos.x - MonkeyPixHWidth );
	}

	bool WantMoveRight()
	{
		return Input.GetKey( KeyCode.RightArrow ) || Input.mousePosition.x > ( m_player2dPos.x + MonkeyPixHWidth );
	}

	void OnCollisionExit( Collision collisionInfo )
	{
		if ( !m_firstJump )
		{
			if ( !m_jumping )
			{
				m_colliding = false;
			}
		}
	}

	void OnCollisionEnter( Collision collisionInfo )
	{
		if ( !m_firstJump )
		{
			if ( !m_jumping )
			{
				float extraForce = 0;

				if ( collisionInfo.collider.name == "Terrain" ) //  || TerrainGen.HitTest( collisionInfo.gameObject, ref extraForce )
				{
					m_colliding = true;
					Jump( extraForce );
				}
			}
		}
	}

	public bool Colliding
	{
		get
		{
			return m_colliding;
		}

		set
		{
			m_colliding = value;
		}
	}

	public bool FirstJump()
	{
		return m_firstJump;
	}

	public bool Jumping
	{
		get
		{
			return m_jumping;
		}

		set
		{
			m_jumping = value;
		}
	}

	public void MoveLeft()
	{
		MoveLeft( move );
	}

	public void MoveRight()
	{
		MoveRight( move );
	}

	public void MoveLeft( float move )
	{
		Vector3 Pos = new Vector3( transform.position.x - Time.deltaTime * move, transform.position.y, camDistance );
		rigidbody.MovePosition( Pos );
	}

	public void MoveRight( float move )
	{
		Vector3 Pos = new Vector3( transform.position.x + Time.deltaTime * move, transform.position.y, camDistance );
		rigidbody.MovePosition( Pos );
	}

	public void Jump()
	{
		Jump(0);
	}

	public void Jump( float extraForce )
	{
		float finalForce = force + extraForce;

		rigidbody.velocity = new Vector3();
		rigidbody.AddForce( Vector3.up * finalForce );

		if ( null != TerrainGen )
		{
			TerrainGen.BranchsDisable();
		}
	
		m_jumping = true;
	}

	void OnGUI()
	{
		if ( m_ended )
		{
			GUI.color = new Color( 0, 255, 0 );

			if ( GUI.Button( new Rect( 260, 200, 128, 64 ), new GUIContent( "RETRY" ) ) )
			{
				Application.LoadLevel( "TreeClimbing" );
			}

			if ( GUI.Button( new Rect( 260, 264, 128, 64 ), new GUIContent( "SELECT OTHER\nSPORT" ) ) )
			{
				Application.LoadLevel( "SportsScreen" );
			}
		}
	}
}
