using UnityEngine;
using System.Collections;

public class MoveCameraUp : MonoBehaviour
{
	public float InitialSpeed			= 0.1f;
	public float MaxPlayerDist			= 1.0f;
	public float OffScreenDist			= 5.0f;
	public float StartMoveCameraTime	= 2.5f;
	public float CamAcceleration		= 0.001f;

	private float m_totTime				= 0.0f;
	private float m_lastMonkeyPos;
	
	void Start ()
	{
	}

	void OnGUI()
	{

		GUI.color = new Color( 0, 0, 0 );

		GameObject Monkey = GameObject.Find( "Player" );

		if (null != Monkey)
		{
			Player Pla = Monkey.GetComponent<Player>();

			if (null != Pla)
			{
				GUI.Label(new Rect(0, 0, 128, 32), new GUIContent( "Score: " + Pla.Score() + "\nStars: " + Pla.Stars() ) );
			}
		}
	}
	
	void FixedUpdate()
	{
		m_totTime += Time.deltaTime;

		if ( m_totTime > StartMoveCameraTime )
		{
			InitialSpeed += Time.deltaTime * CamAcceleration;
			transform.position = new Vector3( transform.position.x, transform.position.y + Time.deltaTime * InitialSpeed, transform.position.z );
		}

		GameObject Monkey = GameObject.Find( "Player" );

		if ( null != Monkey )
		{
			if ( Monkey.transform.position.y - transform.position.y > MaxPlayerDist )
			{
				transform.position = new Vector3( transform.position.x, transform.position.y + ( Monkey.transform.position.y - m_lastMonkeyPos ), transform.position.z );
			}

			if ( transform.position.y - Monkey.transform.position.y > OffScreenDist )
			{
				//Debug.Log("Out of screen");
			}

			m_lastMonkeyPos = Monkey.transform.position.y;
		}
	}
}
