using UnityEngine;
using System.Collections;

public class BranchEvents : MonoBehaviour
{
	public static float BouncyBranchForce	= 250.0f;
	public static float PooBranchForce		= -150.0f;

	public int Type = 0;
	private int m_collide		= 0;
	private bool m_isDestroyed	= false;
	private bool m_havePoo		= false;

	void Start ()
	{
	}
	
	void Update ()
	{
	}

	public void addCollide()
	{
		m_collide++;

		switch ( Type )
		{
			case TerrainGenerator.BRANCH_BROKEN:
				if ( m_collide > 1 )
				{
					rigidbody.isKinematic = false;
					rigidbody.useGravity = true;
					m_isDestroyed = true;
				}
				break;
			case TerrainGenerator.BRANCH_ROTTEN:
				rigidbody.isKinematic = false;
				rigidbody.useGravity = true;
				m_isDestroyed = true;
				break;
		}
	}

	public int collisions()
	{
		return m_collide;
	}

	public bool destroyed()
	{
		return m_isDestroyed;
	}

	public float extraForce()
	{
		float totForce = 0;

		if ( Type == TerrainGenerator.BRANCH_RUBBER )
		{
			totForce += BouncyBranchForce;
		}

		if ( m_havePoo )
		{
			totForce += PooBranchForce;
			m_havePoo = false;
		}

		return totForce;
	}

	void OnTriggerEnter(Collider collisionInfo)
	{
		if ( collisionInfo.collider.name == "Player" )
		{
			Player Pla = collisionInfo.gameObject.GetComponent<Player>();

			if ( null != Pla )
			{
				if ( !Pla.FirstJump() )
				{
					if ( !Pla.Jumping )
					{
						Pla.Colliding = true;
						Pla.Jump( extraForce() );
					}
				}
			}
		}
	}

	public void TriggerEnable()
	{
		gameObject.collider.isTrigger = true;
	}

	public void TriggerDisable()
	{
		gameObject.collider.isTrigger = false;
	}

	public GameObject Obj()
	{
		return gameObject;
	}

	public void AddPoo()
	{
		m_havePoo = true;
	}
}
