using UnityEngine;
using System.Collections;

public class Bird : MonoBehaviour
{
	public float FollowTime			= 2;
	public float DistanceToCamera	= 3.0f;

	private bool m_startedFollowing = false;
	private bool m_escape			= false;
	private float m_elapsed			= 0;
	
	void Update ()
	{
		GameObject CamObj = GameObject.Find( "MainCamera" );

		if ( null != CamObj )
		{
			Camera Cam = CamObj.GetComponent<Camera>();

			if ( !m_startedFollowing )
			{
				if ( Cam.transform.position.y + DistanceToCamera > transform.position.y )
				{
					m_startedFollowing = true;
				}
			}
			else
			{
				if ( Cam.transform.position.y + DistanceToCamera > transform.position.y )
				{
					transform.position = new Vector3( transform.position.x, Cam.transform.position.y + DistanceToCamera, transform.position.z );
				}
				
				m_elapsed += Time.deltaTime;

				if ( m_elapsed >= FollowTime )
				{
					DropPoo();
				}
			}

			if ( m_escape )
			{
				transform.position = new Vector3( transform.position.x + Time.deltaTime * 4, transform.position.y, transform.position.z );

				if ( renderer.isVisible == false )
				{
					DestroyObject( gameObject );
				}
			}
		}
	}

	void DropPoo()
	{
		if ( !m_escape )
		{
			GameObject Obj = Instantiate( Resources.Load( "obj_poo" ) ) as GameObject;

			Obj.transform.position = new Vector3( transform.position.x, transform.position.y, transform.position.z );

			m_startedFollowing = false;
			m_escape = true;
		}
	}

	void OnTriggerEnter( Collider collisionInfo )
	{
		if ( collisionInfo.name.Contains( "obj_banana" ) )
		{
			DestroyObject( gameObject );
			DestroyObject( collisionInfo.gameObject );
		}
	}
}
