using UnityEngine;
using UnityEditor;
using System.Collections;

public class Parenting : MonoBehaviour 
{
	[MenuItem ("GameObject/Parent to root")]
    static void ParentToRoot()
	{
		Debug.Log( Selection.gameObjects.Length );
		
		for( int i = 1; i < Selection.gameObjects.Length; ++i )
		{
			//Debug.Log( Selection.gameObjects[i].name );
			Selection.gameObjects[i].transform.parent = Selection.gameObjects[0].transform;
		}
		
    }

    // Validate the menu item.
    [MenuItem ("GameObject/Parent to root", true)]
    static bool ValidateParenting()
	{
        return Selection.activeTransform != null && Selection.gameObjects.Length >=2;
    }


	[MenuItem ("GameObject/Unparent")]
    static void Unparent()
	{
		Debug.Log( Selection.gameObjects.Length );
		
		for( int i = 0; i < Selection.gameObjects.Length; ++i )
		{
			Selection.gameObjects[i].transform.parent = null;
		}
		
    }

    [MenuItem ("GameObject/Unparent", true)]
    static bool ValidateUnparent()
	{
        return Selection.activeTransform != null && null != Selection.activeTransform.parent;
    }

	
	
}
