<?php
define( "REGEXP_PHONE", "/^[\(]?(\d{0,5})[\)]?[\s]?[\-]?(\d{3,4})[\s]?[\-]?(\d{4})[\s]?[x]?(\d*)$/");
define( "REGEXP_EMAIL", "/^[A-z0-9][\w.-]*@[A-z0-9][\w\-\.]+\.[A-z0-9]{2,6}$/");
define( "REGEXP_WEB","/^[A-Za-z0-9][A-Za-z0-9-]*[A-Za-z0-9](.[A-Za-z0-9][A-Za-z0-9-]*[A-Za-z0-9])+$/");
define( "REGEXP_DATE", "/^(0?[1-9]|[12][0-9]|3[01])[-\/](0?[1-9]|1[012])[-\/](19|20)[0-9][0-9]$/" ); //dd-mm-yyyy
define( "REGEXP_DNI", "/^(\d{1,3})[.]?(\d{3})[.]?(\d{3})$/");
define( "REGEXP_PASS", "/^.{5,}$/");
define( "REGEXP_MINCHARS", "/^.{3,}$/");
define( "REGEXP_URL", "/(ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?/");
define( "REGEXP_HOUR", "/^((?:[01]\d)|(?:2[0-3])):([0-5]\d)$/");
define( "LS_GF_REQFIELD", "Campo Requerido" );
define( "LS_GF_OKFIELD", "OK" );
define( "LS_GF_PASSNC", "Las claves deben coincidir." );

define( "LS_GF_ERRSEND", "No se puede env&iacute;ar el formulario porque contiene errores." );
define( "LS_GF_OKSEND", "El formulario se envio correctamente" );
define( "ERROR_DB", "<h3>Error al ingresar los datos a la DB</h3>");

$validation_array = array (
	'any'   => array( 'regex' => '/^$/', 'emsg' => ''),
	'min'   => array( 'regex' => REGEXP_MINCHARS, 'emsg' => 'Debe ingresar como m&iacute;nimo 3 caracteres'),
    'num'   => array( 'regex' => '/^\d+$/', 'emsg' => 'Ingrese solo n&uacute;meros'),
    'alpha' => array( 'regex' => '/^[a-z\sA-Z|á|é|í|ó|ú|ñ]+$/', 'emsg' => 'Ingrese solo letras'),
    'address' => array( 'regex' => '/^([a-z\sA-Z0-9\.\,\°\(\)])+$/', 'emsg' => 'Solo n&uacute;meros y letras'),
    'alnum' => array( 'regex' => '/^[a-z\sA-Z0-9]+$/', 'emsg' => 'Solo n&uacute;meros y letras'),
    'email' => array( 'regex' => REGEXP_EMAIL, 'emsg' => 'Ingrese un email v&aacute;lido'),
    'web' => array( 'regex' => REGEXP_WEB, 'emsg' => 'Direcci&oacute;n web inv&aacute;lida'),
	'url' => array( 'regex' => REGEXP_URL, 'emsg' => 'Direcci&oacute;n web inv&aacute;lida'),
    'date' => array( 'regex' => REGEXP_DATE, 'emsg' => 'Fecha inv&aacute;lida: DD/MM/YYYY'),
    'phone' => array( 'regex' => REGEXP_PHONE, 'emsg' => 'Telefono inv&aacute;lido'),
    'pass' => array( 'regex' => REGEXP_PASS, 'emsg' => 'Debe ingresar m&aacute;s de 5 caracteres'),
    'dni' => array( 'regex' => REGEXP_DNI, 'emsg' => 'Ingrese un DNI v&aacute;lido'),
    'textarea' => array( 'regex' => '/^\w+$/', 'emsg' => ''),
    'select' => array( 'regex' => '/^\w+$/', 'emsg' => ''),
	'hour' => array ( 'regex' => REGEXP_HOUR, 'emsg' => 'Hora inv&aacute;lida.')
);

function validatefield($value, $type='any', $req=false, $passopt='') {
	global $validation_array;
	
	$a = $validation_array[ $type ];
	$empty = trim($value)=='';
	
	if($empty)
		if($req)
			return LS_GF_REQFIELD;
		else
			return ''; 				# OK
	
	if($type=='passconf')
		if($value!=$passopt) 		# password no igual al original
			return LS_GF_PASSNC;
		else
			return '';
		
	
	if( $type!='text' && !preg_match( $a['regex'], $value ) ) # error, no cumple con el regex
		return $a['emsg'];
	else
		return ''; 					# OK
}

function validatefields(&$objResponse, &$form, $form_id, $fields) {
	$err = false;
	foreach ($fields as $v=>$t) {
		$s = explode('-', $t);
		$req = $s[1]!='' ? true : false;
		
		$msgval = validatefield($form[$v], $s[0], $req);
		if ($msgval!='' && $msgval != LS_GF_OKFIELD) {
			$objResponse->assign($form_id.'_'.$v.'_state', 'innerHTML', $msgval);
			$err = true;
		} else {
			$objResponse->assign($form_id.'_'.$v.'_state', 'innerHTML', LS_GF_OKFIELD);
		}
	}
	return $err;
}
?>