<?php
class cTagBase {
	protected $xid;
	protected $xclass;
	protected $xlabel;
	protected $bodytxt;
	protected $ended;
	protected $emptytag;
	protected $newline;
	
	var $childs; 		# array que contiene objetos hijos
	protected $text;
	
	function cTagBase($xlabel, $xid, $xclass, $stdhdr=true, $isempty=false, $extratag = '', $intext = '', $new_line=false) {
    		$this->emptytag=$isempty;
    		$this->xlabel=$xlabel;
    		$this->bodytxt='';
            $this->xid=$xid;
            $this->xclass=$xclass;
            $this->childs=array();
            $this->text='';
            $this->bodytxt='';
			$this->ended=false;
			$this->newline = $new_line;
			
			if($stdhdr) 		# imprime el encabezado estandar
				$this->printl( maketag($this->xlabel, $xid, $xclass, $isempty, $extratag).$intext, $this->newline );
    }
	
    private function get_base_tabs() {
    	return repeatstr("\t", cPage::tabs_get());
    }
    
	public function render(){
		if(!$this->ended && !$this->emptytag){
			$this->t_printl(1, $this->text, $this->newline);
			
			foreach($this->childs as $child)			# dibuja los nodos hijo
				$this->t_printl(1, $child->render(), false );
			
			$this->printl('</'.$this->xlabel.'>'); 		# finaliza
			
			$this->ended=true;
		}
		
		return $this->bodytxt;
	}
	
	protected function printl($str,$newline=true){			# imprime en el cuerpo, con nueva linea
		if($newline)
			$str .= "\n";

		$this->bodytxt.=$str;
	}
	
	protected function t_printl($t,$str,$newline=true){ 	# imprime en el cuerpo, con tabs al principio
		if(trim($str)!='') {
			$ret='';
			$tabs = repeatstr("\t", $t);
			
			for($i=0;$i<strlen($str);$i++)
				if( $str[$i] == "\n" ) {
					if($i!=0 && $str[$i-1]!="\n" && !($i==strlen($str)-1 && !$newline))
						$ret.="\n".$tabs;
				} else
					$ret.=$str[$i];
				
				$this->printl($tabs.$ret);
		}
	}
	
    function setbody($text){
    	$this->text=$text;
    }
	
    function getbody($text){
    	return $this->text;
    }
	 
    function setid($id){
    	$this->xid=$id;
    }
	
	function setclass($class){
    	$this->xclass=$class;
    }
    
    function & addchild(&$child){
    	if(!$this->emptytag)
    		$this->childs[]=&$child;
    	else
    		die("[Error, un tag vacio no puede tener elementos derivados: $this->addchild]");
    	
    	return $child;
    }
    
    function & addchilds(&$child){
    	if(!$this->emptytag) {
			foreach($child as $ch)
				$this->childs[]=$ch;
    	} else
    		die("[Error, un tag vacio no puede tener elementos derivados: $this->addchild]");
    	
    	return $child;
    }
}
?>