<?php
class cTable extends cTagBase {
	private $ctr;
	
	function cTable($id='',$class='', $width='', $align='center') {
		switch ($align) {
			case 'left':	$al='margin-right: auto;';	break;
			case 'right':	$al='margin-left: auto;';	break;
			case 'center':	$al='margin: auto;';	break;
		}
		parent::cTagBase('table', $id, $class, true, false, makeattr('width', $width).makeattr('style', $al));
		$this->printl('');
		$this->ctr = false;
	}
	
    private function closetr() {
    	if($this->ctr) {
			$this->ctr=false;
			$this->printl('</tr>');
		}
    }
	
	function addrow($id='', $class='', $extratag='') {
		$this->closetr();
		$this->printl( maketag('tr', $id, $class, false, $extratag) );
		$this->ctr=true;
	}
	
	function addfield($text, $id='', $class='', $span='', $width='', $extratag='', $tabs=1) {
		$attr=array();
		$attr['id']=$id;
		$attr['class']=$class;
		$attr['colspan']=$span;
		$this->t_printl($tabs, maketagext('td', $attr, false, makeattr('style', $width = $width ? 'width: '.$width.'px;' : '').$extratag).$text.endtag('td'), false );
	}
	
	function addheader($text, $id='', $class='', $width='', $extratag='', $tabs=1) {
		$attr=array();
		$attr['id']=$id;
		$attr['class']=$class;
		$attr['colspan']=$span;
		$attr['width']=$width;
		$this->t_printl($tabs, maketagext('th', $attr, false, $extratag).$text.endtag('th'), false );
	}
	
	function render() {
		$this->closetr();
		return parent::render();
	}
}
?>