<?php
class cDiv extends cTagBase {
	function cDiv($xid='', $xclass='', $style='', $extratag='') {
		parent::cTagBase('div', $xid, $xclass, true, false, makeattr('style', $style).$extratag, '', true);
	}
}

class cImg extends cTagBase {
	function cImg($src, $xid='', $xclass='', $alt='', $title='', $extratag='') {
		parent::cTagBase('img', $xid, $xclass, true, true, makeattr('src',$src).makeattr('alt',$alt).makeattr('title',$title).$extratag, '', true);
	}
}

class cSpan extends cTagBase {
	function cSpan($text, $xid='', $xclass='', $extratag='') {
		parent::cTagBase('span', $xid, $xclass, true, false, $extratag, $text);
	}
}

class cPara extends cTagBase {
	function cPara($text, $xid='', $xclass='', $extratag='') {
		parent::cTagBase('p', $xid, $xclass, true, false, $extratag, $text);
	}
}

class cBr extends cTagBase {
	function cBr() {
		parent::cTagBase('br','','',true,true,'','',true);
	}
}

class cHr extends cTagBase {
	function cHr() {
		parent::cTagBase('hr','','',true,true,'','',true);
	}
}

class cLink extends cTagBase {
	function cLink($src, $linktext='', $xid='', $xclass='', $title='', $extratag='') {
		parent::cTagBase('a', $xid, $xclass, true, false, makeattr('href',$src).makeattr('title',$title).$extratag, $linktext);
	}
}

class cAjaxLink extends cLink {
	function cAjaxLink($onclick, $linktext='', $xid='', $xclass='', $title='', $extratag='') {
		parent::cLink('##', $linktext, $xid, $xclass, $title, makeattr('onclick',$onclick).$extratag);
	}
}

class cCustom extends cTagBase {
	function cCustom($body) {
		parent::cTagBase('','','',false,true); $this->printl( $body );
	}
}

class cH1 extends cTagBase {
	function cH1($text='', $xid='', $xclass='', $extratag='') {
		parent::cTagBase('h1', $xid, $xclass, true, false, $extratag, $text);
	}
}

class cH2 extends cTagBase {
	function cH2($text='', $xid='', $xclass='', $extratag='') {
		parent::cTagBase('h2', $xid, $xclass, true, false, $extratag, $text);
	}
}

class cH3 extends cTagBase {
	function cH3($text='', $xid='', $xclass='', $extratag='') {
		parent::cTagBase('h3', $xid, $xclass, true, false, $extratag, $text);
	}
}

class cH4 extends cTagBase {
	function cH4($text='', $xid='', $xclass='', $extratag='') {
		parent::cTagBase('h4', $xid, $xclass, true, false, $extratag, $text);
	}
}

class cTr extends cTagBase {
	function cTr($xid='', $xclass='', $extratag='', $text='') {
		parent::cTagBase('tr', $xid, $xclass, true, false, $extratag, $text);
	}
}

class cOl extends cTagBase {
	function cOl($xid='', $xclass='', $extratag='', $text='') {
		parent::cTagBase('ol', $xid, $xclass, true, false, $extratag, $text);
	}
}

class cTd extends cTagBase {
	function cTd($xid='', $xclass='', $extratag='', $text='') {
		parent::cTagBase('td', $xid, $xclass, true, false, $extratag, $text);
	}
}

class cLi extends cTagBase {
	function cLi($xid='', $xclass='', $extratag='', $text='') {
		parent::cTagBase('li', $xid, $xclass, true, false, $extratag, $text);
	}
}

class cInput extends cTagBase {
	function cInput($xid='', $xclass='', $name='', $value='', $extratag='') {
		parent::cTagBase('input', $xid, $xclass, true, true, ' type="text"'.makeattr('name',$name).makeattr('value',$value).$extratag);
	}
}

class cLabel extends cTagBase {
	function cLabel($for, $name, $xid='', $xclass='', $extratag='') {
		parent::cTagBase('label', $xid, $xclass, true, false, makeattr('for',$for).$extratag, $name);
	}
}

class cInputPass extends cTagBase {
	function cInputPass($xid='', $xclass='', $name='', $value='', $extratag='') {
		parent::cTagBase('input', $xid, $xclass, true, true, ' type="password"'.makeattr('name',$name).makeattr('value',$value).$extratag);
	}
}

class cInputHidden extends cTagBase {
	function cInputHidden($xid='', $xclass='', $name='', $value='', $extratag='') {
		parent::cTagBase('input', $xid, $xclass, true, true, ' type="hidden"'.makeattr('name',$name).makeattr('value',$value).$extratag);
	}
}

class cInputFile extends cTagBase {
	function cInputFile($xid='', $xclass='', $name='', $value='', $extratag='') {
		parent::cTagBase('input', $xid, $xclass, true, true, ' type="file"'.makeattr('name',$name).makeattr('value',$value).$extratag);
	}
}

class cCheckBox extends cTagBase {
	function cCheckBox($xid='', $xclass='', $name='', $value=false, $extratag='') {
		$strchk=$value ? 'checked' : '';
		parent::cTagBase('input', $xid, $xclass, true, true, ' type="checkbox"'.makeattr('name',$name).$extratag.$strchk);
	}
}

class cRadioButton extends cTagBase {
	function cRadioButton($xid='', $xclass='', $name='', $value='', $extratag='', $selected=false) {
		$strchk=$selected ? 'checked' : '';
		parent::cTagBase('input', $xid, $xclass, true, true, ' type="radio"'.makeattr('name',$name).makeattr('value',$value).$extratag.makeattr($strchk,$strchk));
	}
}

class cSubmit extends cTagBase {
	function cSubmit($xid='', $xclass='', $name='', $value='', $extratag='') {
		parent::cTagBase('input', $xid, $xclass, true, true, ' type="submit"'.makeattr('name',$name).makeattr('value',$value).$extratag);
	}
}

class cAjaxSubmit extends cSubmit {
	function cAjaxSubmit($onclick, $xid='', $xclass='', $name='', $value='', $extratag='') {
		parent::cSubmit($xid, $xclass, $name, $value, makeattr('onclick',$onclick).$extratag);
	}
}

class cTextArea extends cTagBase {
	function cTextArea($xid='', $xclass='', $name='', $cols='', $rows='', $extratag='', $text='') {
		parent::cTagBase('textarea', $xid, $xclass, true, false ,makeattr('name',$name).makeattr('cols',$cols).makeattr('rows',$rows).$extratag, $text);
	}
}

class cOptionCombo extends cTagBase {
	function cOptionCombo($name, $value, $xid='', $xclass='', $extratag='', $selected=false) {
		$sel = $selected ? 'selected' : '';
		parent::cTagBase('option', $xid, $xclass, true, false, makeattr('value', $value).makeattr('selected', $sel).$extratag, $name);
	}
}

class cComboBox extends cTagBase {
	function cComboBox($name, $items, $xid='', $xclass='', $extratag='', $multiselect=false, $default='') {
		$mstr = $multiselect ? " multiple" : '';
		parent::cTagBase('select', $xid, $xclass, true, false, makeattr('name', $name).$mstr.$extratag, '', true);
		
		foreach ($items as $item=>$val) {
			if (is_array($default) && $multiselect) {
				$sel = false;
				foreach($default as $def)
					if ($val==$def)
						$sel = true;	
			} else
				$sel = ($val==$default) ? true : false;
			
			$this->addchild( new cOptionCombo($item, $val, '', '', '', $sel) );
 		}
	}
}

class cListBox extends cComboBox {
	function cListBox($name, $items, $xid='', $xclass='', $extratag='', $default='') {
		parent::cComboBox($name, $items, $xid, $xclass, $extratag, true, $default);
	}
}

class cAjaxForm extends cForm {
	function cAjaxForm($id, $divid, $ajax_func_name, $class='', $table_width='', $table_class='') {
		parent::cForm($id, $divid, $class, '', 'javascript:void(null);', $ajax_func_name."(xajax.getFormValues('".$id."')); return false;", $table_width, $table_class);
	}
}

class cListItem extends cTagBase {
	function cListItem($text, $xid='', $xclass='', $extratag='') {
		parent::cTagBase('li', $xid, $xclass, true, false, $extratag, $text);
	}
}

class cList extends cTagBase {
	function cList($ordered=false, $xid='', $xclass='', $style='', $extratag='') {
		$or = $orderer ? 'ol' : 'ul';
		parent::cTagBase( $or, $xid, $xclass, true, false, makeattr('style', $style).$extratag, '', true);
	}
	
	function addlistitems($obj) {
		if (is_array($obj))
			foreach ($obj as $o) {
				$this->addchild( new cListItem( $o->render() ) );
			}
		else
			$this->addchild( new cListItem( $obj->render() ) );
	}
	
	function addlistitem($text, $xid='', $xclass='', $extratag='') {
		$this->addchild( new cListItem($text, $xid, $xclass, $extratag) );
	}
}

class cParam extends cTagBase {
	function cParam($name, $value, $extratag='') {
		parent::cTagBase('param', '', '', true, true, makeattr('name',$name).makeattr('value',$value).$extratag, '', true);
	}
}

class cSwf extends cTagBase {
	protected $width;
	protected $height;
	protected $quality;
	protected $version;
	
	function cSwf($movie, $width='100%', $height='100%', $quality='high', $version='9,0,0,0' ) {
		$this->movie = $movie;
		$this->width = $width;
		$this->height = $height;
		$this->quality = $quality;
		$this->version = $version;
		
		parent::cTagBase('object', '', '', true, false, makeattr('classid', 'clsid:d27cdb6e-ae6d-11cf-96b8-444553540000').makeattr('codebase', "http://active.macromedia.com/flash7/cabs/swflash.cab#version=$this->version" ), '', true );
		
		$this->addparam('movie', $this->movie);
		$this->addparam('play', 'true');
		$this->addparam('loop', 'true');
		$this->addparam('quality', $this->quality);
	}
	
	public function addparam($name, $value) {
		$this->addchild( new cParam( $name, $value ) );
	}
	
	public function render() {
		$this->addchild( new cCustom( "<embed src='$this->movie' width='$this->width' height='$this->height' play='true' loop='true' quality='$this->quality' pluginspage='http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash'></embed>" ) );
		return parent::render();
	}
}

?>