<?php
class cRss extends cBase {
	protected $cimg = array();
	var $ctitle, $cdesc, $clink, $clang, $ccopy, $cgen;
	
	function cRss($title, $link, $description='', $language='es', $copyright='', $generator='LazyPHP') {
		parent::cBase(0,false);
		$this->ctitle = $title;
		$this->clink = $link;
		$this->cdesc = $description;
		$this->clang = $language;
		$this->ccopy = $copyright;
		$this->cgen = $generator;
	}
	
	function addimg($url, $title, $link, $width, $height) {
		$this->cimg = array('url' => $url, 'title' => $title, 'link' => $link, 'width' => $width, 'height' => $height);
	}
	
	function render($items) {
		header("Content-type: application/rss+xml");
		$this->pl('<?xml version="1.0" encoding="UTF-8"?>');
		$this->pl('<rss version="2.0" xmlns:atom="http://www.w3.org/2005/Atom" xmlns:content="http://purl.org/rss/1.0/modules/content/" xmlns:wfw="http://wellformedweb.org/CommentAPI/" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:georss="http://www.georss.org/georss">');
		$this->pl('<channel>');
		$this->pl( rsstag('title', $this->ctitle) );
		$this->pl( rsstag('description', $this->cdesc) );
		$this->pl( rsstag('link', $this->clink) );
		$this->pl( rsstag('language', $this->clang) );
		$this->pl( rsstag('copyright', $this->ccopy) );
		$this->pl( rsstag('generator', $this->cgen) );
		$this->pl('<atom:link href="http://'.$_SERVER["HTTP_HOST"].$_SERVER["REQUEST_URI"].'" rel="self" type="application/rss+xml" />');
		
		if (is_array($this->cimg) && count($this->array)==5) {
			$this->pl( '<image>' );
			$this->pl( rsstag('url', $this->cimg['url']) , 1);
			$this->pl( rsstag('title', $this->cimg['title']) , 1);
			$this->pl( rsstag('link', $this->cimg['link']) , 1);
			$this->pl( rsstag('width', $this->cimg['width']) , 1);
			$this->pl( rsstag('height', $this->cimg['height']) , 1);
			$this->pl( '</image>' );			
		}
		
		if (is_array($items)) {
			foreach ($items as $item) {
				if (is_array($item)) {
					$this->pl( '<item>' );
					foreach ($item as $n=>$v) {
						$this->pl( rsstag($n, $v) , 1);
					}
					$this->pl( '</item>' );
				}
			}
		}
		
		$this->pl('</channel>');
		$this->pl('</rss>');
		return $this->data;
	}
}
?>