<?php
class cPage {
	private static $data;
	private static $styles=array();
	private static $scripts=array();
	private static $extrahead;
	private static $cfunc;
	private static $aptitle;
	private static $basetabs=0;
	
	/* @brief Print ajax headers */
	private static function print_xajax($ajax_on_page=false) {
		global $xajax;
		
		$xajax->configure('javascript URI', CORE.XAJAX_PATH);
		self::addscript(CORE.XAJAX_PATH.'xajax_js/xajax_core.js');
		
		if ( XAJAX_DEBUG == true )
			self::addscript(CORE.XAJAX_PATH.'xajax_js/xajax_debug.js');
		
		if ($ajax_on_page)
			cPage::addheaddata($xajax->getJavascript());
		else {
			$xajax_path=PAGE."xajax.js";
			$x=$xajax->getJavascript('');
			$h=fopen($xajax_path,'w');
			$x=str_replace("<script type='text/javascript' charset='UTF-8'>"."\n",'',$x);
			$x=str_replace('<script type="text/javascript" charset="UTF-8">'."\n",'',$x);
			$x=str_replace('<script type="text/javascript">'."\n",'',$x);
			$x=str_replace('<script type="text/javascript" src="'.CORE.XAJAX_PATH.'xajax_js/xajax_core.js" charset="UTF-8">','',$x);
			$x=str_replace('<script type="text/javascript" src="'.CORE.XAJAX_PATH.'xajax_js/xajax.js">'."\n",'',$x);
			$x=str_replace('</script>'."\n",'',$x);
			$x=str_replace("/* <![CDATA[ */\n",'',$x);
			$x=str_replace("/* ]]> */\n",'',$x);
			$x=str_replace('\n','',$x);
			fwrite( $h, $x );
			self::addscript($xajax_path);
		}
	}
	
	/* @brief Register an ajax function from some object. This is automatic if the object inherits cBase. */
	static function reg_func(&$obj, $name) {
		global $xajax;
		
		$xajax->register(XAJAX_FUNCTION, array($name, $obj, $name));
		self::$cfunc++;
	}
	
	/* @brief Process ajax request and print ajax headers */
	static function process_ajax($ajax_on_page=false) {
		global $xajax;
		if (self::$cfunc>0 && is_object($xajax)) {
			$xajax->processRequest();
			self::print_xajax($ajax_on_page);
		}
	}
	
	/* @brief Print the body content */
	static function print_data() {
		echo self::$data;
	}
	
	/* @brief Append some extra data on the body
	 * @param string $newdata The data to append
	 * */
	static function adddata($newdata) {
		self::$data.=$newdata;
	}
	
	/* @brief Append some extra data on the header
	 * @param string $newdata The data to append
	 * */
	static function addheaddata($newdata) {
		self::$extrahead.=$newdata;
	}
	
	/* @brief Add CSS file to the page header */
	static function addcss($css) {
		self::$styles[]=$css;
	}
	
	/* @brief Add JavaScript file to the page header */
	static function addscript($script) {
		self::$scripts[]=$script;
	}
	
	/* @brief Abbr of print_page, for lazy programmers =) */
	static function pp($print_ajax_on_page=false) {
		self::print_page($print_ajax_on_page);
	}
	
	/* @brief Print the Page and Process Ajax
	 * @param bool $print_ajax_on_page If false print ajax headers on a file, xajax.js.
	 * */
	static function print_page($print_ajax_on_page=false) {
		self::process_ajax($print_ajax_on_page);
		self::page_render();
	}
	
	/* @brief Print the page
	 * @param bool $br Print a line break at end?
	 * */
	static function page_render($br=false) {
		$tpl = new Template(PAGE);
		
		foreach(self::$styles as $css)
			$thiscss.="\t<link href=\"$css\" type=\"text/css\"  rel=\"stylesheet\" />\n";
		
		foreach(self::$scripts as $script)
			$thisscr.="\t<script type=\"text/javascript\" src=\"$script\"></script>\n";
		
		$tpl->set('css', $thiscss);
		$tpl->set('scr', $thisscr);
		$tpl->set('ext', self::$extrahead);
		$tpl->set('br', $br);
		$tpl->set('aptitle', self::$aptitle);
		self::addbasetabs();
		$tpl->set('body', self::$data);
		echo $tpl->fetch("xhtml.tpl.php");
	}
	
	/* @brief Add a base number of tabs to all lines */
	private static function addbasetabs() {
		if (self::$data!="" && self::$basetabs>0) {
			$ret='';
			$tabs = repeatstr("\t", self::$basetabs);
			
			$str = explode("\n", self::$data);
			foreach($str as $line)
				$ret.= $tabs.$line."\n";
			
			self::$data = $ret;
		}
	}
	
	/* @brief Append text to the title.
	 * @param string $text text to append
	 * @param string $addsep default separator between PAGE_TITLE and the text appended
	 * */
	static function appendtitle($text, $addsep = ' - ') {
		self::$aptitle.= $addsep.$text;	
	}
	
	/* @brief Set the number of base tabs
	 * @param int $tabs
	 * */
	static function tabs_set($tabs) {
		self::$basetabs = $tabs;
	}
	
	/* @brief Get the number of base tabs */
	static function tabs_get() {
		return self::$basetabs;
	}
}