<?php
class cForm extends cTagBase {
	private $xfid;
	private $xtable;
	private $xhidden;
	private $tdl, $tdm, $tdr, $rc;
	
	function cForm($id, $divid, $class='', $method='post', $action='', $onsubmit='', $table_width='', $table_class='', $extratag='') {
		parent::cTagBase('','','',false,true);
		$this->xfid = $id;
		$this->printl("<div".makeattr('id',$divid)."><form".makeattr('id',$id)." action='".$action."'".makeattr('class',$class).makeattr('method',$method).makeattr('onsubmit',$onsubmit).$extratag.'>');
		$this->xtable = new cTable($id."_table", $table_class, $table_width);
	}
	
	function render() {
		$this->printl( $this->xtable->render() );
		$this->printl( $this->xhidden );
		$this->printl("</form></div>");
		return parent::render();
	}
	
	private function add_field($text, $id='', $class='', $span='', $width='', $extratag='', $tabs=1) {
		switch ($this->rc) {
			case 0: $width = $this->tdl; break;
			case 1: $width = $this->tdm; break;
			case 2: $width = $this->tdr; break;
		}
		$this->rc++;
		$this->xtable->addfield($text, $id, $class, $span, $width, $extratag, $tabs);
	}
	
	private function makelabel($for, $name) {
		$this->xtable->addrow();
		$l = new cLabel($for, $name);
		$this->add_field( $l->render() );
	}
	
	private function makestate($name, $spanclass='') {
		$s = new cSpan('', $this->xfid.'_'.$name.'_state', $spanclass);
		$this->add_field( $s->render() );
	}
	
	# private ?
	function addinput($name, $label, $id='', $class='', $type='text', $value='', $extratag='', $spanclass='') {
		$this->makelabel($name, $label);
		
		if ($id=='') $id = $name;
		
		switch($type) {
			case 'password':
				$tcls = new cInputPass($id, $class, $name, $value, $extratag); break;
			case 'file':
				$tcls = new cInputFile($id, $class, $name, $value, $extratag); break;
			case 'hidden':
				$tcls = new cInputHidden($id, $class, $name, $value, $extratag);
				$this->xhidden.=$tcls->render(); break;
			case 'text':
			default:
				$tcls = new cInput($id, $class, $name, $value, $extratag);
		}
		
		if ($type!='hidden') {
			$this->add_field( $tcls->render() );
			$this->makestate($name, $spanclass);
		}
	}
	
	function addtextbox($name, $label, $id='', $class='', $value='', $extratag='', $spanclass='') {
		$this->addinput($name, $label, $id, $class, 'text', $value, $extratag, $spanclass);
	}
	
	function addhidden($name, $value='', $id='', $class='', $extratag='') {
		$this->addinput($name, '', $id, $class, 'hidden', $value, $extratag);
	}
	
	function addpass($name, $label, $id='', $class='', $value='', $extratag='', $spanclass='') {
		$this->addinput($name, $label, $id, $class, 'password', $value, $extratag, $spanclass);
	}
	
	function addfilebox($name, $label, $id='', $class='', $value='', $extratag='', $spanclass='') {
		$this->addinput($name, $label, $id, $class, 'file', $value, $extratag, $spanclass);
	}
	
	function addcombobox($name, $label, $items, $id='', $class='', $extratag='', $default='') {
		$this->makelabel($name, $label);
		
		if ($id=='') $id = $name;
		$tcls = new cComboBox($name, $items, $id, $class, $extratag, false, $default);
		
		$this->add_field( $tcls->render() );
		$this->makestate($name, $spanclass);
	}
	
	function addlistbox($name, $label, $items, $id='', $class='', $extratag='', $default='') {
		$this->makelabel($name, $label);
		
		if ($id=='') $id = $name;
		$tcls = new cListBox($name, $items, $id, $class, $extratag, $default);
		
		$this->add_field( $tcls->render() );
		$this->makestate($name, $spanclass);
	}
	
	function addtextarea($name, $label, $id='', $class='', $cols=20, $rows=4, $value='', $extratag='', $spanclass='') {
		$this->makelabel($name, $label);
		
		if ($id=='') $id = $name;
		$tcls = new cTextArea($id, $class, $name, $cols, $rows, $extratag, $value);
		
		$this->add_field( $tcls->render() , '', '', '', '', '', 0 );
		$this->makestate($name, $spanclass);
	}
	
	function addbutton($name='enviar', $value='Enviar', $id='', $class='', $extratag='', $tdalign='center', $onclick='') {
		$this->xtable->addrow();
		if ($id=='') $id = $name;
		if ($onclick!='')
			$tcls = new cAjaxSubmit($onclick, $id, $class, $name, $value, $extratag);
		else
			$tcls = new cSubmit($id, $class, $name, $value, $extratag);
		$this->add_field($tcls->render(), '', '', 3, '', makeattr('align',$tdalign) );
	}
		
	# Tendría que poder agregar varios checkbox por row...
	function addcheck($name, $id='', $class='', $value=false, $extratag='', $spanclass='', $text='') {
		$this->makelabel($name, $label);
		
		if ($id=='') $id = $name;
		$tcls = new cCheckBox($id, $class, $name, $value, $extratag);
		
		$this->add_field( $tcls->render().$text );
		$this->makestate($name, $spanclass);
	}
	
	function addseparator($text='', $class=''){
    	$this->xtable->addrow('','separator');
    	$this->add_field($text, '', $class, 3);
	}
	
	function addcustom($name, $label, $custom, $spanclass='') {
		$this->makelabel($name, $label);
		
		$this->add_field( $custom );
		
		$this->makestate($name, $spanclass);
	}
	
	function set_tds_width($td_left='', $td_middle='', $td_right='') {
		$this->tdl = $td_left;
		$this->tdm = $td_middle;
		$this->tdr = $td_right;
	}
}
?>