<?php
class cBase {
	var $data;
	var $tabs;
	
	function cBase($tabinit, $create_ajax=true) {
		$this->tabs=$tabinit;
		if ($create_ajax)
			$this->create_ajax();
	}
	
	/* @brief Search for suffix ajax_ on class functions and register it */
	private function create_ajax() {
		$class_methods = get_class_methods($this);
		
		foreach ($class_methods as $f) {
			if (substr($f,0,5)=='ajax_')
				cPage::reg_func($this, $f);
		}
	}
	
	/* @brief Abbr of printl. For lazy programmers =) */
	function pl($str,$tabs=-1) { $this->printl($str,$tabs); }
	
	/* @brief Append data string, put tabs at beggining and breakline at end.
	 * @param string $str Data to append
	 * @param int $tabs Tabs to put before the new data.
	 * */
	function printl($str,$tabs=-1) {
		if ($tabs==-1) $tabs=$this->tabs;
		if ($str!='')
			$this->data.=RepeatStr("\t",$tabs).$str."\n";
	}
	
	/* @brief Append data string, explode the lines and put tabs on each one.
	 * @param string $str Data to append
	 * @param bool $br Print a line break at end?
	 * */
	function printlines($str,$br=false) {
		$arr=explode("\n",$str);
		foreach($arr as $s) {
			$this->data.=repeatstr("\t",$this->tabs).$s."\n";
			$this->data.= $br ? "<br/>" : "";
		}
	}
	
	function printdata( $str ) {
		$this->data.= $str;
	}
	
	function pd( $str ) {
		$this->printdata( $str );
	}
}
?>