<?php
function bb2html ($str) {
	// Replace any html brackets with HTML Entities to prevent executing HTML or script
	// Don't use strip_tags here because it breaks [url] search by replacing & with amp
	$str = texttohtml($str);
	
	// Activate this to block html code
	if (!ALLOW_HTML) {
		$str = str_replace("<", "&lt;", $str);
		$str = str_replace(">", "&gt;", $str);
	}
	
	// Convert new line chars to html <br /> tags
	$str = str_nl2br($str);
	
	// Set up the parameters for a URL search string
	$URLSearchString = " a-zA-Z0-9\:\/\-\?\&\.\=\_\~\#\'";
	// Set up the parameters for a MAIL search string
	$MAILSearchString = $URLSearchString . " a-zA-Z0-9\.@";
	
	// Perform URL Search
	$str = preg_replace("/\[url\]([$URLSearchString]*)\[\/url\]/", '<a href="$1">$1</a>', $str);
	$str = preg_replace("(\[url\=([$URLSearchString]*)\](.+?)\[/url\])", '<a href="$1">$2</a>', $str);
	
	// Perform MAIL Search
	$str = preg_replace("(\[mail\]([$MAILSearchString]*)\[/mail\])", '<a href="mailto:$1">$1</a>', $str);
	$str = preg_replace("/\[mail\=([$MAILSearchString]*)\](.+?)\[\/mail\]/", '<a href="mailto:$1">$2</a>', $str);
	
	// Check for bold text
	$str = preg_replace("(\[b\](.+?)\[\/b])is",'<span class="bold">$1</span>', $str);
	
	// Check for Italics text
	$str = preg_replace("(\[i\](.+?)\[\/i\])is",'<span class="italics">$1</span>', $str);
	
	// Check for Underline text
	$str = preg_replace("(\[u\](.+?)\[\/u\])is",'<span class="underline">$1</span>', $str);
	
	// Check for strike-through text
	$str = preg_replace("(\[s\](.+?)\[\/s\])is",'<span class="strikethrough">$1</span>', $str);
	
	// Check for over-line text
	$str = preg_replace("(\[o\](.+?)\[\/o\])is",'<span class="overline">$1</span>', $str);
	
	// Check for center text
	$str = preg_replace("(\[center\](.+?)\[\/center\])is",'<div style="center">$1</div>', $str);
	
	// Check for align text
	$str = preg_replace("/\[align\=([(center|right|left)]*)\](.+?)\[\/align\]/", '<div style="text-align: $1;">$2</div>', $str);
	
	// Check for colored text
	$str = preg_replace("(\[color=(.+?)\](.+?)\[\/color\])is","<span style=\"color: $1\">$2</span>", $str);
	
	// Check for sized text
	$str = preg_replace("(\[size=(.+?)\](.+?)\[\/size\])is","<span style=\"font-size: $1px\">$2</span>", $str);
	
	// Check for list text
	$str = preg_replace("/\[list\](.+?)\[\/list\]/is", '<ul class="listbullet">$1</ul>' , $str);
	$str = preg_replace("/\[list=1\](.+?)\[\/list\]/is", '<ul class="listdecimal">$1</ul>' , $str);
	$str = preg_replace("/\[list=i\](.+?)\[\/list\]/s", '<ul class="listlowerroman">$1</ul>' , $str);
	$str = preg_replace("/\[list=I\](.+?)\[\/list\]/s", '<ul class="listupperroman">$1</ul>' , $str);
	$str = preg_replace("/\[list=a\](.+?)\[\/list\]/s", '<ul class="listloweralpha">$1</ul>' , $str);
	$str = preg_replace("/\[list=A\](.+?)\[\/list\]/s", '<ul class="listupperalpha">$1</ul>' , $str);
	$str = str_replace("[*]", "<li>", $str);
	
	// Check for font change text
	$str = preg_replace("(\[font=(.+?)\](.+?)\[\/font\])","<span style=\"font-family: $1;\">$2</span>", $str);
	
	// Declare the format for [code] layout
	$CodeLayout = '<table class="bbtable"><tr><td class="quotecodeheader"> Code:</td></tr><tr><td class="codebody">$1</td></tr></table>';
	
	// Check for [code] text
	$str = preg_replace("/\[code\](.+?)\[\/code\]/is","$CodeLayout", $str);
	
	// Declare the format for [quote] layout
	$QuoteLayout = '<table class="bbtable"><tr><td class="quotecodeheader"> Quote:</td></tr><tr><td class="quotebody">$1</td></tr></table>';
	
	// Check for [code] text
	$str = preg_replace("/\[quote\](.+?)\[\/quote\]/is","$QuoteLayout", $str);
	
	// Images
	// [img]pathtoimage[/img]
	$str = preg_replace("/\[img\](.+?)\[\/img\]/", '<img src="$1" alt="$1" />', $str);
	
	// [img=widthxheight]image source[/img]
	$str = preg_replace("/\[img\=([0-9]*)x([0-9]*)\](.+?)\[\/img\]/", '<img src="$3"  alt="$3" width="$1" height="$2" />', $str);
	
	return $str;
}
?>