<?php
class cAdminUser extends cBase {
	function cAdminUser($tabinit=0) {
		parent::cBase($tabinit);
	}
	
	function ajax_user_add() {
		$objResponse = new xajaxResponse();
		
		$frm = new cAjaxForm('frmUserAdd', 'divUserAdd', 'ajax_user_insert');
		$frm->addtextbox('fbid', 'Facebook Id:');
		$frm->addtextbox('name', 'Name:');
		$frm->addbutton();
		
		$objResponse->assign('ainfo', 'innerHTML', '<h3>Add User</h3>');
		$objResponse->assign('acontent', 'innerHTML', $frm->render() );
		
		return $objResponse;
	}
	
	function ajax_user_insert($form) {
		$objResponse = new xajaxResponse();
		
		$fields = array( 'fbid' => 'any-req', 'name' => 'any-req' );
		$err = validatefields($objResponse, $form, 'frmUserAdd', $fields );
		
		if (!$err) {
			$val = $this->user_add( $form['fbid'], $form['name'] );
			
			switch ( $val ) {
				case 1:
					$msg = ERROR_DB.' '.$fbid.', '.$name.'. '.$db->last_error;
					break;
				case 2:
					$msg = 'User already exists.';
					break;
				case 3:
					$msg = 'Invalid Session';
				case 0:
				default:
					$msg = obj_render( new cSpan('User '.$form['fbid'].' '.$form['name'].' Added', '', 'bold') );;
			}
			
			$objResponse->assign('acontent', 'innerHTML', $msg );
		}
		
		return $objResponse;
	}
	
	function ajax_user_edit( $uid ) {
		$objResponse = new xajaxResponse();
		global $db;
		
		$row = $db->get_row("CALL moUserGetById( $uid )" );
		if ( isset($row) ) {
			$frm = new cAjaxForm('frmUserEdit', 'divUserEdit', 'ajax_user_update');
			$frm->addtextbox('name', 'Nombre:', '', '', $row->user_name);
			$frm->addhidden('uid', $uid);
			$frm->addbutton('enviar', 'Editar');
			$objResponse->assign('acontent', 'innerHTML', $frm->render() );
		}
		
		$objResponse->assign('ainfo', 'innerHTML', '<h3>Edit User</h3>');
		
		return $objResponse;
	}
	
	function ajax_user_update( $form ) {
		$objResponse = new xajaxResponse();
		
		if ( $this->user_edit( $form['uid'], $form['name'] ) )
			$msg = "User edited";
		else
			$msg = "Error editing user.";
		
		$objResponse->assign('acontent', 'innerHTML', $msg );
		
		return $objResponse;
	}
	
	function ajax_user_list() {
		$objResponse = new xajaxResponse();
		$objResponse->assign('acontent', 'innerHTML', $this->user_list() );
		return $objResponse;
	}
	
	function ajax_user_delete( $uid ) {
		$objResponse = new xajaxResponse();
		global $db;
		
		if ( $this->user_delete( $uid ) )
			$msg = "User deleted";
		else
			$msg = 'Error deleting user.';
		
		$objResponse->assign('acontent', 'innerHTML', $msg );
		
		return $objResponse;
	}
	
	function user_add($fbid, $name) {
		global $db;
		
		$db->query( "SELECT moUserExists(".$fbid.")" );
		
		if ( 0 == $db->get_var() ) {
			$db->query("CALL moUserAdd(".$fbid.", '".$db->escape($name)."');");
			
			return !$db->last_error ? 0 : 1;
		} else
			return 2;
	}
	
	function user_edit( $uid, $newname ) {
		if ( !secure(1) ) return false;
		
		global $db;
		
		$db->query( "CALL moUserEdit( '".$uid."', '".$db->escape($newname)."' )" );
		
		return $db->last_result == null;
	}
	
	function user_list() {
		if ( !secure(1) ) return '';
		
		global $db;
		$tb = new cTable('atable');
		
		$tb->addrow();
		
		$tb->addheader('Id','','','40');
		$tb->addheader('Facebook Id','','','200');
		$tb->addheader('Name','','','300');
		$tb->addheader('Edit','','','60');
		$tb->addheader('Erase','','','60');
		
		$res = $db->get_results("SELECT * FROM user ORDER BY user_uid ASC");
		if ( $db->num_rows>0 ) {
			foreach ( $res as $row ) {
				$tb->addrow();
				
				$tb->addfield($row->user_uid);
				$tb->addfield($row->user_fbid);
				$tb->addfield($row->user_name);
				
				$ed = new cAjaxLink('ajax_user_edit('.$row->user_uid.');');
				$img = new cImg(IMG.'b_edit.png','','','edit');
				$ed->addchild( $img );
				$tb->addfield( $ed->render() );
				
				$lk = new cAjaxLink('ajax_user_delete('.$row->user_uid.');');
				$img = new cImg(IMG.'b_drop.png','','','delete');
				$lk->addchild( $img );
				
				$tb->addfield( $lk->render() );
			}
		}
		
		return $tb->render();
	}
	
	function user_delete( $uid ) {
		if ( !secure(1) ) return false;
		
		global $db;
		
		$db->query( 'CALL moUserDelete( '.$uid.' )' );
		
		return $db->last_result == null;
	}
	
	function user_submit_score( $fbid, $game, $score ) {
		global $db;
		$sql = 'CALL moHighScoreSubmit('.$game.', '.$fbid.', '.$score.')';
		$db->query( $sql );
	}
}
?>