/*//////////////////////////////////////////////////////////////////////////////////////////////////////////

  FIVe3D v2.0  -  2008-04-14
  Flash Interactive Vector-based 3D
  Mathieu Badimon  |  five3d.mathieu-badimon.com  |  www.mathieu-badimon.com  |  contact@mathieu-badimon.com

/*//////////////////////////////////////////////////////////////////////////////////////////////////////////

package org.papervision3d.typography.fonts {
	import org.papervision3d.typography.Font3D;		

	public class HelveticaMedium extends Font3D{

		static public var __motifs:Object = {};
		static public var __widths:Object = {};
		static public var __height:Number = 117;
		static public var __initialized:Boolean = false;

		static public function initialize():void {
			initializeMotifsUppercase();
			initializeMotifsLowercase();
			initializeMotifsNumbers();
			initializeMotifsPunctuation();
			initializeWidthsUppercase();
			initializeWidthsLowercase();
			initializeWidthsNumbers();
			initializeWidthsPunctuation();
			__initialized = true;
		}
		
		////////////////////////////////////////////
		override public function get motifs():Object
		{
			if(!__initialized)initialize();
			return __motifs;
		}

		override public function get widths():Object
		{
			if(!__initialized)initialize();
			return __widths;
		}
		
		override public function get height():Number
		{ 
			if(!__initialized)initialize();
			return __height;
		}
		////////////////////////////////////////////

		static private function initializeMotifsUppercase():void {
			__motifs["A"] = [['M',[26.7,23.8]],['L',[-0.7,95.2]],['L',[12.2,95.2]],['L',[18.95,76.3]],['L',[47.4,76.3]],['L',[54.1,95.2]],['L',[67.55,95.2]],['L',[40.05,23.8]],['L',[26.7,23.8]],['M',[33.45,36.1]],['L',[44.15,66.8]],['L',[22.3,66.8]],['L',[33.1,36.1]],['L',[33.45,36.1]]];
			__motifs["B"] = [['M',[51,43.8]],['C',[50.9,48.6,48,51.15]],['C',[45.05,53.7,40.5,53.7]],['L',[20.1,53.7]],['L',[20.1,34]],['L',[40.5,34]],['C',[45.6,33.95,48.3,36.2]],['C',[51,38.45,51,43.8]],['M',[42.3,23.8]],['L',[7.6,23.8]],['L',[7.6,95.2]],['L',[40.45,95.2]],['C',[49.6,95.15,55.4,92.5]],['C',[61.3,89.95,64,85.45]],['C',[66.7,80.95,66.7,75.3]],['C',[66.65,67.95,63.3,63.15]],['C',[59.85,58.4,53.3,56.85]],['L',[53.3,56.65]],['C',[58.2,54.6,60.85,50.75]],['C',[63.45,46.9,63.5,41.5]],['C',[63.45,35.6,60.85,31.65]],['C',[58.2,27.7,53.45,25.75]],['C',[48.75,23.8,42.3,23.8]],['M',[20.1,62.7]],['L',[42.2,62.7]],['C',[47.95,62.75,51.05,65.55]],['C',[54.15,68.4,54.2,73.65]],['C',[54.15,79.15,51.05,82.05]],['C',[47.95,84.95,42.2,85]],['L',[20.1,85]],['L',[20.1,62.7]]];
			__motifs["C"] = [['M',[68.3,46.5]],['C',[67.5,38.8,63.4,33.35]],['C',[59.25,27.9,52.7,25.05]],['C',[46.15,22.2,38,22.1]],['C',[30,22.15,23.65,25.1]],['C',[17.3,28,12.9,33.15]],['C',[8.45,38.3,6.15,45.05]],['C',[3.8,51.8,3.8,59.5]],['C',[3.8,67.2,6.15,73.95]],['C',[8.45,80.7,12.9,85.85]],['C',[17.3,91,23.65,93.95]],['C',[30,96.85,38,96.9]],['C',[46.75,96.85,53.35,93.2]],['C',[60,89.6,63.9,83.1]],['C',[67.85,76.6,68.4,68]],['L',[56.2,68]],['C',[55.7,73.3,53.5,77.5]],['C',[51.3,81.65,47.4,84.15]],['C',[43.55,86.65,38,86.7]],['C',[32.3,86.65,28.15,84.35]],['C',[24,82.1,21.45,78.25]],['C',[18.8,74.4,17.55,69.5]],['C',[16.3,64.7,16.3,59.5]],['C',[16.3,54.35,17.55,49.5]],['C',[18.8,44.6,21.45,40.75]],['C',[24,36.9,28.15,34.65]],['C',[32.3,32.35,38,32.3]],['C',[45.75,32.4,50,36.3]],['C',[54.3,40.2,55.8,46.5]],['L',[68.3,46.5]]];
			__motifs["D"] = [['M',[55.15,28.7]],['C',[48.2,23.9,37.2,23.8]],['L',[7.6,23.8]],['L',[7.6,95.2]],['L',[37.2,95.2]],['C',[48.2,95.1,55.15,90.3]],['C',[62.1,85.6,65.45,77.5]],['C',[68.75,69.45,68.7,59.5]],['C',[68.75,49.55,65.45,41.5]],['C',[62.1,33.45,55.15,28.7]],['M',[54.4,46.55]],['C',[56.3,52.3,56.2,59.5]],['C',[56.3,66.75,54.4,72.45]],['C',[52.5,78.2,47.25,81.6]],['C',[42.1,84.95,32.4,85]],['L',[20.1,85]],['L',[20.1,34]],['L',[32.4,34]],['C',[42.1,34.05,47.25,37.45]],['C',[52.5,40.8,54.4,46.55]]];
			__motifs["E"] = [['M',[59.05,23.8]],['L',[7.6,23.8]],['L',[7.6,95.2]],['L',[59.7,95.2]],['L',[59.7,84.4]],['L',[20.1,84.4]],['L',[20.1,63.5]],['L',[56.1,63.5]],['L',[56.1,53.3]],['L',[20.1,53.3]],['L',[20.1,34.6]],['L',[59.05,34.6]],['L',[59.05,23.8]]];
			__motifs["F"] = [['M',[56.95,23.8]],['L',[7.6,23.8]],['L',[7.6,95.2]],['L',[20.1,95.2]],['L',[20.1,63.5]],['L',[52.4,63.5]],['L',[52.4,53.3]],['L',[20.1,53.3]],['L',[20.1,34.6]],['L',[56.95,34.6]],['L',[56.95,23.8]]];
			__motifs["G"] = [['M',[52.95,24.85]],['C',[46.4,22.1,38.5,22.1]],['C',[30.45,22.15,24.1,25.1]],['C',[17.75,28,13.4,33.15]],['C',[8.95,38.3,6.65,45.05]],['C',[4.3,51.8,4.3,59.5]],['C',[4.3,67.2,6.65,73.95]],['C',[8.95,80.7,13.4,85.85]],['C',[17.75,91,24.1,93.95]],['C',[30.45,96.85,38.5,96.9]],['C',[44.9,97,50,94.7]],['C',[55.1,92.4,60,86.8]],['L',[61.9,95.2]],['L',[69.85,95.2]],['L',[69.85,57.6]],['L',[39.5,57.6]],['L',[39.5,67.1]],['L',[58.5,67.1]],['C',[58.3,76.3,53.2,81.55]],['C',[48.15,86.75,38.5,86.7]],['C',[32.75,86.65,28.65,84.35]],['C',[24.5,82.1,21.9,78.25]],['C',[19.3,74.4,18,69.55]],['C',[16.8,64.7,16.8,59.5]],['C',[16.8,54.35,18,49.5]],['C',[19.3,44.6,21.9,40.75]],['C',[24.5,36.9,28.65,34.65]],['C',[32.75,32.35,38.5,32.3]],['C',[43.05,32.3,47,33.9]],['C',[50.95,35.5,53.6,38.65]],['C',[56.25,41.8,56.9,46.5]],['L',[69.1,46.5]],['C',[68.05,38.45,63.75,33.05]],['C',[59.45,27.6,52.95,24.85]]];
			__motifs["H"] = [['M',[52.3,23.8]],['L',[52.3,52.2]],['L',[19.8,52.2]],['L',[19.8,23.8]],['L',[7.3,23.8]],['L',[7.3,95.2]],['L',[19.8,95.2]],['L',[19.8,62.95]],['L',[52.3,62.95]],['L',[52.3,95.2]],['L',[64.8,95.2]],['L',[64.8,23.8]],['L',[52.3,23.8]]];
			__motifs["I"] = [['M',[7.6,23.8]],['L',[7.6,95.2]],['L',[20.1,95.2]],['L',[20.1,23.8]],['L',[7.6,23.8]]];
			__motifs["J"] = [['M',[13.8,70.2]],['L',[1.3,70.2]],['L',[1.3,74]],['C',[1.3,80.55,3.45,85.75]],['C',[5.65,90.85,10.4,93.9]],['C',[15.1,96.85,22.6,96.9]],['C',[30.2,96.85,34.9,94.8]],['C',[39.6,92.7,42.05,89.2]],['C',[44.45,85.7,45.3,81.3]],['C',[46.15,76.9,46.1,72.2]],['L',[46.1,23.8]],['L',[33.6,23.8]],['L',[33.6,72.9]],['C',[33.65,77.4,32.8,80.45]],['C',[32,83.55,29.8,85.1]],['C',[27.65,86.7,23.6,86.7]],['C',[18,86.65,15.85,83.35]],['C',[13.7,80,13.8,73.9]],['L',[13.8,70.2]]];
			__motifs["K"] = [['M',[51.9,23.8]],['L',[20.1,56.3]],['L',[20.1,23.8]],['L',[7.6,23.8]],['L',[7.6,95.2]],['L',[20.1,95.2]],['L',[20.1,71.2]],['L',[30.3,61.05]],['L',[53.7,95.2]],['L',[69.35,95.2]],['L',[38.8,52.3]],['L',[67.35,23.8]],['L',[51.9,23.8]]];
			__motifs["L"] = [['M',[7.6,23.8]],['L',[7.6,95.2]],['L',[56.4,95.2]],['L',[56.4,84.4]],['L',[20.1,84.4]],['L',[20.1,23.8]],['L',[7.6,23.8]]];
			__motifs["M"] = [['M',[81.5,23.8]],['L',[64.05,23.8]],['L',[44.85,79.7]],['L',[44.7,79.7]],['L',[25,23.8]],['L',[7.35,23.8]],['L',[7.35,95.2]],['L',[19.3,95.2]],['L',[19.3,40.1]],['L',[19.5,40.1]],['L',[39.3,95.2]],['L',[49.55,95.2]],['L',[69.4,40.1]],['L',[69.6,40.1]],['L',[69.6,95.2]],['L',[81.5,95.2]],['L',[81.5,23.8]]];
			__motifs["N"] = [['M',[53.1,23.8]],['L',[53.1,76.4]],['L',[52.9,76.4]],['L',[20.25,23.8]],['L',[7.1,23.8]],['L',[7.1,95.2]],['L',[19,95.2]],['L',[19,42.7]],['L',[19.3,42.7]],['L',[51.8,95.2]],['L',[65,95.2]],['L',[65,23.8]],['L',[53.1,23.8]]];
			__motifs["O"] = [['M',[54.6,40.75]],['C',[57.25,44.6,58.5,49.5]],['C',[59.7,54.35,59.7,59.5]],['C',[59.7,64.7,58.5,69.5]],['C',[57.25,74.4,54.6,78.25]],['C',[52,82.1,47.85,84.35]],['C',[43.75,86.65,38.05,86.7]],['C',[32.3,86.65,28.15,84.35]],['C',[24,82.1,21.45,78.25]],['C',[18.8,74.4,17.55,69.5]],['C',[16.3,64.7,16.3,59.5]],['C',[16.3,54.35,17.55,49.5]],['C',[18.8,44.6,21.45,40.75]],['C',[24,36.9,28.15,34.65]],['C',[32.3,32.35,38.05,32.3]],['C',[43.75,32.35,47.85,34.65]],['C',[52,36.9,54.6,40.75]],['M',[52.4,25.1]],['C',[46.05,22.15,38.05,22.1]],['C',[30,22.15,23.65,25.1]],['C',[17.3,28,12.9,33.15]],['C',[8.45,38.3,6.15,45.05]],['C',[3.8,51.8,3.8,59.5]],['C',[3.8,67.2,6.15,73.95]],['C',[8.45,80.7,12.9,85.85]],['C',[17.3,91,23.65,93.95]],['C',[30,96.85,38.05,96.9]],['C',[46.05,96.85,52.4,93.95]],['C',[58.75,91,63.15,85.85]],['C',[67.6,80.7,69.85,73.95]],['C',[72.2,67.2,72.2,59.5]],['C',[72.2,51.8,69.85,45.05]],['C',[67.6,38.3,63.15,33.15]],['C',[58.75,28,52.4,25.1]]];
			__motifs["P"] = [['M',[51.45,26]],['C',[46.7,23.85,39.1,23.8]],['L',[7.6,23.8]],['L',[7.6,95.2]],['L',[20.1,95.2]],['L',[20.1,67.9]],['L',[39.1,67.9]],['C',[46.7,67.85,51.45,65.75]],['C',[56.3,63.65,58.9,60.3]],['C',[61.45,56.9,62.45,53.1]],['C',[63.45,49.35,63.4,46]],['C',[63.45,42.55,62.45,38.75]],['C',[61.45,34.9,58.9,31.55]],['C',[56.3,28.15,51.45,26]],['M',[50.9,45.85]],['C',[50.85,50.35,48.9,52.95]],['C',[46.95,55.55,44.15,56.65]],['C',[41.25,57.75,38.4,57.7]],['L',[20.1,57.7]],['L',[20.1,34]],['L',[38.55,34]],['C',[41.95,33.95,44.75,35]],['C',[47.5,36,49.15,38.6]],['C',[50.85,41.2,50.9,45.85]]];
			__motifs["Q"] = [['M',[52.4,25.1]],['C',[46.05,22.15,38.05,22.1]],['C',[30,22.15,23.65,25.1]],['C',[17.3,28,12.9,33.15]],['C',[8.45,38.3,6.15,45.05]],['C',[3.8,51.8,3.8,59.5]],['C',[3.8,67.2,6.15,73.95]],['C',[8.45,80.7,12.9,85.85]],['C',[17.3,91,23.65,93.95]],['C',[30,96.85,38.05,96.9]],['C',[42.25,96.9,46.55,95.9]],['C',[50.85,94.85,54.85,92.6]],['L',[65.25,101.7]],['L',[71.35,94.9]],['L',[62.1,86.9]],['C',[65.65,83.5,67.85,78.95]],['C',[70.1,74.45,71.2,69.45]],['C',[72.2,64.45,72.2,59.5]],['C',[72.2,51.8,69.85,45.05]],['C',[67.6,38.3,63.15,33.15]],['C',[58.75,28,52.4,25.1]],['M',[54.6,40.75]],['C',[57.25,44.6,58.5,49.5]],['C',[59.7,54.35,59.7,59.5]],['C',[59.75,65,58.3,70.15]],['C',[56.85,75.3,53.5,79.45]],['L',[44.8,71.8]],['L',[38.8,78.7]],['L',[46,85]],['C',[44.15,85.9,42.05,86.3]],['L',[38.05,86.7]],['C',[32.3,86.65,28.15,84.35]],['C',[24,82.1,21.45,78.25]],['C',[18.8,74.4,17.55,69.5]],['C',[16.3,64.7,16.3,59.5]],['C',[16.3,54.35,17.55,49.5]],['C',[18.8,44.6,21.45,40.75]],['C',[24,36.9,28.15,34.65]],['C',[32.3,32.35,38.05,32.3]],['C',[43.75,32.35,47.85,34.65]],['C',[52,36.9,54.6,40.75]]];
			__motifs["R"] = [['M',[41.7,23.8]],['L',[7.6,23.8]],['L',[7.6,95.2]],['L',[20.1,95.2]],['L',[20.1,65.8]],['L',[38.5,65.8]],['C',[44.2,65.8,47.3,67.8]],['C',[50.45,69.8,51.6,73.95]],['C',[52.8,78.15,52.75,84.7]],['C',[52.7,87.35,53,90.05]],['C',[53.25,92.85,54.65,95.2]],['L',[68,95.2]],['C',[66.65,93.7,65.8,90.85]],['C',[64.95,88.05,64.5,84.3]],['C',[64.1,80.6,64.1,76.4]],['C',[64,70.8,62.3,67.6]],['C',[60.6,64.4,58.2,62.95]],['C',[55.75,61.55,53.5,61.3]],['L',[53.5,61.1]],['L',[56.3,59.85]],['C',[58.2,58.9,60.25,56.9]],['C',[62.3,54.95,63.75,51.6]],['C',[65.25,48.25,65.3,43.1]],['C',[65.3,33.95,59.35,28.95]],['C',[53.4,23.9,41.7,23.8]],['M',[52.8,44.9]],['C',[52.8,50.5,49.65,53.4]],['C',[46.55,56.3,40.6,56.3]],['L',[20.1,56.3]],['L',[20.1,34]],['L',[40.45,34]],['C',[43.7,33.95,46.5,34.8]],['C',[49.3,35.7,51.05,38]],['C',[52.75,40.4,52.8,44.9]]];
			__motifs["S"] = [['M',[45.85,24.7]],['C',[39.65,22.1,32.15,22.1]],['C',[27.2,22.1,22.6,23.35]],['C',[17.95,24.65,14.2,27.25]],['C',[10.5,29.8,8.25,33.75]],['C',[6.05,37.75,6,43.1]],['C',[5.95,46.85,7.35,50.4]],['C',[8.85,53.85,12.3,56.65]],['C',[15.75,59.5,21.85,61.2]],['L',[34.3,64.45]],['L',[43.1,67.1]],['C',[45.4,67.85,47.15,69.85]],['C',[48.95,71.85,49,75.9]],['C',[49.05,78.65,47.55,81.1]],['C',[46.05,83.6,42.7,85.1]],['C',[39.4,86.65,33.95,86.7]],['C',[28.85,86.75,24.8,85.2]],['C',[20.7,83.65,18.3,80.25]],['C',[15.85,76.9,15.8,71.4]],['L',[3.3,71.4]],['C',[3.55,80.25,7.55,85.85]],['C',[11.55,91.55,18.2,94.2]],['C',[24.9,96.9,33.1,96.9]],['C',[38.55,96.9,43.55,95.65]],['C',[48.6,94.35,52.65,91.7]],['C',[56.7,89,59.1,84.75]],['C',[61.45,80.5,61.5,74.5]],['C',[61.5,70.75,60,67.1]],['C',[58.5,63.5,55.4,60.65]],['C',[52.35,57.75,47.6,56.3]],['L',[43,55]],['L',[36.35,53.25]],['L',[30.2,51.65]],['L',[27,50.8]],['C',[23.15,49.8,20.85,47.55]],['C',[18.55,45.35,18.5,41.6]],['C',[18.6,38,20.6,35.95]],['C',[22.65,33.95,25.65,33.15]],['C',[28.6,32.25,31.6,32.3]],['C',[38.2,32.2,42.35,35.15]],['C',[46.5,38.05,47,44.9]],['L',[59.5,44.9]],['C',[59.4,37.45,55.7,32.35]],['C',[52.05,27.3,45.85,24.7]]];
			__motifs["T"] = [['M',[58.6,23.8]],['L',[0.8,23.8]],['L',[0.8,34.6]],['L',[23.4,34.6]],['L',[23.4,95.2]],['L',[35.9,95.2]],['L',[35.9,34.6]],['L',[58.6,34.6]],['L',[58.6,23.8]]];
			__motifs["U"] = [['M',[52.9,23.8]],['L',[52.9,65.4]],['L',[52.55,72.7]],['C',[52.15,76.35,50.55,79.4]],['C',[48.95,82.4,45.55,84.2]],['C',[42.1,86.05,36.1,86.1]],['C',[30.1,86.05,26.6,84.2]],['C',[23.2,82.4,21.65,79.4]],['C',[20,76.35,19.65,72.7]],['C',[19.25,69.1,19.3,65.4]],['L',[19.3,23.8]],['L',[6.8,23.8]],['L',[6.8,69.5]],['C',[6.85,78.65,10.5,84.75]],['C',[14.1,90.85,20.65,93.9]],['C',[27.25,96.9,36.1,96.9]],['C',[44.9,96.9,51.5,93.9]],['C',[58.05,90.85,61.65,84.75]],['C',[65.35,78.65,65.4,69.5]],['L',[65.4,23.8]],['L',[52.9,23.8]]];
			__motifs["V"] = [['M',[48.95,23.8]],['L',[30.6,80.3]],['L',[30.4,80.3]],['L',[12.5,23.8]],['L',[-0.5,23.8]],['L',[23.35,95.2]],['L',[37.2,95.2]],['L',[61.6,23.8]],['L',[48.95,23.8]]];
			__motifs["W"] = [['M',[81.1,23.8]],['L',[67.8,78.4]],['L',[67.6,78.4]],['L',[53.6,23.8]],['L',[40.8,23.8]],['L',[26.4,78.4]],['L',[26.2,78.4]],['L',[13.3,23.8]],['L',[0.6,23.8]],['L',[19.4,95.2]],['L',[32.3,95.2]],['L',[46.9,40.6]],['L',[47.1,40.6]],['L',[61.4,95.2]],['L',[74.1,95.2]],['L',[93.8,23.8]],['L',[81.1,23.8]]];
			__motifs["X"] = [['M',[49.4,23.8]],['L',[32.5,49]],['L',[16.3,23.8]],['L',[1.4,23.8]],['L',[25,58.2]],['L',[-0.3,95.2]],['L',[14,95.2]],['L',[32.1,67.9]],['L',[49.9,95.2]],['L',[65.1,95.2]],['L',[39.8,58.2]],['L',[63.4,23.8]],['L',[49.4,23.8]]];
			__motifs["Y"] = [['M',[51.4,23.8]],['L',[32.8,55.8]],['L',[13.9,23.8]],['L',[-0.6,23.8]],['L',[26.2,67.2]],['L',[26.2,95.2]],['L',[38.7,95.2]],['L',[38.7,67.2]],['L',[65.45,23.8]],['L',[51.4,23.8]]];
			__motifs["Z"] = [['M',[59.8,23.8]],['L',[5.5,23.8]],['L',[5.5,34.6]],['L',[43.9,34.6]],['L',[2.3,85]],['L',[2.3,95.2]],['L',[60.8,95.2]],['L',[60.8,84.4]],['L',[18.2,84.4]],['L',[59.8,33.35]],['L',[59.8,23.8]]];
		}

		static private function initializeMotifsLowercase():void {
			__motifs["a"] = [['M',[9.05,48.9]],['C',[5.6,52.65,5.15,59.25]],['L',[16.5,59.25]],['C',[16.95,55.05,19.95,53.05]],['C',[23.05,51.05,27.9,51.05]],['L',[32.7,51.55]],['C',[35.15,52.1,36.85,53.65]],['C',[38.55,55.15,38.55,58.1]],['C',[38.55,61.35,36.4,62.65]],['C',[34.3,63.95,30.75,64.35]],['L',[23.1,65.4]],['C',[18.2,65.85,13.65,67.2]],['C',[9.2,68.55,6.25,71.85]],['C',[3.3,75.15,3.2,81.55]],['C',[3.25,86.55,5.75,89.95]],['C',[8.2,93.3,12.2,94.95]],['C',[16.15,96.6,20.9,96.6]],['L',[27.25,96]],['C',[30.5,95.3,33.5,93.95]],['C',[36.5,92.5,38.75,90.3]],['C',[39.5,93.8,41.8,95.25]],['C',[44.1,96.65,47.55,96.6]],['L',[51.2,96.2]],['L',[54.8,95.3]],['L',[54.8,87.45]],['L',[53.15,87.65]],['L',[51.95,87.65]],['C',[50.45,87.65,49.8,86.75]],['C',[49.2,85.85,49.25,83.75]],['L',[49.25,57.05]],['C',[49.15,51.65,46.15,48.35]],['C',[43.1,45.05,38.45,43.55]],['C',[33.75,42.1,28.6,42.1]],['C',[22.8,42.05,17.65,43.6]],['C',[12.45,45.15,9.05,48.9]],['M',[37.9,69.3]],['L',[37.9,77.8]],['C',[37.8,81.45,35.7,83.6]],['C',[33.6,85.75,30.6,86.7]],['C',[27.7,87.65,25.1,87.65]],['L',[20.6,87.05]],['C',[18.15,86.45,16.4,85]],['C',[14.7,83.6,14.6,81.05]],['C',[14.7,76.6,17.45,74.75]],['C',[20.1,72.9,23.9,72.4]],['L',[31.45,71.35]],['C',[35.2,70.95,37.9,69.3]]];
			__motifs["b"] = [['M',[6.3,23.8]],['L',[6.3,95.2]],['L',[17.1,95.2]],['L',[17.1,88.1]],['L',[17.3,88.1]],['C',[19,91.5,21.9,93.35]],['C',[24.7,95.2,28.15,95.95]],['L',[35.2,96.6]],['C',[42.8,96.5,47.75,92.7]],['C',[52.7,88.9,55.1,82.8]],['C',[57.45,76.7,57.45,69.6]],['C',[57.45,61.95,54.85,55.75]],['C',[52.15,49.55,46.8,45.85]],['C',[41.45,42.15,33.3,42.1]],['C',[30.3,42.1,27.4,43.05]],['C',[24.45,44.05,21.95,45.85]],['C',[19.5,47.65,17.85,50.2]],['L',[17.7,50.2]],['L',[17.7,23.8]],['L',[6.3,23.8]],['M',[31.8,51.05]],['C',[36.45,51.15,39.7,53.7]],['C',[42.85,56.3,44.5,60.45]],['C',[46.1,64.6,46.1,69.4]],['C',[46.15,74,44.7,78.1]],['C',[43.25,82.25,40.15,84.9]],['C',[36.95,87.55,31.8,87.65]],['C',[27.15,87.6,23.95,85.25]],['C',[20.7,82.85,19,78.75]],['C',[17.3,74.65,17.3,69.4]],['C',[17.3,61,20.95,56.1]],['C',[24.55,51.15,31.8,51.05]]];
			__motifs["c"] = [['M',[14.85,45.85]],['C',[9.2,49.5,6.35,55.75]],['C',[3.5,62,3.5,69.9]],['C',[3.5,77.55,6.4,83.6]],['C',[9.35,89.6,14.9,93.05]],['C',[20.45,96.5,28.6,96.6]],['C',[38.6,96.55,44.65,91.25]],['C',[50.7,85.9,52.3,75.8]],['L',[40.85,75.8]],['C',[40.05,81.45,36.8,84.5]],['C',[33.6,87.6,28.6,87.65]],['C',[23.7,87.55,20.65,84.95]],['C',[17.65,82.35,16.25,78.3]],['C',[14.9,74.3,14.9,69.9]],['C',[15,62.1,17.25,58.05]],['C',[19.55,53.95,22.8,52.45]],['C',[26.05,50.95,29.1,51.05]],['C',[33.9,51.05,37,53.55]],['C',[40.15,56.05,40.85,60.8]],['L',[52.3,60.8]],['C',[51.65,54.45,48.45,50.3]],['C',[45.15,46.15,40.15,44.1]],['C',[35.05,42.1,29,42.1]],['C',[20.5,42.15,14.85,45.85]]];
			__motifs["d"] = [['M',[43.3,23.8]],['L',[43.3,50.2]],['L',[43.1,50.2]],['C',[41.3,47.3,38.55,45.55]],['C',[35.75,43.75,32.45,42.9]],['C',[29.2,42.1,25.9,42.1]],['C',[20.15,42.1,15.1,44.9]],['C',[10,47.75,6.8,53.7]],['C',[3.6,59.65,3.5,69]],['C',[3.5,76.85,6.15,83.05]],['C',[8.85,89.3,14.2,92.9]],['C',[19.55,96.5,27.7,96.6]],['C',[32.65,96.65,37,94.6]],['C',[41.35,92.6,43.7,88.2]],['L',[43.9,88.2]],['L',[43.9,95.2]],['L',[54.7,95.2]],['L',[54.7,23.8]],['L',[43.3,23.8]],['M',[29.4,51.05]],['C',[36.1,51.1,39.85,55.9]],['C',[43.65,60.7,43.7,69.25]],['C',[43.75,73.9,42.25,78.05]],['C',[40.7,82.2,37.5,84.9]],['C',[34.3,87.55,29.2,87.65]],['C',[24.25,87.55,21.1,85]],['C',[17.9,82.5,16.4,78.45]],['C',[14.9,74.45,14.9,69.9]],['C',[14.85,65.15,16.25,60.85]],['C',[17.7,56.6,20.9,53.9]],['C',[24.05,51.15,29.4,51.05]]];
			__motifs["e"] = [['M',[15.2,45.9]],['C',[9.55,49.6,6.6,55.75]],['C',[3.55,61.95,3.5,69.35]],['C',[3.5,77.45,6.5,83.55]],['C',[9.4,89.65,15.05,93.1]],['C',[20.65,96.55,28.8,96.6]],['C',[34.45,96.6,39.3,94.55]],['C',[44.15,92.5,47.5,88.6]],['C',[50.9,84.7,52.2,79]],['L',[41.4,79]],['C',[39.9,83.3,36.8,85.5]],['C',[33.75,87.65,28.8,87.65]],['C',[24,87.6,20.95,85.5]],['C',[17.85,83.35,16.4,79.85]],['C',[14.9,76.4,14.9,72.3]],['L',[52.9,72.3]],['C',[53.55,66.45,52.15,61]],['C',[50.8,55.65,47.5,51.35]],['C',[44.3,47.1,39.45,44.6]],['C',[34.6,42.1,28.45,42.1]],['C',[20.75,42.15,15.2,45.9]],['M',[39.65,58.05]],['C',[41.25,61.1,41.5,64.8]],['L',[14.9,64.8]],['C',[15.1,60.85,16.8,57.8]],['C',[18.5,54.7,21.55,52.9]],['C',[24.5,51.1,28.45,51.05]],['C',[32.35,51.1,35.2,53]],['C',[38.05,54.9,39.65,58.05]]];
			__motifs["f"] = [['M',[28.35,23.95]],['L',[23.7,23.8]],['C',[19.9,23.7,16.7,24.9]],['C',[13.5,26,11.45,29.35]],['C',[9.45,32.7,9.4,39.2]],['L',[9.4,43.5]],['L',[0.95,43.5]],['L',[0.95,52]],['L',[9.4,52]],['L',[9.4,95.2]],['L',[20.8,95.2]],['L',[20.8,52]],['L',[30.5,52]],['L',[30.5,43.5]],['L',[20.8,43.5]],['L',[20.8,38.2]],['C',[20.85,35.05,22.4,33.85]],['C',[24,32.75,26.4,32.8]],['L',[29.35,32.95]],['L',[31.7,33.4]],['L',[31.7,24.5]],['L',[28.35,23.95]]];
			__motifs["g"] = [['M',[42.45,43.5]],['L',[42.45,50.55]],['L',[42.25,50.55]],['C',[40,46.25,35.95,44.15]],['C',[31.9,42.1,26.9,42.1]],['C',[19.55,42.15,14.3,45.7]],['C',[9.1,49.25,6.3,55.05]],['C',[3.55,60.9,3.5,68]],['C',[3.5,75.45,5.9,81.65]],['C',[8.3,87.8,13.45,91.45]],['C',[18.55,95.1,26.7,95.2]],['C',[31.6,95.15,35.7,92.8]],['C',[39.75,90.4,42.25,86.1]],['L',[42.45,86.1]],['L',[42.45,94]],['C',[42.5,100.4,39.2,103.8]],['C',[36,107.15,29.1,107.2]],['L',[23.65,106.65]],['C',[21.05,106.15,19.25,104.5]],['C',[17.45,102.8,16.7,99.6]],['L',[5.3,99.6]],['C',[5.9,105.6,9.4,109.15]],['C',[12.95,112.7,18,114.25]],['C',[23.1,115.75,28.4,115.7]],['C',[40.7,115.7,47.2,109.9]],['C',[53.75,104.15,53.8,92.5]],['L',[53.8,43.5]],['L',[42.45,43.5]],['M',[28.5,51.05]],['C',[33.45,51.1,36.5,53.5]],['C',[39.6,55.9,41,59.8]],['C',[42.45,63.65,42.45,68.2]],['C',[42.5,72.7,41.05,76.8]],['C',[39.7,80.9,36.6,83.5]],['C',[33.55,86.1,28.5,86.2]],['C',[23.8,86.1,20.75,83.7]],['C',[17.7,81.2,16.3,77.35]],['C',[14.9,73.4,14.9,69.1]],['C',[14.85,64.7,16.15,60.6]],['C',[17.5,56.5,20.5,53.8]],['C',[23.5,51.15,28.5,51.05]]];
			__motifs["h"] = [['M',[6,23.8]],['L',[6,95.2]],['L',[17.4,95.2]],['L',[17.4,64.7]],['C',[17.4,60.85,18.95,57.75]],['C',[20.45,54.65,23.25,52.9]],['C',[26.05,51.1,29.9,51.05]],['C',[34.9,51,37.4,53.85]],['C',[39.85,56.65,40,62.7]],['L',[40,95.2]],['L',[51.35,95.2]],['L',[51.35,59.65]],['C',[51.25,50.95,46.45,46.5]],['C',[41.55,42.1,33.1,42.1]],['C',[27.95,42.15,23.85,44.4]],['C',[19.75,46.65,17.6,50.3]],['L',[17.4,50.3]],['L',[17.4,23.8]],['L',[6,23.8]]];
			__motifs["i"] = [['M',[6.3,34.6]],['L',[17.7,34.6]],['L',[17.7,23.8]],['L',[6.3,23.8]],['L',[6.3,34.6]],['M',[6.3,43.5]],['L',[6.3,95.2]],['L',[17.7,95.2]],['L',[17.7,43.5]],['L',[6.3,43.5]]];
			__motifs["j"] = [['M',[6.3,34.6]],['L',[17.7,34.6]],['L',[17.7,23.8]],['L',[6.3,23.8]],['L',[6.3,34.6]],['M',[6.3,43.5]],['L',[6.3,99.1]],['C',[6.4,102.95,5.55,104.8]],['C',[4.75,106.7,1.7,106.7]],['L',[-0.1,106.65]],['L',[-2.2,106.35]],['L',[-2.2,115.3]],['L',[0.1,115.55]],['L',[2.9,115.7]],['C',[10.85,115.65,14.3,111.5]],['C',[17.75,107.4,17.7,99.65]],['L',[17.7,43.5]],['L',[6.3,43.5]]];
			__motifs["k"] = [['M',[6.3,23.8]],['L',[6.3,95.2]],['L',[17.7,95.2]],['L',[17.7,76.7]],['L',[24.45,70.1]],['L',[40.3,95.2]],['L',[54.15,95.2]],['L',[32.45,62.5]],['L',[52.3,43.5]],['L',[38.3,43.5]],['L',[17.7,64.4]],['L',[17.7,23.8]],['L',[6.3,23.8]]];
			__motifs["l"] = [['M',[6.3,23.8]],['L',[6.3,95.2]],['L',[17.7,95.2]],['L',[17.7,23.8]],['L',[6.3,23.8]]];
			__motifs["m"] = [['M',[54.2,44.35]],['C',[50.3,46.65,47.45,50.65]],['C',[45.65,46.25,41.75,44.15]],['C',[37.8,42.1,33,42.1]],['C',[26.95,42.1,23.25,44.45]],['C',[19.55,46.75,17.1,50.65]],['L',[16.8,50.65]],['L',[16.8,43.5]],['L',[6,43.5]],['L',[6,95.2]],['L',[17.4,95.2]],['L',[17.4,64.5]],['C',[17.45,60.15,19,57.15]],['C',[20.55,54.2,23.15,52.6]],['C',[25.7,51.05,28.7,51.05]],['C',[33.8,51.05,35.85,53.85]],['C',[37.9,56.65,37.8,61.95]],['L',[37.8,95.2]],['L',[49.15,95.2]],['L',[49.15,64.9]],['C',[49.1,58.3,51.75,54.7]],['C',[54.45,51.1,60.15,51.05]],['C',[64.55,51.1,66.55,52.8]],['C',[68.6,54.6,69.15,57.7]],['C',[69.7,60.85,69.6,65]],['L',[69.6,95.2]],['L',[80.95,95.2]],['L',[80.95,59.45]],['C',[80.9,50.15,76.4,46.05]],['C',[71.9,42,63.65,42.1]],['C',[58.1,42.1,54.2,44.35]]];
			__motifs["n"] = [['M',[6,43.5]],['L',[6,95.2]],['L',[17.4,95.2]],['L',[17.4,64.7]],['C',[17.4,60.85,18.95,57.75]],['C',[20.45,54.65,23.25,52.9]],['C',[26.05,51.1,29.9,51.05]],['C',[34.9,51,37.4,53.85]],['C',[39.85,56.65,40,62.7]],['L',[40,95.2]],['L',[51.35,95.2]],['L',[51.35,59.65]],['C',[51.25,50.95,46.45,46.5]],['C',[41.55,42.1,33.1,42.1]],['C',[27.95,42.1,23.8,44.5]],['C',[19.6,46.95,17,51.25]],['L',[16.8,51.05]],['L',[16.8,43.5]],['L',[6,43.5]]];
			__motifs["o"] = [['M',[15.6,45.65]],['C',[9.7,49.1,6.7,55.2]],['C',[3.65,61.3,3.6,69.25]],['C',[3.65,77.35,6.7,83.5]],['C',[9.7,89.6,15.6,93.05]],['C',[21.4,96.55,29.75,96.6]],['C',[38.05,96.55,43.85,93.05]],['C',[49.7,89.6,52.75,83.5]],['C',[55.75,77.35,55.8,69.25]],['C',[55.75,61.3,52.75,55.2]],['C',[49.7,49.1,43.85,45.65]],['C',[38.05,42.1,29.75,42.1]],['C',[21.4,42.1,15.6,45.65]],['M',[29.75,51.05]],['C',[34.8,51.15,38.1,53.8]],['C',[41.3,56.5,42.85,60.6]],['C',[44.45,64.75,44.45,69.25]],['C',[44.45,73.9,42.85,78.05]],['C',[41.3,82.2,38.1,84.9]],['C',[34.8,87.55,29.75,87.65]],['C',[24.6,87.55,21.35,84.9]],['C',[18.1,82.2,16.55,78.05]],['C',[15,73.9,15,69.25]],['C',[15,64.75,16.55,60.6]],['C',[18.1,56.5,21.35,53.8]],['C',[24.6,51.15,29.75,51.05]]];
			__motifs["p"] = [['M',[6.3,43.5]],['L',[6.3,114.3]],['L',[17.7,114.3]],['L',[17.7,88.5]],['L',[17.85,88.5]],['C',[19.75,91.4,22.5,93.15]],['C',[25.3,94.95,28.55,95.8]],['C',[31.85,96.6,35.2,96.6]],['C',[42.8,96.5,47.75,92.7]],['C',[52.7,88.9,55.1,82.8]],['C',[57.45,76.7,57.45,69.6]],['C',[57.45,61.95,54.85,55.75]],['C',[52.15,49.55,46.8,45.85]],['C',[41.45,42.15,33.3,42.1]],['C',[28.25,42.05,24,44.1]],['C',[19.8,46.1,17.3,50.45]],['L',[17.1,50.45]],['L',[17.1,43.5]],['L',[6.3,43.5]],['M',[31.8,51.05]],['C',[36.45,51.15,39.7,53.7]],['C',[42.85,56.3,44.5,60.45]],['C',[46.1,64.6,46.1,69.4]],['C',[46.15,74,44.7,78.1]],['C',[43.25,82.25,40.15,84.9]],['C',[36.95,87.55,31.8,87.65]],['C',[27.15,87.6,23.95,85.25]],['C',[20.7,82.85,19,78.75]],['C',[17.3,74.65,17.3,69.4]],['C',[17.3,61,20.95,56.1]],['C',[24.55,51.15,31.8,51.05]]];
			__motifs["q"] = [['M',[43.9,43.5]],['L',[43.9,50.45]],['L',[43.7,50.45]],['C',[41.2,46.1,36.95,44.1]],['C',[32.7,42.05,27.7,42.1]],['C',[19.55,42.15,14.2,45.85]],['C',[8.85,49.55,6.15,55.75]],['C',[3.5,61.95,3.5,69.6]],['C',[3.5,76.7,5.9,82.8]],['C',[8.3,88.9,13.25,92.7]],['C',[18.15,96.5,25.8,96.6]],['L',[32.4,95.8]],['C',[35.7,94.95,38.5,93.15]],['C',[41.25,91.4,43.1,88.5]],['L',[43.3,88.5]],['L',[43.3,114.3]],['L',[54.7,114.3]],['L',[54.7,43.5]],['L',[43.9,43.5]],['M',[29.2,51.05]],['C',[36.35,51.15,40.05,56.05]],['C',[43.7,60.85,43.7,69.4]],['C',[43.7,74.85,42.15,78.95]],['C',[40.6,83.05,37.35,85.3]],['C',[34.15,87.6,29.2,87.65]],['C',[24,87.55,20.85,84.9]],['C',[17.7,82.25,16.3,78.1]],['C',[14.85,74,14.9,69.4]],['C',[14.9,64.6,16.5,60.45]],['C',[18.1,56.3,21.3,53.7]],['C',[24.5,51.15,29.2,51.05]]];
			__motifs["r"] = [['M',[6,43.5]],['L',[6,95.2]],['L',[17.4,95.2]],['L',[17.4,70.6]],['C',[17.45,64.9,19.3,60.9]],['C',[21.15,56.95,24.25,54.9]],['C',[27.45,52.85,31.4,52.85]],['L',[33.85,53.05]],['L',[36.3,53.35]],['L',[36.3,42.35]],['L',[34.7,42.15]],['L',[32,42.1]],['C',[28.4,42.1,25.25,43.85]],['C',[22.05,45.5,19.8,48.1]],['C',[17.6,50.65,16.9,53.45]],['L',[16.7,53.45]],['L',[16.7,43.5]],['L',[6,43.5]]];
			__motifs["s"] = [['M',[11.55,45.25]],['C',[8.35,46.9,6.35,49.8]],['C',[4.35,52.65,4.3,56.85]],['C',[4.4,62.1,6.75,65.1]],['C',[9.1,68.15,12.85,69.75]],['C',[16.6,71.35,20.9,72.2]],['L',[28.9,73.95]],['C',[32.65,74.8,35.1,76.35]],['C',[37.55,77.85,37.8,80.8]],['C',[37.85,83.75,35.9,85.25]],['C',[33.95,86.7,31.25,87.2]],['L',[26.25,87.65]],['C',[21.65,87.7,18.35,85.65]],['C',[15.15,83.55,14.6,78.65]],['L',[3.2,78.65]],['C',[3.35,84.7,6.35,88.7]],['C',[9.35,92.7,14.45,94.65]],['C',[19.55,96.6,26.05,96.6]],['L',[34.25,95.75]],['C',[38.3,94.8,41.65,92.85]],['C',[45,90.85,47.05,87.65]],['C',[49.1,84.4,49.15,79.8]],['C',[49.05,74.8,46.7,71.8]],['C',[44.3,68.85,40.55,67.2]],['C',[36.7,65.6,32.5,64.75]],['L',[24.4,62.9]],['C',[20.55,62.1,18.15,60.6]],['C',[15.75,59.1,15.65,56.4]],['C',[15.75,54.15,17.4,52.95]],['C',[19,51.85,21.2,51.45]],['L',[25.1,51.05]],['C',[28.9,50.95,31.85,52.5]],['C',[34.75,54,35.6,58]],['L',[47.45,58]],['C',[46.75,52.25,43.6,48.7]],['C',[40.55,45.25,35.9,43.65]],['C',[31.25,42.1,25.9,42.1]],['L',[18.55,42.8]],['C',[14.8,43.55,11.55,45.25]]];
			__motifs["t"] = [['M',[0.85,43.5]],['L',[0.85,52]],['L',[9.4,52]],['L',[9.4,82.5]],['C',[9.45,86.8,10.6,89.75]],['C',[11.7,92.65,14.75,94.15]],['C',[17.8,95.7,23.7,95.7]],['L',[27.4,95.45]],['L',[31.1,95.1]],['L',[31.1,86.3]],['L',[28.7,86.65]],['L',[26.3,86.7]],['C',[23.8,86.7,22.6,85.9]],['C',[21.45,85.1,21.1,83.55]],['C',[20.75,81.95,20.8,79.6]],['L',[20.8,52]],['L',[31.1,52]],['L',[31.1,43.5]],['L',[20.8,43.5]],['L',[20.8,28]],['L',[9.4,28]],['L',[9.4,43.5]],['L',[0.85,43.5]]];
			__motifs["u"] = [['M',[6,43.5]],['L',[6,76.3]],['C',[5.95,86.45,10.6,91.55]],['C',[15.25,96.6,25.3,96.6]],['C',[29.7,96.55,33.75,94.25]],['C',[37.8,92,40,88]],['L',[40.2,88]],['L',[40.2,95.2]],['L',[51.35,95.2]],['L',[51.35,43.5]],['L',[40,43.5]],['L',[40,73.45]],['C',[40.05,77.55,38.8,80.75]],['C',[37.6,83.9,34.8,85.8]],['C',[32.05,87.6,27.3,87.65]],['C',[22.6,87.75,20,84.85]],['C',[17.45,81.95,17.4,75.25]],['L',[17.4,43.5]],['L',[6,43.5]]];
			__motifs["v"] = [['M',[0.9,43.5]],['L',[19.7,95.2]],['L',[32.45,95.2]],['L',[51,43.5]],['L',[39.15,43.5]],['L',[26.55,83.2]],['L',[26.35,83.2]],['L',[13.3,43.5]],['L',[0.9,43.5]]];
			__motifs["w"] = [['M',[64.9,43.5]],['L',[54.4,82.1]],['L',[54.2,82.1]],['L',[44.9,43.5]],['L',[33.4,43.5]],['L',[23.7,82.1]],['L',[23.5,82.1]],['L',[13.4,43.5]],['L',[1.3,43.5]],['L',[17.3,95.2]],['L',[29.3,95.2]],['L',[38.8,56.75]],['L',[39,56.75]],['L',[48.6,95.2]],['L',[60.3,95.2]],['L',[76.5,43.5]],['L',[64.9,43.5]]];
			__motifs["x"] = [['M',[2,43.5]],['L',[19.9,67.95]],['L',[0.4,95.2]],['L',[13.8,95.2]],['L',[26.5,76.1]],['L',[39.6,95.2]],['L',[53.3,95.2]],['L',[33.5,67.35]],['L',[51.1,43.5]],['L',[37.9,43.5]],['L',[26.6,59.35]],['L',[15.8,43.5]],['L',[2,43.5]]];
			__motifs["y"] = [['M',[0.3,43.5]],['L',[19.9,95]],['L',[18.6,99]],['L',[17.1,102.8]],['C',[16.2,104.45,14.7,105.3]],['C',[13.25,106.2,10.6,106.2]],['L',[7.9,105.95]],['L',[5.2,105.5]],['L',[5.2,115.1]],['L',[9.15,115.55]],['L',[13.1,115.7]],['C',[18.95,115.6,22.3,113.15]],['C',[25.7,110.75,27.65,106.7]],['L',[31.4,98]],['L',[51.5,43.5]],['L',[39.6,43.5]],['L',[26.5,82.1]],['L',[26.3,82.1]],['L',[12.8,43.5]],['L',[0.3,43.5]]];
			__motifs["z"] = [['M',[2.2,95.2]],['L',[47.7,95.2]],['L',[47.7,86.2]],['L',[16.6,86.2]],['L',[46.2,51.5]],['L',[46.2,43.5]],['L',[4.2,43.5]],['L',[4.2,52.5]],['L',[30.8,52.5]],['L',[2.2,87.2]],['L',[2.2,95.2]]];
		}

		static private function initializeMotifsNumbers():void {
			__motifs["0"] = [['M',[47.45,36.05]],['C',[44.8,30.65,40.1,27.3]],['C',[35.3,23.9,27.85,23.8]],['C',[20.3,23.9,15.55,27.3]],['C',[10.8,30.65,8.15,36.05]],['C',[5.55,41.5,4.6,47.85]],['C',[3.55,54.15,3.6,60.2]],['C',[3.55,66.3,4.6,72.6]],['C',[5.55,78.95,8.15,84.35]],['C',[10.8,89.8,15.55,93.15]],['C',[20.3,96.5,27.85,96.6]],['C',[35.3,96.5,40.1,93.15]],['C',[44.8,89.8,47.45,84.35]],['C',[50.05,78.95,51.05,72.6]],['C',[52.05,66.3,52,60.2]],['C',[52.05,54.15,51.05,47.85]],['C',[50.05,41.5,47.45,36.05]],['M',[39.55,46.75]],['C',[40.65,52.8,40.65,60.2]],['C',[40.65,67.6,39.55,73.65]],['C',[38.4,79.7,35.6,83.4]],['C',[32.75,87,27.85,87.1]],['C',[22.85,87,20,83.4]],['C',[17.25,79.7,16.05,73.65]],['C',[14.95,67.6,15,60.2]],['C',[14.95,52.8,16.05,46.75]],['C',[17.25,40.7,20,37.05]],['C',[22.85,33.45,27.85,33.35]],['C',[32.75,33.45,35.6,37.05]],['C',[38.4,40.7,39.55,46.75]]];
			__motifs["1"] = [['M',[5.3,45.8]],['L',[22.5,45.8]],['L',[22.5,95.2]],['L',[35,95.2]],['L',[35,25.2]],['L',[25.75,25.2]],['C',[24.8,29.4,21.8,31.95]],['C',[18.8,34.55,14.5,35.75]],['C',[10.15,36.85,5.3,36.8]],['L',[5.3,45.8]]];
			__motifs["2"] = [['M',[46.95,31.2]],['C',[44.4,27.95,40.05,25.9]],['C',[35.7,23.85,29.3,23.8]],['C',[21.5,23.9,16.1,27.4]],['C',[10.8,30.85,8,36.95]],['C',[5.2,43,5.2,50.8]],['L',[16.6,50.8]],['C',[16.7,45.9,17.8,41.95]],['C',[19,37.95,21.6,35.7]],['C',[24.1,33.4,28.6,33.35]],['C',[33.5,33.45,36.1,35.45]],['C',[38.65,37.45,39.6,40.25]],['C',[40.55,43.15,40.45,45.75]],['C',[40.3,49.8,38.35,52.95]],['C',[36.4,56.2,33.2,58.8]],['C',[30.1,61.45,26.4,63.85]],['L',[19.3,68.7]],['C',[12.2,73.4,8.15,80]],['C',[4.05,86.6,3.9,95.2]],['L',[51.7,95.2]],['L',[51.7,85]],['L',[17.6,85]],['C',[18.65,81.9,21.55,79.35]],['C',[24.35,76.7,28.2,74.2]],['L',[36.25,68.95]],['C',[40.3,66.15,43.8,62.8]],['C',[47.35,59.4,49.55,55.1]],['C',[51.75,50.85,51.8,45.3]],['C',[51.8,41.9,50.7,38.15]],['C',[49.55,34.45,46.95,31.2]]];
			__motifs["3"] = [['M',[46.4,32.15]],['C',[43.2,28,38.2,25.9]],['C',[33.15,23.8,27.6,23.8]],['C',[20.5,23.85,15.45,27]],['C',[10.35,30.05,7.5,35.4]],['C',[4.75,40.75,4.4,47.6]],['L',[15.75,47.6]],['C',[15.65,43.95,16.95,40.7]],['C',[18.2,37.5,20.8,35.45]],['C',[23.45,33.4,27.4,33.35]],['C',[32.25,33.4,35.25,36.05]],['C',[38.25,38.75,38.35,43.2]],['C',[38.3,47.5,36,49.95]],['C',[33.75,52.4,30.2,53.4]],['C',[26.7,54.4,22.85,54.2]],['L',[22.8,62.7]],['L',[31.55,63.15]],['C',[35.7,63.9,38.4,66.6]],['C',[41,69.2,41.1,74.6]],['C',[41.05,78.6,39.3,81.4]],['C',[37.6,84.15,34.55,85.65]],['C',[31.55,87.1,27.7,87.1]],['C',[23.25,87.05,20.25,85.15]],['C',[17.3,83.2,15.8,79.8]],['C',[14.35,76.5,14.5,72.2]],['L',[3.15,72.2]],['C',[3.25,79.55,6.05,85]],['C',[8.8,90.45,14.2,93.55]],['C',[19.65,96.55,27.7,96.6]],['C',[34.5,96.55,40.1,94]],['C',[45.7,91.4,49,86.6]],['C',[52.4,81.8,52.5,75.2]],['C',[52.45,68.35,49.1,63.65]],['C',[45.8,59,39.8,57.7]],['L',[39.8,57.5]],['C',[44.8,55.65,47.25,51.75]],['C',[49.7,47.85,49.7,42.5]],['C',[49.6,36.3,46.4,32.15]]];
			__motifs["4"] = [['M',[32.4,38.8]],['L',[32.4,69.6]],['L',[11.25,69.6]],['L',[32.25,38.8]],['L',[32.4,38.8]],['M',[32.4,95.2]],['L',[43.2,95.2]],['L',[43.2,78.6]],['L',[52.2,78.6]],['L',[52.2,69.6]],['L',[43.2,69.6]],['L',[43.2,25.2]],['L',[32.4,25.2]],['L',[2.45,67.3]],['L',[2.45,78.6]],['L',[32.4,78.6]],['L',[32.4,95.2]]];
			__motifs["5"] = [['M',[48.5,25.2]],['L',[12.3,25.2]],['L',[4.85,63.4]],['L',[16.2,63.4]],['C',[17.65,59.8,20.7,58.4]],['C',[23.85,56.95,27.5,57]],['C',[32.1,57.05,35.05,59.1]],['C',[38,61.1,39.4,64.45]],['C',[40.8,67.75,40.8,71.65]],['C',[40.85,75.95,39.6,79.45]],['C',[38.4,82.95,35.5,85]],['C',[32.6,87.05,27.8,87.1]],['C',[22.2,87.05,18.85,84]],['C',[15.5,80.95,14.9,75.3]],['L',[3.5,75.3]],['C',[3.8,82.3,7.1,87.05]],['C',[10.35,91.8,15.75,94.15]],['C',[21.2,96.6,28.05,96.6]],['C',[34.4,96.55,39.05,94.25]],['C',[43.65,92,46.55,88.25]],['C',[49.45,84.5,50.85,80.1]],['C',[52.2,75.7,52.2,71.45]],['C',[52.2,64.7,49.6,59.4]],['C',[47,54.15,42.2,51.1]],['C',[37.3,48.1,30.3,48.05]],['C',[26.7,48.05,23.25,49.4]],['C',[19.8,50.75,17.4,53.3]],['L',[17.2,53.1]],['L',[20.8,35.4]],['L',[48.5,35.4]],['L',[48.5,25.2]]];
			__motifs["6"] = [['M',[47.6,32.9]],['C',[44.75,28.65,40.1,26.25]],['C',[35.4,23.85,29.8,23.8]],['C',[22.4,23.9,17.35,27.15]],['C',[12.25,30.35,9.2,35.7]],['C',[6.1,40.95,4.8,47.3]],['C',[3.4,53.65,3.4,60]],['C',[3.3,70.3,5.45,78.55]],['C',[7.55,86.8,13.15,91.65]],['C',[18.7,96.5,28.9,96.6]],['C',[35.95,96.55,41.15,93.45]],['C',[46.4,90.3,49.25,84.95]],['C',[52.15,79.6,52.2,72.7]],['C',[52.15,65.9,49.55,60.65]],['C',[46.9,55.35,42.05,52.35]],['C',[37.1,49.25,30.15,49.2]],['C',[25.4,49.2,21.4,51.3]],['C',[17.45,53.35,15.05,57.5]],['L',[14.8,57.3]],['C',[15.05,53.75,15.65,49.7]],['C',[16.2,45.6,17.7,41.9]],['C',[19.15,38.15,21.9,35.8]],['C',[24.7,33.4,29.3,33.35]],['C',[33.8,33.4,36.45,35.95]],['C',[39.1,38.6,39.5,42.9]],['L',[50.9,42.9]],['C',[50.5,37.2,47.6,32.9]],['M',[28.5,58.2]],['C',[32.6,58.25,35.35,60.25]],['C',[38.1,62.2,39.45,65.45]],['C',[40.8,68.7,40.8,72.5]],['C',[40.8,76.3,39.45,79.6]],['C',[38.1,82.95,35.35,85]],['C',[32.6,87.05,28.5,87.1]],['C',[24.35,87.05,21.6,85]],['C',[18.75,82.95,17.35,79.65]],['C',[15.9,76.35,15.9,72.5]],['C',[15.9,68.6,17.35,65.35]],['C',[18.75,62.15,21.6,60.2]],['C',[24.35,58.25,28.5,58.2]]];
			__motifs["7"] = [['M',[51.35,25.2]],['L',[3.5,25.2]],['L',[3.5,35.4]],['L',[39.8,35.4]],['C',[32.5,43.55,26.7,53.15]],['C',[20.9,62.85,17.3,73.45]],['C',[13.6,84.1,12.8,95.2]],['L',[25.3,95.2]],['C',[26.2,82.6,29.6,71.9]],['C',[33,61.25,38.55,52.1]],['C',[44.05,42.9,51.35,34.7]],['L',[51.35,25.2]]];
			__motifs["8"] = [['M',[43.95,28.9]],['C',[38.3,23.9,27.85,23.8]],['C',[17.35,23.9,11.65,28.9]],['C',[6.05,33.9,6,42.9]],['C',[6.05,48.05,8.6,51.75]],['C',[11.15,55.45,15.9,57.3]],['L',[15.9,57.5]],['C',[10,59.05,6.6,63.5]],['C',[3.15,67.95,3.15,74.65]],['C',[3.15,81.55,6.35,86.4]],['C',[9.55,91.35,15.1,94]],['C',[20.65,96.55,27.85,96.6]],['C',[34.95,96.55,40.55,94]],['C',[46.05,91.35,49.25,86.4]],['C',[52.45,81.55,52.5,74.65]],['C',[52.45,67.95,49,63.5]],['C',[45.6,59.05,39.7,57.5]],['L',[39.7,57.3]],['C',[44.5,55.45,47,51.75]],['C',[49.55,48.05,49.6,42.9]],['C',[49.55,33.9,43.95,28.9]],['M',[27.85,32.8]],['C',[32.5,32.8,35.6,35.6]],['C',[38.7,38.3,38.8,43.5]],['C',[38.7,48.45,35.7,51.1]],['C',[32.6,53.8,27.85,53.8]],['C',[23,53.8,19.9,51.1]],['C',[16.9,48.45,16.8,43.5]],['C',[16.9,38.3,20,35.6]],['C',[23.1,32.8,27.85,32.8]],['M',[37.3,65.55]],['C',[41,68.8,41.1,74.6]],['C',[41,80.8,37.3,84.2]],['C',[33.65,87.6,27.85,87.65]],['C',[21.95,87.6,18.3,84.2]],['C',[14.6,80.85,14.5,74.65]],['C',[14.6,68.8,18.3,65.55]],['C',[21.95,62.35,27.85,62.3]],['C',[33.65,62.35,37.3,65.55]]];
			__motifs["9"] = [['M',[42.7,28.8]],['C',[37.3,23.9,27.5,23.8]],['C',[19.8,23.85,14.45,27]],['C',[9.1,30.1,6.25,35.5]],['C',[3.4,40.85,3.4,47.7]],['C',[3.45,54.85,6.2,60.2]],['C',[8.95,65.45,13.9,68.35]],['C',[18.85,71.25,25.5,71.25]],['C',[30.35,71.25,34.35,69.1]],['C',[38.3,66.95,40.6,62.9]],['L',[40.8,63.05]],['C',[40.6,66.65,40,70.75]],['C',[39.4,74.85,37.95,78.55]],['C',[36.45,82.25,33.7,84.65]],['C',[30.9,87.05,26.3,87.1]],['C',[21.85,87.05,19.15,84.45]],['C',[16.45,81.8,16.05,77.5]],['L',[4.7,77.5]],['C',[5.1,83.25,7.95,87.55]],['C',[10.85,91.8,15.55,94.15]],['C',[20.15,96.55,25.8,96.6]],['C',[33.2,96.5,38.3,93.3]],['C',[43.35,90.05,46.45,84.75]],['C',[49.5,79.5,50.85,73.15]],['C',[52.2,66.8,52.2,60.45]],['C',[52.3,50.15,50.2,41.9]],['C',[48.1,33.65,42.7,28.8]],['M',[16.1,40.5]],['C',[17.45,37.3,20.15,35.35]],['C',[22.85,33.4,27,33.35]],['C',[31.25,33.4,34.1,35.4]],['C',[36.9,37.35,38.3,40.55]],['C',[39.7,43.8,39.7,47.6]],['C',[39.7,51.5,38.3,54.8]],['C',[36.9,58.15,34.1,60.2]],['C',[31.25,62.25,27,62.3]],['C',[22.85,62.25,20.15,60.2]],['C',[17.45,58.1,16.1,54.75]],['C',[14.8,51.45,14.8,47.6]],['C',[14.8,43.8,16.1,40.5]]];
		}

		static private function initializeMotifsPunctuation():void {
			__motifs[" "] = [];
			__motifs["!"] = [['M',[7.7,44.4]],['L',[11.05,75.35]],['L',[16.9,75.35]],['L',[20.2,44.4]],['L',[20.2,23.8]],['L',[7.7,23.8]],['L',[7.7,44.4]],['M',[7.25,95.2]],['L',[20.6,95.2]],['L',[20.6,82.7]],['L',[7.25,82.7]],['L',[7.25,95.2]]];
			__motifs["\""] = [['M',[25.9,23.8]],['L',[25.9,52.05]],['L',[36.1,52.05]],['L',[36.1,23.8]],['L',[25.9,23.8]],['M',[8.3,23.8]],['L',[8.3,52.05]],['L',[18.5,52.05]],['L',[18.5,23.8]],['L',[8.3,23.8]]];
			__motifs["#"] = [['M',[46.8,25.2]],['L',[38.65,25.2]],['L',[35.8,46.2]],['L',[24.65,46.2]],['L',[27.7,25.2]],['L',[19.6,25.2]],['L',[16.7,46.2]],['L',[6.3,46.2]],['L',[6.3,53.7]],['L',[15.65,53.7]],['L',[13.85,66.7]],['L',[3.35,66.7]],['L',[3.35,74.2]],['L',[12.8,74.2]],['L',[9.85,95.2]],['L',[17.85,95.2]],['L',[20.9,74.2]],['L',[31.9,74.2]],['L',[29,95.2]],['L',[36.95,95.2]],['L',[40,74.2]],['L',[49.45,74.2]],['L',[49.45,66.7]],['L',[40.95,66.7]],['L',[42.75,53.7]],['L',[52.4,53.7]],['L',[52.4,46.2]],['L',[43.8,46.2]],['L',[46.8,25.2]],['M',[34.75,53.7]],['L',[32.95,66.7]],['L',[21.9,66.7]],['L',[23.7,53.7]],['L',[34.75,53.7]]];
			__motifs["$"] = [['M',[41.2,24.2]],['C',[36.3,22.1,30.2,22.1]],['L',[30.2,14.3]],['L',[25.9,14.3]],['L',[25.9,22.1]],['C',[19.85,22.1,14.75,24.35]],['C',[9.6,26.6,6.45,31]],['C',[3.3,35.35,3.2,41.7]],['C',[3.3,48.9,6.7,53.2]],['C',[10,57.55,15.2,59.9]],['C',[20.3,62.3,25.9,63.7]],['L',[25.9,87.9]],['C',[19.1,87.65,16,83.9]],['C',[13,80.15,13.1,73.5]],['L',[1.7,73.5]],['C',[1.65,81,4.7,86.1]],['C',[7.7,91.3,13.2,94.05]],['C',[18.65,96.75,25.9,96.9]],['L',[25.9,104.7]],['L',[30.2,104.7]],['L',[30.2,96.9]],['C',[36.9,96.6,42.3,94.15]],['C',[47.6,91.7,50.75,86.8]],['C',[53.85,81.9,53.9,74.4]],['C',[53.8,67.2,50.45,62.9]],['C',[47.1,58.6,41.75,56.15]],['C',[36.4,53.75,30.2,52.2]],['L',[30.2,31.1]],['C',[35.5,31.15,38,33.8]],['C',[40.55,36.55,40.7,41.6]],['L',[52.1,41.6]],['C',[52,35,49.05,30.7]],['C',[46.15,26.35,41.2,24.2]],['M',[17.55,33.4]],['C',[20.45,31.05,25.9,31.1]],['L',[25.9,51.1]],['C',[23.05,50.4,20.45,49.25]],['C',[17.9,48.15,16.25,46.15]],['C',[14.65,44.15,14.6,40.9]],['C',[14.65,35.7,17.55,33.4]],['M',[36.15,66.65]],['C',[38.95,67.85,40.7,70.1]],['C',[42.5,72.3,42.55,76]],['C',[42.45,81.95,39.05,84.8]],['C',[35.7,87.6,30.2,87.9]],['L',[30.2,64.65]],['C',[33.35,65.35,36.15,66.65]]];
			__motifs["%"] = [['M',[82.05,83.55]],['C',[81.25,86.55,79.55,88.3]],['C',[77.8,90.05,75,90.1]],['C',[72.2,90.05,70.5,88.3]],['C',[68.85,86.55,68.1,83.55]],['C',[67.4,80.5,67.4,76.7]],['C',[67.35,73.35,67.95,70.25]],['C',[68.6,67.2,70.25,65.3]],['C',[71.9,63.35,75,63.3]],['C',[78.1,63.35,79.8,65.3]],['C',[81.5,67.2,82.2,70.25]],['C',[82.85,73.35,82.8,76.7]],['C',[82.8,80.5,82.05,83.55]],['M',[84.6,59.6]],['C',[80.95,56.85,75.1,56.8]],['C',[69.25,56.85,65.6,59.6]],['C',[61.85,62.3,60.1,66.8]],['C',[58.4,71.25,58.4,76.7]],['C',[58.4,82.25,60.05,86.7]],['C',[61.7,91.2,65.4,93.9]],['C',[69.1,96.55,75.1,96.6]],['C',[81.1,96.55,84.8,93.9]],['C',[88.5,91.2,90.15,86.7]],['C',[91.8,82.25,91.8,76.7]],['C',[91.8,71.25,90.1,66.8]],['C',[88.35,62.3,84.6,59.6]],['M',[64.9,22.85]],['L',[26.05,97.6]],['L',[33.8,97.6]],['L',[72.45,22.85]],['L',[64.9,22.85]],['M',[9.9,33.75]],['C',[8.2,38.2,8.2,43.75]],['C',[8.2,49.25,9.85,53.75]],['C',[11.5,58.2,15.2,60.85]],['C',[18.9,63.55,24.9,63.6]],['C',[30.9,63.55,34.6,60.85]],['C',[38.3,58.2,39.95,53.75]],['C',[41.6,49.25,41.6,43.75]],['C',[41.6,38.2,39.9,33.75]],['C',[38.15,29.3,34.4,26.6]],['C',[30.75,23.85,24.9,23.8]],['C',[19.05,23.85,15.4,26.6]],['C',[11.65,29.3,9.9,33.75]],['M',[17.75,37.25]],['C',[18.4,34.2,20.05,32.3]],['C',[21.75,30.35,24.8,30.3]],['C',[27.9,30.35,29.6,32.3]],['C',[31.3,34.2,32,37.25]],['C',[32.65,40.3,32.6,43.75]],['C',[32.6,47.5,31.85,50.5]],['C',[31.05,53.55,29.35,55.3]],['C',[27.6,57.05,24.8,57.1]],['C',[22,57.05,20.3,55.3]],['C',[18.65,53.55,17.9,50.5]],['C',[17.2,47.5,17.2,43.75]],['C',[17.15,40.3,17.75,37.25]]];
			__motifs["&"] = [['M',[45.1,29.7]],['C',[42.65,25.9,38.6,24]],['C',[34.55,22.1,29.9,22.1]],['C',[25,22.15,21.05,24.2]],['C',[17.1,26.3,14.8,30.1]],['C',[12.45,33.9,12.4,39.1]],['C',[12.5,43.7,14.6,47.45]],['C',[16.75,51.2,19.65,54.7]],['C',[15.45,56.8,11.7,59.7]],['C',[8,62.65,5.65,66.5]],['C',[3.3,70.4,3.2,75.4]],['C',[3.25,82.15,6.15,86.9]],['C',[9,91.6,14.05,94.1]],['C',[19.1,96.6,25.7,96.6]],['C',[31.9,96.6,36.8,94.35]],['C',[41.75,92.1,45.7,87.25]],['L',[52.2,95.2]],['L',[66.2,95.2]],['L',[52.5,78.6]],['C',[54.9,74.8,56.25,70.3]],['C',[57.55,65.8,58.1,61.1]],['L',[48.1,61.1]],['C',[47.7,64.55,47.1,66.8]],['L',[45.9,70.7]],['L',[34.8,57.3]],['C',[38.3,55.45,41.2,52.8]],['C',[44.15,50.25,45.9,46.8]],['C',[47.65,43.4,47.7,39.2]],['C',[47.6,33.5,45.1,29.7]],['M',[22.6,38.5]],['C',[22.7,34.85,24.85,32.75]],['C',[26.95,30.65,30.2,30.6]],['C',[33.55,30.65,35.5,32.95]],['C',[37.45,35.2,37.5,38.8]],['C',[37.4,43,34.9,45.65]],['C',[32.45,48.35,29.1,50.4]],['L',[26.25,46.75]],['C',[24.75,44.9,23.75,42.85]],['C',[22.65,40.85,22.6,38.5]],['M',[25.6,62.25]],['L',[39.6,79.6]],['L',[36.95,83]],['C',[35.4,84.85,32.8,86.2]],['C',[30.2,87.6,26.1,87.65]],['C',[21.05,87.6,17.85,84.5]],['C',[14.7,81.45,14.6,75.6]],['C',[14.7,71.4,16.5,69]],['C',[18.35,66.5,20.9,65]],['C',[23.4,63.45,25.6,62.25]]];
			__motifs["'"] = [['M',[8.8,23.8]],['L',[8.8,52.05]],['L',[19,52.05]],['L',[19,23.8]],['L',[8.8,23.8]]];
			__motifs["("] = [['M',[8.7,44.35]],['C',[5,56.1,4.95,68.2]],['C',[5,77.7,6.9,85.85]],['C',[8.8,93.95,12,100.95]],['C',[15.3,108,19.3,114.3]],['L',[28.6,114.3]],['C',[22.3,103.65,19.3,92.15]],['C',[16.3,80.7,16.3,68.2]],['C',[16.3,55.7,19.45,44.25]],['C',[22.6,32.8,28.6,22.1]],['L',[19.3,22.1]],['C',[12.45,32.65,8.7,44.35]]];
			__motifs[")"] = [['M',[8.55,22.1]],['L',[-0.8,22.1]],['C',[5.5,32.8,8.55,44.3]],['C',[11.5,55.8,11.5,68.3]],['C',[11.5,80.8,8.4,92.2]],['C',[5.2,103.65,-0.8,114.3]],['L',[8.55,114.3]],['C',[15.4,103.8,19.15,92.1]],['C',[22.85,80.45,22.9,68.3]],['C',[22.85,58.75,20.95,50.65]],['C',[19.05,42.55,15.8,35.55]],['C',[12.55,28.45,8.55,22.1]]];
			__motifs["*"] = [['M',[4.1,31.55]],['L',[1.9,38]],['L',[13,41.85]],['L',[6,51.2]],['L',[11.6,55.1]],['L',[18.4,45.3]],['L',[25.5,55.1]],['L',[30.8,51.2]],['L',[23.85,41.85]],['L',[35.2,38]],['L',[32.8,31.55]],['L',[21.9,35.85]],['L',[21.9,23.8]],['L',[15.1,23.8]],['L',[15.1,35.85]],['L',[4.1,31.55]]];
			__motifs["+"] = [['M',[24.9,44.55]],['L',[24.9,64.8]],['L',[4.8,64.8]],['L',[4.8,75]],['L',[24.9,75]],['L',[24.9,95.2]],['L',[35.1,95.2]],['L',[35.1,75]],['L',[55.2,75]],['L',[55.2,64.8]],['L',[35.1,64.8]],['L',[35.1,44.55]],['L',[24.9,44.55]]];
			__motifs[","] = [['M',[6.9,95.2]],['L',[13.75,95.2]],['C',[13.85,98.5,12.2,101.25]],['C',[10.6,104,7.3,104.9]],['L',[7.3,111]],['C',[13.35,109.75,17,105.55]],['C',[20.6,101.4,20.8,95.2]],['L',[20.8,81.7]],['L',[6.9,81.7]],['L',[6.9,95.2]]];
			__motifs["-"] = [['M',[4.9,73.35]],['L',[34,73.35]],['L',[34,62.6]],['L',[4.9,62.6]],['L',[4.9,73.35]]];
			__motifs["."] = [['M',[6.9,95.2]],['L',[20.8,95.2]],['L',[20.8,81.7]],['L',[6.9,81.7]],['L',[6.9,95.2]]];
			__motifs["/"] = [['M',[26.5,22.1]],['L',[-2.2,96.9]],['L',[8.7,96.9]],['L',[37.4,22.1]],['L',[26.5,22.1]]];
			__motifs[":"] = [['M',[6.9,44.6]],['L',[6.9,58.1]],['L',[20.8,58.1]],['L',[20.8,44.6]],['L',[6.9,44.6]],['M',[6.9,95.2]],['L',[20.8,95.2]],['L',[20.8,81.7]],['L',[6.9,81.7]],['L',[6.9,95.2]]];
			__motifs[";"] = [['M',[6.9,44.6]],['L',[6.9,58.1]],['L',[20.8,58.1]],['L',[20.8,44.6]],['L',[6.9,44.6]],['M',[6.9,95.2]],['L',[13.75,95.2]],['C',[13.85,98.5,12.2,101.25]],['C',[10.6,104,7.3,104.9]],['L',[7.3,111]],['C',[13.35,109.75,17,105.55]],['C',[20.6,101.4,20.8,95.2]],['L',[20.8,81.7]],['L',[6.9,81.7]],['L',[6.9,95.2]]];
			__motifs["<"] = [['M',[4.6,73.5]],['L',[55.35,96.05]],['L',[55.35,85.85]],['L',[17.95,69.9]],['L',[55.35,54.05]],['L',[55.35,43.85]],['L',[4.6,66.35]],['L',[4.6,73.5]]];
			__motifs["="] = [['M',[4.8,85.1]],['L',[55.2,85.1]],['L',[55.2,74.9]],['L',[4.8,74.9]],['L',[4.8,85.1]],['M',[4.8,64.95]],['L',[55.2,64.95]],['L',[55.2,54.7]],['L',[4.8,54.7]],['L',[4.8,64.95]]];
			__motifs[">"] = [['M',[4.6,96.05]],['L',[55.35,73.5]],['L',[55.35,66.35]],['L',[4.6,43.85]],['L',[4.6,54.05]],['L',[42,69.9]],['L',[4.6,85.85]],['L',[4.6,96.05]]];
			__motifs["?"] = [['M',[47.75,31.35]],['C',[44.85,26.85,39.95,24.5]],['C',[35.05,22.1,28.9,22.1]],['C',[21.55,22.15,16.15,25.2]],['C',[10.75,28.2,7.85,33.7]],['C',[4.95,39.15,4.95,46.5]],['L',[16.3,46.5]],['C',[16.3,39.7,19.3,35.7]],['C',[22.25,31.7,28.35,31.65]],['C',[30.25,31.6,32.5,32.7]],['C',[34.75,33.75,36.45,36.2]],['C',[38.1,38.7,38.2,42.7]],['C',[38.15,46.05,37.05,48.2]],['C',[35.95,50.4,34.1,52.05]],['L',[30.1,55.5]],['C',[27.45,57.75,25.75,60.25]],['C',[24,62.75,23.15,66.4]],['C',[22.3,70.05,22.3,75.8]],['L',[33.1,75.8]],['C',[33.1,71.1,34.25,68.15]],['C',[35.35,65.15,37.35,63.05]],['C',[39.3,60.95,41.9,58.9]],['L',[46.15,55.05]],['C',[48.1,53,49.35,50]],['C',[50.65,46.95,50.7,42.3]],['C',[50.65,35.85,47.75,31.35]],['M',[20.8,95.2]],['L',[34.2,95.2]],['L',[34.2,82.7]],['L',[20.8,82.7]],['L',[20.8,95.2]]];
			__motifs["@"] = [['M',[41.6,22.1]],['C',[34.1,22.15,27.5,24.9]],['C',[20.85,27.65,15.75,32.6]],['C',[10.7,37.5,7.8,44.05]],['C',[4.95,50.55,4.9,58.2]],['C',[5,69.7,9.95,78.4]],['C',[14.9,87.1,23.3,92]],['C',[31.7,96.8,42.1,96.9]],['C',[51.45,96.85,59.3,92.55]],['C',[67.1,88.3,72,80.5]],['L',[65,80.5]],['C',[60.9,85.2,55,87.8]],['C',[49.1,90.35,42.55,90.4]],['C',[34,90.35,27.3,86.5]],['C',[20.65,82.65,16.8,75.5]],['C',[13,68.4,12.9,58.6]],['C',[12.95,50.2,16.55,43.4]],['C',[20.15,36.65,26.6,32.65]],['C',[33.05,28.7,41.6,28.6]],['C',[48.95,28.65,55.05,31.55]],['C',[61.05,34.4,64.65,39.75]],['C',[68.2,45.1,68.3,52.6]],['C',[68.25,58.75,66.3,63.6]],['C',[64.4,68.5,61.45,71.3]],['C',[58.5,74.15,55.3,74.2]],['C',[54,74.15,53.6,73.15]],['C',[53.25,72.05,53.5,70.5]],['C',[53.75,68.9,54.3,67.3]],['L',[61.5,41]],['L',[54.5,41]],['L',[52.75,46.7]],['C',[50.85,42.9,47.95,41.2]],['C',[45.05,39.5,41.5,39.5]],['C',[36.55,39.55,32.5,41.75]],['C',[28.5,44,25.65,47.7]],['C',[22.7,51.4,21.15,56]],['C',[19.6,60.6,19.6,65.35]],['C',[19.65,69.7,21.55,73.3]],['C',[23.45,76.8,26.7,78.95]],['C',[30,81.05,34.2,81.1]],['C',[37.45,81,40.4,79.35]],['C',[43.3,77.7,45.4,75.4]],['L',[45.6,75.4]],['C',[45.8,78.3,47.45,79.75]],['C',[49.1,81.2,51.5,81.2]],['C',[54.65,81.2,58.6,79.4]],['C',[62.6,77.5,66.35,73.8]],['C',[70.05,70.15,72.55,64.55]],['C',[75,58.9,75.1,51.4]],['C',[75.05,44.9,72.35,39.6]],['C',[69.7,34.2,65.05,30.3]],['C',[60.35,26.4,54.35,24.25]],['C',[48.35,22.15,41.6,22.1]],['M',[30.2,71.05]],['C',[28.15,68.55,28.1,64.5]],['C',[28.1,60.65,29.8,56.65]],['C',[31.55,52.6,34.6,49.9]],['C',[37.7,47.1,41.9,47]],['C',[45.2,47.1,47.45,49.65]],['C',[49.7,52.2,49.8,55.8]],['C',[49.8,58.6,48.8,61.65]],['C',[47.75,64.75,45.9,67.4]],['C',[44.1,70.1,41.55,71.8]],['C',[39.05,73.5,36.1,73.55]],['C',[32.35,73.5,30.2,71.05]]];
			__motifs["["] = [['M',[7.25,22.1]],['L',[7.25,114.3]],['L',[29.5,114.3]],['L',[29.5,105.3]],['L',[18,105.3]],['L',[18,31.1]],['L',[29.5,31.1]],['L',[29.5,22.1]],['L',[7.25,22.1]]];
			__motifs["\\"] = [['M',[37.4,96.9]],['L',[8.7,22.1]],['L',[-2.2,22.1]],['L',[26.5,96.9]],['L',[37.4,96.9]]];
			__motifs["]"] = [['M',[11.6,31.1]],['L',[11.6,105.3]],['L',[0.15,105.3]],['L',[0.15,114.3]],['L',[22.4,114.3]],['L',[22.4,22.1]],['L',[0.15,22.1]],['L',[0.15,31.1]],['L',[11.6,31.1]]];
			__motifs["^"] = [['M',[26.4,25.2]],['L',[8.4,61.7]],['L',[18.6,61.7]],['L',[30.05,37]],['L',[41.4,61.7]],['L',[51.6,61.7]],['L',[33.6,25.2]],['L',[26.4,25.2]]];
			__motifs["_"] = [['M',[50,102.7]],['L',[0,102.7]],['L',[0,107.7]],['L',[50,107.7]],['L',[50,102.7]]];
			__motifs["`"] = [['M',[10.55,22.1]],['L',[-2.9,22.1]],['L',[11.35,36.4]],['L',[19.65,36.4]],['L',[10.55,22.1]]];
		}

		static private function initializeWidthsUppercase():void {
			__widths["A"] = 67;
			__widths["B"] = 70;
			__widths["C"] = 72;
			__widths["D"] = 72;
			__widths["E"] = 63;
			__widths["F"] = 59;
			__widths["G"] = 76;
			__widths["H"] = 72;
			__widths["I"] = 28;
			__widths["J"] = 54;
			__widths["K"] = 69;
			__widths["L"] = 57;
			__widths["M"] = 89;
			__widths["N"] = 72;
			__widths["O"] = 76;
			__widths["P"] = 67;
			__widths["Q"] = 76;
			__widths["R"] = 70;
			__widths["S"] = 65;
			__widths["T"] = 59;
			__widths["U"] = 72;
			__widths["V"] = 61;
			__widths["W"] = 94;
			__widths["X"] = 65;
			__widths["Y"] = 65;
			__widths["Z"] = 63;
		}

		static private function initializeWidthsLowercase():void {
			__widths["a"] = 56;
			__widths["b"] = 61;
			__widths["c"] = 56;
			__widths["d"] = 61;
			__widths["e"] = 56;
			__widths["f"] = 32;
			__widths["g"] = 59;
			__widths["h"] = 57;
			__widths["i"] = 24;
			__widths["j"] = 24;
			__widths["k"] = 54;
			__widths["l"] = 24;
			__widths["m"] = 87;
			__widths["n"] = 57;
			__widths["o"] = 59;
			__widths["p"] = 61;
			__widths["q"] = 61;
			__widths["r"] = 35;
			__widths["s"] = 52;
			__widths["t"] = 33;
			__widths["u"] = 57;
			__widths["v"] = 52;
			__widths["w"] = 78;
			__widths["x"] = 54;
			__widths["y"] = 52;
			__widths["z"] = 50;
		}

		static private function initializeWidthsNumbers():void {
			__widths["0"] = 56;
			__widths["1"] = 56;
			__widths["2"] = 56;
			__widths["3"] = 56;
			__widths["4"] = 56;
			__widths["5"] = 56;
			__widths["6"] = 56;
			__widths["7"] = 56;
			__widths["8"] = 56;
			__widths["9"] = 56;
		}

		static private function initializeWidthsPunctuation():void {
			__widths[" "] = 28;
			__widths["!"] = 28;
			__widths["\""] = 44;
			__widths["#"] = 56;
			__widths["$"] = 56;
			__widths["%"] = 100;
			__widths["&"] = 65;
			__widths["'"] = 28;
			__widths["("] = 28;
			__widths[")"] = 28;
			__widths["*"] = 37;
			__widths["+"] = 60;
			__widths[","] = 28;
			__widths["-"] = 39;
			__widths["."] = 28;
			__widths["/"] = 35;
			__widths[":"] = 28;
			__widths[";"] = 28;
			__widths["<"] = 60;
			__widths["="] = 60;
			__widths[">"] = 60;
			__widths["?"] = 56;
			__widths["@"] = 80;
			__widths["["] = 30;
			__widths["\\"] = 35;
			__widths["]"] = 30;
			__widths["^"] = 60;
			__widths["_"] = 50;
			__widths["`"] = 24;
		}

	}

}