package org.papervision3d.objects.special {
	import org.papervision3d.core.geom.Vertices3D;
	import org.papervision3d.core.geom.renderables.Vertex3D;
	import org.papervision3d.core.proto.GeometryObject3D;
	import org.papervision3d.core.proto.MaterialObject3D;
	import org.papervision3d.core.render.command.RenderVectorShape;
	import org.papervision3d.core.render.data.RenderSessionData;
	import org.papervision3d.materials.special.VectorShapeMaterial;
	import org.papervision3d.objects.DisplayObject3D;		

	/**
	 * @author Mark Barcinski
	 */

	public class VectorShape3D extends Vertices3D {
		public var graphicsCommands:Array;
		public var renderCommand : RenderVectorShape;
		public var graphics : Graphics3D;
		
		public function VectorShape3D(material : MaterialObject3D , vertices : Array = null, name : String = null) {
			graphics = new Graphics3D(this);
			graphicsCommands = [];
			renderCommand = new RenderVectorShape(this);
			renderCommand.renderer = material as VectorShapeMaterial;
			this.material = material;
			
			super(vertices, name);
		}
		
		public override function project( parent :DisplayObject3D,  renderSessionData:RenderSessionData ):Number
		{
			var temp:Number = super.project( parent, renderSessionData );
			//trace("temp" , temp)
			//if(temp == 0)return 0;


			var visible:Boolean = false;
			var screenZ:Number = 0;
			
			for each(var vertex:Vertex3D in geometry.vertices){
				screenZ += vertex.vertex3DInstance.z;
				visible = ( vertex.vertex3DInstance.z > 0 || visible);
			}
			
			if(visible)
			{
				renderSessionData.renderer.addToRenderList(renderCommand);
				this.screenZ = screenZ / geometry.vertices.length;
				renderCommand.screenZ = this.screenZ;
			}
				
			return temp;
		}
		
		override public function set material(material:MaterialObject3D):void
		{
			super.material = material;
			renderCommand.renderer = material as VectorShapeMaterial;
		}
	}
}
