package org.papervision3d.core.render.command {
	import flash.events.Event;	
	
	import org.papervision3d.view.Viewport3D;	
	
	import flash.display.Sprite;
	
	/**
	 * @author Mark Barcinski
	 */
	public class VectorShapeHitTest extends Sprite {
		private static var _instance : VectorShapeHitTest;
		private var viewport : Viewport3D;

		static public function get instance():VectorShapeHitTest
		{
			if(_instance == null)_instance = new VectorShapeHitTest();
			
			_instance.alpha = 0;
			_instance.mouseEnabled = false;
			return _instance;
		}
		
		public function VectorShapeHitTest() {
			
		}
		
		public function assignViewport(viewport : Viewport3D) : void {
			instance.viewport = viewport;
			
			instance.x = viewport.containerSprite.x;
			instance.y = viewport.containerSprite.y;
			
			viewport.addChild(_instance);
			try {
				viewport.stage.addEventListener(Event.RESIZE, onStageResized);
			} catch(e:Error){
				// TODO add onAddedToStage	
			}
		}
		
		private function onStageResized(event : Event) : void {
			_instance.x = viewport.containerSprite.x;
			_instance.y = viewport.containerSprite.y;
		}

		override public function hitTestPoint(x : Number, y : Number, shapeFlag : Boolean = false) : Boolean{
			if(viewport){
				return super.hitTestPoint(x + viewport.containerSprite.x,  y + viewport.containerSprite.y, shapeFlag);	
			}
			
			//if there is no viewport, shapeFlag has to be false or it will never return a hit
			return super.hitTestPoint(x,  y, false);	
		}
	}
}
