package org.papervision3d.core.math 
{
	import org.papervision3d.Papervision3D;	
	
	/**
	 * PLUG-IN MEDIA 2D Vector Class, by Seb Lee-Delisle re-written for Papervision3D as Number2D. 
	 *  
	 * Version 0.1 10 Feb 2008	
	 */
	public class Number2D 
	{
		public static const RADTODEG : Number = 180/Math.PI;		
		public static const DEGTORAD : Number = Math.PI/180;
		
		public var x:Number; 
		public var y:Number; 
		
		public function Number2D (x:Number = 0, y:Number = 0)
		{
			this.x = x; 
			this.y = y; 
		}
		
	 
	 	public function toString():String
		{
		    var x:Number = Math.round (this.x * 1000) / 1000;
			var y:Number = Math.round (this.y * 1000) / 1000;
			return "[" + x + ", " + y + "]";
		}
		
		public function clone():Number2D
		{
			return new Number2D(this.x, this.y);
		}
		
		public function copyTo(v:Number2D):void
		{
			v.x = this.x;
			v.y = this.y;
		}
		public function copyFrom(v:Number2D):void
		{
			this.x = v.x;
			this.y = v.y;
		}	
		
		public function get modulo():Number 
		{
			return Math.sqrt((x*x)+(y*y));
		}
		
		public function normalise():void 
		{
			var m:Number = this.modulo;
			
			this.x = this.x/m;
			this.y = this.y/m;
	
			
		}
		
		public function reverse():void 
		{
			this.x = -this.x;
			this.y = -this.y;
		}
		
		public static function add(v:Number2D, w:Number2D): Number2D {
			
			return new Number2D( v.x+w.x, v.y+w.y);
	
		}
		public static function subtract(v:Number2D, w:Number2D): Number2D {
			
			return new Number2D( v.x-w.x, v.y-w.y);
	
		}	
		public function plusEq(v:Number2D) :void
		{
			x+=v.x; 
			y+=v.y; 
			
		}
		public function minusEq(v:Number2D) :void
		{
			x-=v.x; 
			y-=v.y; 
			
		}
		
		public function divideEq(d : Number) : void
		{
			x/=d; 
			y/=d; 
		}
		public function multiplyEq(d : Number) : void
		{
			x*=d; 
			y*=d; 
		}
		
		
		public static function multiplyScalar(v:Number2D, n:Number) : Number2D
		{
			return new Number2D
			(
				v.x*n,
				v.y*n
			);
			
		}
	

		
		public static function dot(v:Number2D, w:Number2D):Number
		{
			return v.x * w.x + v.y * w.y ;
		}
		
		
		public function angle():Number
		{
			
			if(Papervision3D.useDEGREES)
				return ( RADTODEG*(Math.atan2(y,x)));
			else 
				return (Math.atan2(y,x));
			
	
		}
		
		
	
		public function rotate(angle:Number) :void{
			if(Papervision3D.useDEGREES) angle*=DEGTORAD;
			var cosRY:Number = Math.cos(angle);
			var sinRY:Number = Math.sin(angle);
			var temp:Number2D;
	
			temp = clone();
			
			
			this.x= (temp.x*cosRY)-(temp.y*sinRY);
			this.y= (temp.x*sinRY)+(temp.y*cosRY);
			
			
		}	
		
		
		public function reset(x:Number = 0, y:Number = 0) :void
		{
			
			this.x = x;
			this.y = y;
	
		}

		// ______________________________________________________________________
		
		/**
		 * Super fast modulo(length, magnitude) comparisons.
		 * 
		 *  
		 */
		 
		public function isModuloLessThan(v:Number):Boolean
		{
				
			return (moduloSquared<(v*v)); 
			
		}
		
		public function isModuloGreaterThan(v:Number):Boolean
		{
				
			return (moduloSquared>(v*v)); 
			
		}
		public function isModuloEqualTo(v:Number):Boolean
		{
				
			return (moduloSquared==(v*v)); 
			
		}
			
		public function get moduloSquared():Number
		{
			return ( this.x*this.x + this.y*this.y );
		}
		
	
	}
	
	
	
}